import { ICell, IRow } from '../Table';
/**
 * Function to join parent and their children so they can be rendered in tbody.
 * @param {*} rows raw data to find out if it's child or parent.
 * @param {*} children data to render (array of react children).
 */
export declare const mapOpenedRows: (rows: IRow[], children: any) => IRow[];
/**
 * Function to calculate columns based on custom config.
 * It adds some custom cells for collapse, select, if expanded row and actions.
 * @param {*} headerRows custom object with described table header cells.
 * @param {*} extra object with custom callbacks.
 * @return {*} expected object for react tabular table.
 */
export declare const calculateColumns: (headerRows: (string | ICell)[], extra: any) => {
    property: string;
    extraParams: any;
    data: any;
    header: {
        label: string | ICell;
        transforms: ((...args: any) => any)[];
        formatters: ((...args: any) => any)[];
        title?: string;
        cellTransforms?: ((...args: any) => any)[];
        columnTransforms?: ((...args: any) => any)[];
        cellFormatters?: ((...args: any) => any)[];
        props?: any;
        data?: any;
        header?: any;
        cell?: any;
    };
    cell: {
        transforms: ((_label: import("../Table").IFormatterValueType, { property, rowData }: import("../Table").IExtra) => any)[];
        formatters: ((...args: any) => any)[];
        title?: string;
        cellTransforms?: ((...args: any) => any)[];
        columnTransforms?: ((...args: any) => any)[];
        cellFormatters?: ((...args: any) => any)[];
        props?: any;
        data?: any;
        header?: any;
        cell?: any;
    };
    props: any;
}[];
