(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-icons", "@patternfly/react-styles", "@patternfly/react-core", "@patternfly/react-styles/css/components/Table/table"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-icons"), require("@patternfly/react-styles"), require("@patternfly/react-core"), require("@patternfly/react-styles/css/components/Table/table"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactIcons, global.reactStyles, global.reactCore, global.table);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _reactIcons, _reactStyles, _reactCore, _table) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.CollapseColumn = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _table2 = _interopRequireDefault(_table);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  const CollapseColumn = exports.CollapseColumn = _ref => {
    let {
      className = '',
      children = null,
      isOpen,
      onToggle
    } = _ref,
        props = _objectWithoutProperties(_ref, ["className", "children", "isOpen", "onToggle"]);

    return React.createElement(React.Fragment, null, isOpen !== undefined && React.createElement(_reactCore.Button, _extends({
      className: (0, _reactStyles.css)(className, isOpen && _table2.default.modifiers.expanded)
    }, props, {
      variant: "plain",
      "aria-label": "Details",
      onClick: onToggle,
      "aria-expanded": isOpen
    }), React.createElement(_reactIcons.AngleDownIcon, null)), children);
  };

  CollapseColumn.propTypes = {
    id: _propTypes2.default.string,
    className: _propTypes2.default.string,
    children: _propTypes2.default.node,
    onToggle: _propTypes2.default.func,
    isOpen: _propTypes2.default.bool
  };
});
//# sourceMappingURL=CollapseColumn.js.map