(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "./decorators/selectable", "./decorators/sortable", "./decorators/cellActions", "./decorators/cellWidth", "./decorators/wrappable", "./decorators/textCenter", "./decorators/collapsible", "./decorators/compoundExpand", "./decorators/headerCol", "./decorators/classNames"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("./decorators/selectable"), require("./decorators/sortable"), require("./decorators/cellActions"), require("./decorators/cellWidth"), require("./decorators/wrappable"), require("./decorators/textCenter"), require("./decorators/collapsible"), require("./decorators/compoundExpand"), require("./decorators/headerCol"), require("./decorators/classNames"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.selectable, global.sortable, global.cellActions, global.cellWidth, global.wrappable, global.textCenter, global.collapsible, global.compoundExpand, global.headerCol, global.classNames);
    global.undefined = mod.exports;
  }
})(this, function (exports, _selectable, _sortable, _cellActions, _cellWidth, _wrappable, _textCenter, _collapsible, _compoundExpand, _headerCol, _classNames) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  Object.defineProperty(exports, "selectable", {
    enumerable: true,
    get: function () {
      return _selectable.selectable;
    }
  });
  Object.defineProperty(exports, "sortable", {
    enumerable: true,
    get: function () {
      return _sortable.sortable;
    }
  });
  Object.defineProperty(exports, "cellActions", {
    enumerable: true,
    get: function () {
      return _cellActions.cellActions;
    }
  });
  Object.defineProperty(exports, "cellWidth", {
    enumerable: true,
    get: function () {
      return _cellWidth.cellWidth;
    }
  });
  Object.defineProperty(exports, "wrappable", {
    enumerable: true,
    get: function () {
      return _wrappable.wrappable;
    }
  });
  Object.defineProperty(exports, "textCenter", {
    enumerable: true,
    get: function () {
      return _textCenter.textCenter;
    }
  });
  Object.defineProperty(exports, "collapsible", {
    enumerable: true,
    get: function () {
      return _collapsible.collapsible;
    }
  });
  Object.defineProperty(exports, "expandedRow", {
    enumerable: true,
    get: function () {
      return _collapsible.expandedRow;
    }
  });
  Object.defineProperty(exports, "expandable", {
    enumerable: true,
    get: function () {
      return _collapsible.expandable;
    }
  });
  Object.defineProperty(exports, "compoundExpand", {
    enumerable: true,
    get: function () {
      return _compoundExpand.compoundExpand;
    }
  });
  Object.defineProperty(exports, "headerCol", {
    enumerable: true,
    get: function () {
      return _headerCol.headerCol;
    }
  });
  Object.defineProperty(exports, "classNames", {
    enumerable: true,
    get: function () {
      return _classNames.classNames;
    }
  });
  Object.defineProperty(exports, "Visibility", {
    enumerable: true,
    get: function () {
      return _classNames.Visibility;
    }
  });

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};
      var ownKeys = Object.keys(source);

      if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }

      ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  const emptyTD = () => ({
    scope: '',
    component: 'td'
  });

  const scopeColTransformer = () => ({
    scope: 'col'
  });

  const emptyCol = label => _objectSpread({}, label ? {} : {
    scope: ''
  });

  const parentId = (_value, {
    rowData
  }) => ({
    parentId: rowData.parent
  });

  const mapProps = (_label, {
    property,
    rowData
  }) => _objectSpread({}, rowData[property] && rowData[property].props);

  exports.emptyTD = emptyTD;
  exports.scopeColTransformer = scopeColTransformer;
  exports.emptyCol = emptyCol;
  exports.parentId = parentId;
  exports.mapProps = mapProps;
});
//# sourceMappingURL=transformers.js.map