# Hindi (hi) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                       | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ----------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | १९८७                                                  | Invalid Date             |
|                                 |              | 0005-01-01T12:13:14.015Z | ५                                                     | Invalid Date             |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | १९८७                                                  | Invalid Date             |
|                                 |              | 0005-01-01T12:13:14.015Z | ४                                                     | Invalid Date             |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | १                                                     | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | २                                                     | Invalid Date             |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | ति1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ति2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | पहली तिमाही                                           | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | दूसरी तिमाही                                          | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                     | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | १                                                     | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | २                                                     | Invalid Date             |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | ति1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ति2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | पहली तिमाही                                           | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | दूसरी तिमाही                                          | Invalid Date             |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | २                                                     | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | ७                                                     | Invalid Date             |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | फ़र                                                   | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | जुल                                                   | 2019-01-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | फ़रवरी                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | जुलाई                                                 | 2019-01-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | फ़                                                    | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | जु                                                    | Invalid Date             |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | २                                                     | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | ७                                                     | Invalid Date             |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | फ़र                                                   | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | जुल                                                   | 2019-01-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | फ़रवरी                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | जुलाई                                                 | 2019-01-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | फ़                                                    | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | जु                                                    | Invalid Date             |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | १                                                     | Invalid Date             |
|                                 |              | 2019-12-01T12:13:14.015Z | ४९                                                    | Invalid Date             |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | १                                                     | Invalid Date             |
|                                 |              | 2019-12-01T12:13:14.015Z | ४८                                                    | Invalid Date             |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | ११                                                    | Invalid Date             |
|                                 |              | 2019-02-28T12:13:14.015Z | २८                                                    | Invalid Date             |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | ४२                                                    | Invalid Date             |
|                                 |              | 2019-12-31T12:13:14.015Z | ३६५                                                   | Invalid Date             |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | सोम                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | शुक्र                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | सोम                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | शुक्र                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | सोम                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | शुक्र                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | सोमवार                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | शुक्रवार                                              | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | सो                                                    | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | शु                                                    | Invalid Date             |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | सो                                                    | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | शु                                                    | Invalid Date             |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | १                                                     | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ५                                                     | Invalid Date             |
|                                 | iii          | 2019-02-11T12:13:14.015Z | सोम                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | शुक्र                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | सोमवार                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | शुक्रवार                                              | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | सो                                                    | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | शु                                                    | Invalid Date             |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | सो                                                    | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | शु                                                    | Invalid Date             |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | २                                                     | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ६                                                     | Invalid Date             |
|                                 | eee          | 2019-02-11T12:13:14.015Z | सोम                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | शुक्र                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | सोमवार                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | शुक्रवार                                              | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | सो                                                    | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | शु                                                    | Invalid Date             |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | सो                                                    | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | शु                                                    | Invalid Date             |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | २                                                     | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ६                                                     | Invalid Date             |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | सोम                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | शुक्र                                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | सोमवार                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | शुक्रवार                                              | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | सो                                                    | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | शु                                                    | Invalid Date             |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | सो                                                    | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | शु                                                    | Invalid Date             |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | पूर्वाह्न                                             | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | अपराह्न                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | अपराह्न                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | पूर्वाह्न                                             | Invalid Date             |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | अपराह्न                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | पूर्वाह्न                                             | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | पूर्वाह्न                                             | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | अपराह्न                                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | अपराह्न                                               | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | पूर्वाह्न                                             | Invalid Date             |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | सुबह                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | दोपहर                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | शाम                                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | रात                                                   | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | सुबह                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | दोपहर                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | शाम                                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | रात                                                   | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | सुबह                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | दोपहर                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | शाम                                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | रात                                                   | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | सुबह                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | दोपहर                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | शाम                                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | रात                                                   | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | सुबह                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | दोपहर                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | शाम                                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | रात                                                   | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | ११                                                    | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | ११                                                    | Invalid Date             |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | ११                                                    | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | २३                                                    | Invalid Date             |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | ११                                                    | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | ११                                                    | Invalid Date             |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | ११                                                    | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | २३                                                    | Invalid Date             |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | १                                                     | Invalid Date             |
|                                 |              | 2019-04-01T12:55:14.015Z | ५५                                                    | Invalid Date             |
| Second                          | so           | 2019-01-01T12:13:01.015Z | १                                                     | Invalid Date             |
|                                 |              | 2019-04-01T12:13:55.015Z | ५५                                                    | Invalid Date             |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/02/1987                                            | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                            | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 फ़र, 1987                                          | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 मई, 1453                                           | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | ११ फ़रवरी, 1987                                       | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | २९ मई, 1453                                           | Invalid Date             |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | बुधवार, ११ फ़रवरी, 1987                               | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | रविवार, २९ मई, 1453                                   | Invalid Date             |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13 अपराह्न                                         | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 अपराह्न                                         | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14 अपराह्न                                      | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 अपराह्न                                      | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 अपराह्न GMT+0                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 अपराह्न GMT+0                                | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 अपराह्न GMT+00:00                            | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 अपराह्न GMT+00:00                            | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13 अपराह्न                             | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 11:59 अपराह्न                             | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 फ़र, 1987, 12:13:14 अपराह्न                        | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 मई, 1453, 11:59:59 अपराह्न                         | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | ११ फ़रवरी, 1987 को 12:13:14 अपराह्न GMT+0             | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | २९ मई, 1453 को 11:59:59 अपराह्न GMT+0                 | Invalid Date             |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | बुधवार, ११ फ़रवरी, 1987 को 12:13:14 अपराह्न GMT+00:00 | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | रविवार, २९ मई, 1453 को 11:59:59 अपराह्न GMT+00:00     | Invalid Date             |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result         | `includeSeconds: true` | `addSuffix: true`   |
| ------------------------ | -------------- | ---------------------- | ------------------- |
| 2006-01-01T00:00:00.000Z | लगभग ६ वर्ष    | लगभग ६ वर्ष            | लगभग ६ वर्षमे       |
| 2005-01-01T00:00:00.000Z | लगभग ५ वर्ष    | लगभग ५ वर्ष            | लगभग ५ वर्षमे       |
| 2004-01-01T00:00:00.000Z | लगभग ४ वर्ष    | लगभग ४ वर्ष            | लगभग ४ वर्षमे       |
| 2003-01-01T00:00:00.000Z | लगभग ३ वर्ष    | लगभग ३ वर्ष            | लगभग ३ वर्षमे       |
| 2002-01-01T00:00:00.000Z | लगभग २ वर्ष    | लगभग २ वर्ष            | लगभग २ वर्षमे       |
| 2001-06-01T00:00:00.000Z | १ वर्ष से अधिक | १ वर्ष से अधिक         | १ वर्ष से अधिकमे    |
| 2001-02-01T00:00:00.000Z | लगभग १ वर्ष    | लगभग १ वर्ष            | लगभग १ वर्षमे       |
| 2001-01-01T00:00:00.000Z | लगभग १ वर्ष    | लगभग १ वर्ष            | लगभग १ वर्षमे       |
| 2000-06-01T00:00:00.000Z | ५ महीने        | ५ महीने                | ५ महीनेमे           |
| 2000-03-01T00:00:00.000Z | २ महीने        | २ महीने                | २ महीनेमे           |
| 2000-02-01T00:00:00.000Z | लगभग १ महीना   | लगभग १ महीना           | लगभग १ महीनामे      |
| 2000-01-15T00:00:00.000Z | १४ दिन         | १४ दिन                 | १४ दिनमे            |
| 2000-01-02T00:00:00.000Z | १ दिन          | १ दिन                  | १ दिनमे             |
| 2000-01-01T06:00:00.000Z | लगभग ६ घंटे    | लगभग ६ घंटे            | लगभग ६ घंटेमे       |
| 2000-01-01T01:00:00.000Z | लगभग १ घंटा    | लगभग १ घंटा            | लगभग १ घंटामे       |
| 2000-01-01T00:45:00.000Z | लगभग १ घंटा    | लगभग १ घंटा            | लगभग १ घंटामे       |
| 2000-01-01T00:30:00.000Z | ३० मिनट        | ३० मिनट                | ३० मिनटमे           |
| 2000-01-01T00:15:00.000Z | १५ मिनट        | १५ मिनट                | १५ मिनटमे           |
| 2000-01-01T00:01:00.000Z | १ मिनट         | १ मिनट                 | १ मिनटमे            |
| 2000-01-01T00:00:25.000Z | १ मिनट से कम   | आधा मिनट               | १ मिनट से कममे      |
| 2000-01-01T00:00:15.000Z | १ मिनट से कम   | २० सेकंड से कम         | १ मिनट से कममे      |
| 2000-01-01T00:00:05.000Z | १ मिनट से कम   | १० सेकंड से कम         | १ मिनट से कममे      |
| 2000-01-01T00:00:00.000Z | १ मिनट से कम   | ५ सेकंड से कम          | १ मिनट से कम पहले   |
| 1999-12-31T23:59:55.000Z | १ मिनट से कम   | १० सेकंड से कम         | १ मिनट से कम पहले   |
| 1999-12-31T23:59:45.000Z | १ मिनट से कम   | २० सेकंड से कम         | १ मिनट से कम पहले   |
| 1999-12-31T23:59:35.000Z | १ मिनट से कम   | आधा मिनट               | १ मिनट से कम पहले   |
| 1999-12-31T23:59:00.000Z | १ मिनट         | १ मिनट                 | १ मिनट पहले         |
| 1999-12-31T23:45:00.000Z | १५ मिनट        | १५ मिनट                | १५ मिनट पहले        |
| 1999-12-31T23:30:00.000Z | ३० मिनट        | ३० मिनट                | ३० मिनट पहले        |
| 1999-12-31T23:15:00.000Z | लगभग १ घंटा    | लगभग १ घंटा            | लगभग १ घंटा पहले    |
| 1999-12-31T23:00:00.000Z | लगभग १ घंटा    | लगभग १ घंटा            | लगभग १ घंटा पहले    |
| 1999-12-31T18:00:00.000Z | लगभग ६ घंटे    | लगभग ६ घंटे            | लगभग ६ घंटे पहले    |
| 1999-12-30T00:00:00.000Z | २ दिन          | २ दिन                  | २ दिन पहले          |
| 1999-12-15T00:00:00.000Z | १७ दिन         | १७ दिन                 | १७ दिन पहले         |
| 1999-12-01T00:00:00.000Z | लगभग १ महीना   | लगभग १ महीना           | लगभग १ महीना पहले   |
| 1999-11-01T00:00:00.000Z | २ महीने        | २ महीने                | २ महीने पहले        |
| 1999-06-01T00:00:00.000Z | ७ महीने        | ७ महीने                | ७ महीने पहले        |
| 1999-01-01T00:00:00.000Z | लगभग १ वर्ष    | लगभग १ वर्ष            | लगभग १ वर्ष पहले    |
| 1998-12-01T00:00:00.000Z | लगभग १ वर्ष    | लगभग १ वर्ष            | लगभग १ वर्ष पहले    |
| 1998-06-01T00:00:00.000Z | १ वर्ष से अधिक | १ वर्ष से अधिक         | १ वर्ष से अधिक पहले |
| 1998-01-01T00:00:00.000Z | लगभग २ वर्ष    | लगभग २ वर्ष            | लगभग २ वर्ष पहले    |
| 1997-01-01T00:00:00.000Z | लगभग ३ वर्ष    | लगभग ३ वर्ष            | लगभग ३ वर्ष पहले    |
| 1996-01-01T00:00:00.000Z | लगभग ४ वर्ष    | लगभग ४ वर्ष            | लगभग ४ वर्ष पहले    |
| 1995-01-01T00:00:00.000Z | लगभग ५ वर्ष    | लगभग ५ वर्ष            | लगभग ५ वर्ष पहले    |
| 1994-01-01T00:00:00.000Z | लगभग ६ वर्ष    | लगभग ६ वर्ष            | लगभग ६ वर्ष पहले    |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result   | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | -------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | ६ वर्ष   | ६ वर्षमे          | ५२६०८ घंटे                     |
| 2005-01-01T00:00:00.000Z | ५ वर्ष   | ५ वर्षमे          | ४३८४८ घंटे                     |
| 2004-01-01T00:00:00.000Z | ४ वर्ष   | ४ वर्षमे          | ३५०६४ घंटे                     |
| 2003-01-01T00:00:00.000Z | ३ वर्ष   | ३ वर्षमे          | २६३०४ घंटे                     |
| 2002-01-01T00:00:00.000Z | २ वर्ष   | २ वर्षमे          | १७५४४ घंटे                     |
| 2001-06-01T00:00:00.000Z | १ वर्ष   | १ वर्षमे          | १२४०८ घंटे                     |
| 2001-02-01T00:00:00.000Z | १ वर्ष   | १ वर्षमे          | ९५२८ घंटे                      |
| 2001-01-01T00:00:00.000Z | १ वर्ष   | १ वर्षमे          | ८७८४ घंटे                      |
| 2000-06-01T00:00:00.000Z | ५ महीने  | ५ महीनेमे         | ३६४८ घंटे                      |
| 2000-03-01T00:00:00.000Z | २ महीने  | २ महीनेमे         | १४४० घंटे                      |
| 2000-02-01T00:00:00.000Z | १ महीना  | १ महीनामे         | ७४४ घंटे                       |
| 2000-01-15T00:00:00.000Z | १४ दिन   | १४ दिनमे          | ३३६ घंटे                       |
| 2000-01-02T00:00:00.000Z | १ दिन    | १ दिनमे           | २४ घंटे                        |
| 2000-01-01T06:00:00.000Z | ६ घंटे   | ६ घंटेमे          | ६ घंटे                         |
| 2000-01-01T01:00:00.000Z | १ घंटा   | १ घंटामे          | १ घंटा                         |
| 2000-01-01T00:45:00.000Z | ४५ मिनट  | ४५ मिनटमे         | १ घंटा                         |
| 2000-01-01T00:30:00.000Z | ३० मिनट  | ३० मिनटमे         | १ घंटा                         |
| 2000-01-01T00:15:00.000Z | १५ मिनट  | १५ मिनटमे         | ० घंटे                         |
| 2000-01-01T00:01:00.000Z | १ मिनट   | १ मिनटमे          | ० घंटे                         |
| 2000-01-01T00:00:25.000Z | २५ सेकंड | २५ सेकंडमे        | ० घंटे                         |
| 2000-01-01T00:00:15.000Z | १५ सेकंड | १५ सेकंडमे        | ० घंटे                         |
| 2000-01-01T00:00:05.000Z | ५ सेकंड  | ५ सेकंडमे         | ० घंटे                         |
| 2000-01-01T00:00:00.000Z | ० सेकंड  | ० सेकंड पहले      | ० घंटे                         |
| 1999-12-31T23:59:55.000Z | ५ सेकंड  | ५ सेकंड पहले      | ० घंटे                         |
| 1999-12-31T23:59:45.000Z | १५ सेकंड | १५ सेकंड पहले     | ० घंटे                         |
| 1999-12-31T23:59:35.000Z | २५ सेकंड | २५ सेकंड पहले     | ० घंटे                         |
| 1999-12-31T23:59:00.000Z | १ मिनट   | १ मिनट पहले       | ० घंटे                         |
| 1999-12-31T23:45:00.000Z | १५ मिनट  | १५ मिनट पहले      | ० घंटे                         |
| 1999-12-31T23:30:00.000Z | ३० मिनट  | ३० मिनट पहले      | १ घंटा                         |
| 1999-12-31T23:15:00.000Z | ४५ मिनट  | ४५ मिनट पहले      | १ घंटा                         |
| 1999-12-31T23:00:00.000Z | १ घंटा   | १ घंटा पहले       | १ घंटा                         |
| 1999-12-31T18:00:00.000Z | ६ घंटे   | ६ घंटे पहले       | ६ घंटे                         |
| 1999-12-30T00:00:00.000Z | २ दिन    | २ दिन पहले        | ४८ घंटे                        |
| 1999-12-15T00:00:00.000Z | १७ दिन   | १७ दिन पहले       | ४०८ घंटे                       |
| 1999-12-01T00:00:00.000Z | १ महीना  | १ महीना पहले      | ७४४ घंटे                       |
| 1999-11-01T00:00:00.000Z | २ महीने  | २ महीने पहले      | १४६४ घंटे                      |
| 1999-06-01T00:00:00.000Z | ७ महीने  | ७ महीने पहले      | ५१३६ घंटे                      |
| 1999-01-01T00:00:00.000Z | १ वर्ष   | १ वर्ष पहले       | ८७६० घंटे                      |
| 1998-12-01T00:00:00.000Z | १ वर्ष   | १ वर्ष पहले       | ९५०४ घंटे                      |
| 1998-06-01T00:00:00.000Z | २ वर्ष   | २ वर्ष पहले       | १३८९६ घंटे                     |
| 1998-01-01T00:00:00.000Z | २ वर्ष   | २ वर्ष पहले       | १७५२० घंटे                     |
| 1997-01-01T00:00:00.000Z | ३ वर्ष   | ३ वर्ष पहले       | २६२८० घंटे                     |
| 1996-01-01T00:00:00.000Z | ४ वर्ष   | ४ वर्ष पहले       | ३५०६४ घंटे                     |
| 1995-01-01T00:00:00.000Z | ५ वर्ष   | ५ वर्ष पहले       | ४३८२४ घंटे                     |
| 1994-01-01T00:00:00.000Z | ६ वर्ष   | ६ वर्ष पहले       | ५२५८४ घंटे                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                       |
| ------------------------ | ---------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                   |
| 2000-01-05T00:00:00.000Z | बुधवार को 12:00 पूर्वाह्न    |
| 2000-01-02T00:00:00.000Z | कल 12:00 पूर्वाह्न           |
| 2000-01-01T00:00:00.000Z | आज 12:00 पूर्वाह्न           |
| 1999-12-31T00:00:00.000Z | कल 12:00 पूर्वाह्न           |
| 1999-12-27T00:00:00.000Z | पिछले सोमवार 12:00 पूर्वाह्न |
| 1999-12-21T00:00:00.000Z | 21/12/1999                   |
