'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports['default'] = createMountWrapper;

var _object = require('object.assign');

var _object2 = _interopRequireDefault(_object);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _RootFinder = require('./RootFinder');

var _RootFinder2 = _interopRequireDefault(_RootFinder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/* eslint react/forbid-prop-types: 0 */

var stringOrFunction = _propTypes2['default'].oneOfType([_propTypes2['default'].func, _propTypes2['default'].string]);
var makeValidElementType = function makeValidElementType(adapter) {
  if (!adapter) {
    return stringOrFunction;
  }

  function validElementType(props, propName) {
    if (!adapter.isValidElementType) {
      for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        args[_key - 2] = arguments[_key];
      }

      return stringOrFunction.apply(undefined, [props, propName].concat(args));
    }
    var propValue = props[propName];
    if (propValue == null || adapter.isValidElementType(propValue)) {
      return null;
    }
    return new TypeError(String(propName) + ' must be a valid element type!');
  }
  validElementType.isRequired = function () {
    function validElementTypeRequired(props, propName) {
      if (!adapter.isValidElementType) {
        for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
          args[_key2 - 2] = arguments[_key2];
        }

        return stringOrFunction.isRequired.apply(stringOrFunction, [props, propName].concat(args));
      }
      var propValue = props[propName]; // eslint-disable-line react/destructuring-assignment
      if (adapter.isValidElementType(propValue)) {
        return null;
      }
      return new TypeError(String(propName) + ' must be a valid element type!');
    }

    return validElementTypeRequired;
  }();
  return validElementType;
};

/**
 * This is a utility component to wrap around the nodes we are
 * passing in to `mount()`. Theoretically, you could do everything
 * we are doing without this, but this makes it easier since
 * `renderIntoDocument()` doesn't really pass back a reference to
 * the DOM node it rendered to, so we can't really "re-render" to
 * pass new props in.
 */
function createMountWrapper(node) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var adapter = options.adapter,
      WrappingComponent = options.wrappingComponent;

  var WrapperComponent = function (_React$Component) {
    _inherits(WrapperComponent, _React$Component);

    function WrapperComponent() {
      var _ref;

      _classCallCheck(this, WrapperComponent);

      for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      var _this = _possibleConstructorReturn(this, (_ref = WrapperComponent.__proto__ || Object.getPrototypeOf(WrapperComponent)).call.apply(_ref, [this].concat(args)));

      var _this$props = _this.props,
          props = _this$props.props,
          wrappingComponentProps = _this$props.wrappingComponentProps,
          context = _this$props.context;

      _this.rootFinderInstance = null;
      _this.state = {
        mount: true,
        props: props,
        wrappingComponentProps: wrappingComponentProps,
        context: context
      };
      return _this;
    }

    _createClass(WrapperComponent, [{
      key: 'setChildProps',
      value: function () {
        function setChildProps(newProps, newContext) {
          var callback = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : undefined;
          var _state = this.state,
              oldProps = _state.props,
              oldContext = _state.context;

          var props = (0, _object2['default'])({}, oldProps, newProps);
          var context = (0, _object2['default'])({}, oldContext, newContext);
          this.setState({ props: props, context: context }, callback);
        }

        return setChildProps;
      }()
    }, {
      key: 'setWrappingComponentProps',
      value: function () {
        function setWrappingComponentProps(props) {
          var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;

          this.setState({ wrappingComponentProps: props }, callback);
        }

        return setWrappingComponentProps;
      }()
    }, {
      key: 'getInstance',
      value: function () {
        function getInstance() {
          var component = this._reactInternalInstance._renderedComponent;
          var inst = component.getPublicInstance();
          if (inst === null) {
            return component._instance;
          }
          return inst;
        }

        return getInstance;
      }()
    }, {
      key: 'getWrappedComponent',
      value: function () {
        function getWrappedComponent() {
          var component = this._reactInternalInstance._renderedComponent;
          var inst = component.getPublicInstance();
          if (inst === null) {
            return component._instance;
          }
          return inst;
        }

        return getWrappedComponent;
      }()
    }, {
      key: 'setChildContext',
      value: function () {
        function setChildContext(context) {
          var _this2 = this;

          return new Promise(function (resolve) {
            return _this2.setState({ context: context }, resolve);
          });
        }

        return setChildContext;
      }()
    }, {
      key: 'render',
      value: function () {
        function render() {
          var Component = this.props.Component;
          var _state2 = this.state,
              mount = _state2.mount,
              props = _state2.props,
              wrappingComponentProps = _state2.wrappingComponentProps;

          if (!mount) return null;
          var component = _react2['default'].createElement(Component, props);
          if (WrappingComponent) {
            return _react2['default'].createElement(
              WrappingComponent,
              wrappingComponentProps,
              _react2['default'].createElement(
                _RootFinder2['default'],
                null,
                component
              )
            );
          }
          return component;
        }

        return render;
      }()
    }]);

    return WrapperComponent;
  }(_react2['default'].Component);

  WrapperComponent.propTypes = {
    Component: makeValidElementType(adapter).isRequired,
    props: _propTypes2['default'].object.isRequired,
    wrappingComponentProps: _propTypes2['default'].object,
    context: _propTypes2['default'].object
  };
  WrapperComponent.defaultProps = {
    context: null,
    wrappingComponentProps: null
  };

  if (options.context && (node.type.contextTypes || options.childContextTypes)) {
    // For full rendering, we are using this wrapper component to provide context if it is
    // specified in both the options AND the child component defines `contextTypes` statically
    // OR the merged context types for all children (the node component or deeper children) are
    // specified in options parameter under childContextTypes.
    // In that case, we define both a `getChildContext()` function and a `childContextTypes` prop.
    var childContextTypes = (0, _object2['default'])({}, node.type.contextTypes, options.childContextTypes);

    WrapperComponent.prototype.getChildContext = function () {
      function getChildContext() {
        return this.state.context;
      }

      return getChildContext;
    }();
    WrapperComponent.childContextTypes = childContextTypes;
  }
  return WrapperComponent;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=createMountWrapper.js.map