"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _experimentalUtils = require("@typescript-eslint/experimental-utils");

var _utils = require("./utils");

var _default = (0, _utils.createRule)({
  name: __filename,
  meta: {
    docs: {
      category: 'Best Practices',
      description: 'Prevents exports from test files. If a file has at least 1 test in it, then this rule will prevent exports.',
      recommended: false
    },
    messages: {
      unexpectedExport: `Do not export from a test file.`
    },
    type: 'suggestion',
    schema: []
  },
  defaultOptions: [],

  create(context) {
    const exportNodes = [];
    let hasTestCase = false;
    return {
      'Program:exit'() {
        if (hasTestCase && exportNodes.length > 0) {
          for (var _i = 0, _exportNodes = exportNodes; _i < _exportNodes.length; _i++) {
            const node = _exportNodes[_i];
            context.report({
              node,
              messageId: 'unexpectedExport'
            });
          }
        }
      },

      CallExpression(node) {
        if ((0, _utils.isTestCase)(node)) {
          hasTestCase = true;
        }
      },

      'ExportNamedDeclaration, ExportDefaultDeclaration'(node) {
        exportNodes.push(node);
      },

      'AssignmentExpression > MemberExpression'(node) {
        let object = node.object,
            property = node.property;

        if (object.type === _experimentalUtils.AST_NODE_TYPES.MemberExpression) {
          var _object = object;
          object = _object.object;
          property = _object.property;
        }

        if ('name' in object && object.name === 'module' && property.type === _experimentalUtils.AST_NODE_TYPES.Identifier && /^exports?$/.test(property.name)) {
          exportNodes.push(node);
        }
      }

    };
  }

});

exports.default = _default;