'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _Resizable = require('./Resizable');

var _Resizable2 = _interopRequireDefault(_Resizable);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// An example use of Resizable.
var ResizableBox = function (_React$Component) {
  _inherits(ResizableBox, _React$Component);

  function ResizableBox() {
    var _temp, _this, _ret;

    _classCallCheck(this, ResizableBox);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.state = {
      width: _this.props.width,
      height: _this.props.height
    }, _this.onResize = function (e, data) {
      var size = data.size;
      var width = size.width,
          height = size.height;


      if (_this.props.onResize) {
        e.persist && e.persist();
        _this.setState(size, function () {
          return _this.props.onResize && _this.props.onResize(e, data);
        });
      } else {
        _this.setState(size);
      }
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  ResizableBox.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    if (nextProps.width !== this.props.width || nextProps.height !== this.props.height) {
      this.setState({
        width: nextProps.width,
        height: nextProps.height
      });
    }
  };

  ResizableBox.prototype.render = function render() {
    // Basic wrapper around a Resizable instance.
    // If you use Resizable directly, you are responsible for updating the child component
    // with a new width and height.
    var _props = this.props,
        handle = _props.handle,
        handleSize = _props.handleSize,
        onResize = _props.onResize,
        onResizeStart = _props.onResizeStart,
        onResizeStop = _props.onResizeStop,
        draggableOpts = _props.draggableOpts,
        minConstraints = _props.minConstraints,
        maxConstraints = _props.maxConstraints,
        lockAspectRatio = _props.lockAspectRatio,
        axis = _props.axis,
        width = _props.width,
        height = _props.height,
        resizeHandles = _props.resizeHandles,
        props = _objectWithoutProperties(_props, ['handle', 'handleSize', 'onResize', 'onResizeStart', 'onResizeStop', 'draggableOpts', 'minConstraints', 'maxConstraints', 'lockAspectRatio', 'axis', 'width', 'height', 'resizeHandles']);

    return _react2.default.createElement(
      _Resizable2.default,
      {
        handle: handle,
        handleSize: handleSize,
        width: this.state.width,
        height: this.state.height,
        onResizeStart: onResizeStart,
        onResize: this.onResize,
        onResizeStop: onResizeStop,
        draggableOpts: draggableOpts,
        minConstraints: minConstraints,
        maxConstraints: maxConstraints,
        lockAspectRatio: lockAspectRatio,
        axis: axis,
        resizeHandles: resizeHandles
      },
      _react2.default.createElement('div', _extends({ style: { width: this.state.width + 'px', height: this.state.height + 'px' } }, props))
    );
  };

  return ResizableBox;
}(_react2.default.Component);

ResizableBox.propTypes = {
  height: _propTypes2.default.number,
  width: _propTypes2.default.number
};
ResizableBox.defaultProps = {
  handleSize: [20, 20]
};
exports.default = ResizableBox;