/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.rotation;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.rotation.view.ShiftTemplateView;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;

@Entity
public class ShiftTemplate
extends AbstractPersistable {
    @NotNull
    @ManyToOne
    private Spot spot;
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="ShiftTemplateRequiredSkillSet", joinColumns={@JoinColumn(name="shiftTemplateId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="skillId", referencedColumnName="id")})
    private Set<Skill> requiredSkillSet;
    @NotNull
    private Integer startDayOffset;
    @NotNull
    private LocalTime startTime;
    @NotNull
    private Integer endDayOffset;
    @NotNull
    private LocalTime endTime;
    @ManyToOne
    private Employee rotationEmployee;

    public ShiftTemplate() {
    }

    public ShiftTemplate(Integer tenantId, Spot spot, int startDayOffset, LocalTime startTime, int endDayOffset, LocalTime endTime) {
        this(tenantId, spot, startDayOffset, startTime, endDayOffset, endTime, null);
    }

    public ShiftTemplate(Integer tenantId, Spot spot, int startDayOffset, LocalTime startTime, int endDayOffset, LocalTime endTime, Employee rotationEmployee) {
        this(tenantId, spot, startDayOffset, startTime, endDayOffset, endTime, rotationEmployee, Collections.emptySet());
    }

    public ShiftTemplate(Integer tenantId, Spot spot, int startDayOffset, LocalTime startTime, int endDayOffset, LocalTime endTime, Employee rotationEmployee, Collection<Skill> requiredSkillSet) {
        super(tenantId);
        this.rotationEmployee = rotationEmployee;
        this.spot = spot;
        this.startDayOffset = startDayOffset;
        this.endDayOffset = endDayOffset;
        this.startTime = startTime;
        this.endTime = endTime;
        this.requiredSkillSet = new HashSet<Skill>(requiredSkillSet);
    }

    public ShiftTemplate(Integer rotationLength, ShiftTemplateView shiftTemplateView, Spot spot, Employee rotationEmployee, Collection<Skill> requiredSkillSet) {
        super((AbstractPersistable)shiftTemplateView);
        this.spot = spot;
        this.rotationEmployee = rotationEmployee;
        this.startDayOffset = (int)shiftTemplateView.getDurationBetweenRotationStartAndTemplateStart().toDays();
        this.startTime = LocalTime.ofSecondOfDay(shiftTemplateView.getDurationBetweenRotationStartAndTemplateStart().minusDays(this.startDayOffset.intValue()).getSeconds());
        int endDayAfterStartDay = (int)shiftTemplateView.getDurationBetweenRotationStartAndTemplateStart().plus(shiftTemplateView.getShiftTemplateDuration()).toDays();
        this.endTime = LocalTime.ofSecondOfDay(shiftTemplateView.getDurationBetweenRotationStartAndTemplateStart().plus(shiftTemplateView.getShiftTemplateDuration()).minusDays(endDayAfterStartDay).getSeconds());
        this.endDayOffset = endDayAfterStartDay % rotationLength;
        this.requiredSkillSet = new HashSet<Skill>(requiredSkillSet);
    }

    public Shift createShiftOnDate(LocalDate startDate, int rotationLength, ZoneId zoneId, boolean defaultToRotationEmployee) {
        LocalDateTime startDateTime = startDate.atTime(this.getStartTime());
        LocalDate endDate = this.getStartDayOffset() <= this.getEndDayOffset() ? startDate.plusDays(this.getEndDayOffset() - this.getStartDayOffset()) : startDate.plusDays(rotationLength + this.getEndDayOffset() - this.getStartDayOffset());
        LocalDateTime endDateTime = endDate.atTime(this.getEndTime());
        OffsetDateTime startOffsetDateTime = OffsetDateTime.of(startDateTime, zoneId.getRules().getOffset(startDateTime));
        OffsetDateTime endOffsetDateTime = OffsetDateTime.of(endDateTime, zoneId.getRules().getOffset(endDateTime));
        Shift shift = new Shift(this.getTenantId(), this.getSpot(), startOffsetDateTime, endOffsetDateTime, this.rotationEmployee, new HashSet(this.requiredSkillSet), null);
        if (defaultToRotationEmployee) {
            shift.setEmployee(this.rotationEmployee);
        }
        return shift;
    }

    public Spot getSpot() {
        return this.spot;
    }

    public void setSpot(Spot spot) {
        this.spot = spot;
    }

    public Integer getStartDayOffset() {
        return this.startDayOffset;
    }

    public void setStartDayOffset(Integer offsetStartDay) {
        this.startDayOffset = offsetStartDay;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public Integer getEndDayOffset() {
        return this.endDayOffset;
    }

    public void setEndDayOffset(Integer offsetEndDay) {
        this.endDayOffset = offsetEndDay;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public Employee getRotationEmployee() {
        return this.rotationEmployee;
    }

    public void setRotationEmployee(Employee rotationEmployee) {
        this.rotationEmployee = rotationEmployee;
    }

    public Set<Skill> getRequiredSkillSet() {
        return this.requiredSkillSet;
    }

    public void setRequiredSkillSet(Set<Skill> requiredSkillSet) {
        this.requiredSkillSet = requiredSkillSet;
    }
}

