/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.tenant;

import java.time.DayOfWeek;
import javax.persistence.Entity;
import javax.validation.constraints.NotNull;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;

@Entity
@ConstraintConfiguration(constraintPackage="org.optaweb.employeerostering.service.solver")
public class RosterConstraintConfiguration
extends AbstractPersistable {
    public static final String CONSTRAINT_REQUIRED_SKILL_FOR_A_SHIFT = "Required skill for a shift";
    public static final String CONSTRAINT_UNAVAILABLE_TIME_SLOT_FOR_AN_EMPLOYEE = "Unavailable time slot for an employee";
    public static final String CONSTRAINT_NO_OVERLAPPING_SHIFTS = "No overlapping shifts";
    public static final String CONSTRAINT_NO_MORE_THAN_2_CONSECUTIVE_SHIFTS = "No more than 2 consecutive shifts";
    public static final String CONSTRAINT_BREAK_BETWEEN_NON_CONSECUTIVE_SHIFTS = "Break between non-consecutive shifts is at least 10 hours";
    public static final String CONSTRAINT_DAILY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM = "Daily minutes must not exceed contract maximum";
    public static final String CONSTRAINT_WEEKLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM = "Weekly minutes must not exceed contract maximum";
    public static final String CONSTRAINT_MONTHLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM = "Monthly minutes must not exceed contract maximum";
    public static final String CONSTRAINT_YEARLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM = "Yearly minutes must not exceed contract maximum";
    public static final String CONSTRAINT_ASSIGN_EVERY_SHIFT = "Assign every shift";
    public static final String CONSTRAINT_EMPLOYEE_IS_NOT_ORIGINAL_EMPLOYEE = "Employee is not original employee";
    public static final String CONSTRAINT_UNDESIRED_TIME_SLOT_FOR_AN_EMPLOYEE = "Undesired time slot for an employee";
    public static final String CONSTRAINT_DESIRED_TIME_SLOT_FOR_AN_EMPLOYEE = "Desired time slot for an employee";
    public static final String CONSTRAINT_EMPLOYEE_IS_NOT_ROTATION_EMPLOYEE = "Employee is not rotation employee";
    @NotNull
    private DayOfWeek weekStartDay = DayOfWeek.MONDAY;
    @ConstraintWeight(value="Required skill for a shift")
    private HardMediumSoftLongScore requiredSkill = HardMediumSoftLongScore.ofHard((long)100L);
    @ConstraintWeight(value="Unavailable time slot for an employee")
    private HardMediumSoftLongScore unavailableTimeSlot = HardMediumSoftLongScore.ofHard((long)50L);
    @ConstraintWeight(value="No overlapping shifts")
    private HardMediumSoftLongScore noOverlappingShifts = HardMediumSoftLongScore.ofHard((long)20L);
    @ConstraintWeight(value="No more than 2 consecutive shifts")
    private HardMediumSoftLongScore noMoreThan2ConsecutiveShifts = HardMediumSoftLongScore.ofHard((long)10L);
    @ConstraintWeight(value="Break between non-consecutive shifts is at least 10 hours")
    private HardMediumSoftLongScore breakBetweenNonConsecutiveShiftsAtLeast10Hours = HardMediumSoftLongScore.ofHard((long)1L);
    @ConstraintWeight(value="Daily minutes must not exceed contract maximum")
    private HardMediumSoftLongScore contractMaximumDailyMinutes = HardMediumSoftLongScore.ofHard((long)1L);
    @ConstraintWeight(value="Weekly minutes must not exceed contract maximum")
    private HardMediumSoftLongScore contractMaximumWeeklyMinutes = HardMediumSoftLongScore.ofHard((long)1L);
    @ConstraintWeight(value="Monthly minutes must not exceed contract maximum")
    private HardMediumSoftLongScore contractMaximumMonthlyMinutes = HardMediumSoftLongScore.ofHard((long)1L);
    @ConstraintWeight(value="Yearly minutes must not exceed contract maximum")
    private HardMediumSoftLongScore contractMaximumYearlyMinutes = HardMediumSoftLongScore.ofHard((long)1L);
    @ConstraintWeight(value="Assign every shift")
    private HardMediumSoftLongScore assignEveryShift = HardMediumSoftLongScore.ofMedium((long)1L);
    @ConstraintWeight(value="Employee is not original employee")
    private HardMediumSoftLongScore notOriginalEmployee = HardMediumSoftLongScore.ofSoft((long)100000000000L);
    @ConstraintWeight(value="Undesired time slot for an employee")
    private HardMediumSoftLongScore undesiredTimeSlot = HardMediumSoftLongScore.ofSoft((long)20L);
    @ConstraintWeight(value="Desired time slot for an employee")
    private HardMediumSoftLongScore desiredTimeSlot = HardMediumSoftLongScore.ofSoft((long)10L);
    @ConstraintWeight(value="Employee is not rotation employee")
    private HardMediumSoftLongScore notRotationEmployee = HardMediumSoftLongScore.ofSoft((long)50L);

    public RosterConstraintConfiguration() {
        super(Integer.valueOf(-1));
    }

    public RosterConstraintConfiguration(Integer tenantId, DayOfWeek weekStartDay) {
        super(tenantId);
        this.weekStartDay = weekStartDay;
    }

    public DayOfWeek getWeekStartDay() {
        return this.weekStartDay;
    }

    public void setWeekStartDay(DayOfWeek weekStartDay) {
        this.weekStartDay = weekStartDay;
    }

    public HardMediumSoftLongScore getRequiredSkill() {
        return this.requiredSkill;
    }

    public void setRequiredSkill(HardMediumSoftLongScore requiredSkill) {
        this.requiredSkill = requiredSkill;
    }

    public HardMediumSoftLongScore getUnavailableTimeSlot() {
        return this.unavailableTimeSlot;
    }

    public void setUnavailableTimeSlot(HardMediumSoftLongScore unavailableTimeSlot) {
        this.unavailableTimeSlot = unavailableTimeSlot;
    }

    public HardMediumSoftLongScore getNoOverlappingShifts() {
        return this.noOverlappingShifts;
    }

    public void setNoOverlappingShifts(HardMediumSoftLongScore noOverlappingShifts) {
        this.noOverlappingShifts = noOverlappingShifts;
    }

    public HardMediumSoftLongScore getNoMoreThan2ConsecutiveShifts() {
        return this.noMoreThan2ConsecutiveShifts;
    }

    public void setNoMoreThan2ConsecutiveShifts(HardMediumSoftLongScore noMoreThan2ConsecutiveShifts) {
        this.noMoreThan2ConsecutiveShifts = noMoreThan2ConsecutiveShifts;
    }

    public HardMediumSoftLongScore getBreakBetweenNonConsecutiveShiftsAtLeast10Hours() {
        return this.breakBetweenNonConsecutiveShiftsAtLeast10Hours;
    }

    public void setBreakBetweenNonConsecutiveShiftsAtLeast10Hours(HardMediumSoftLongScore breakBetweenNonConsecutiveShiftsAtLeast10Hours) {
        this.breakBetweenNonConsecutiveShiftsAtLeast10Hours = breakBetweenNonConsecutiveShiftsAtLeast10Hours;
    }

    public HardMediumSoftLongScore getContractMaximumDailyMinutes() {
        return this.contractMaximumDailyMinutes;
    }

    public void setContractMaximumDailyMinutes(HardMediumSoftLongScore contractMaximumDailyMinutes) {
        this.contractMaximumDailyMinutes = contractMaximumDailyMinutes;
    }

    public HardMediumSoftLongScore getContractMaximumWeeklyMinutes() {
        return this.contractMaximumWeeklyMinutes;
    }

    public void setContractMaximumWeeklyMinutes(HardMediumSoftLongScore contractMaximumWeeklyMinutes) {
        this.contractMaximumWeeklyMinutes = contractMaximumWeeklyMinutes;
    }

    public HardMediumSoftLongScore getContractMaximumMonthlyMinutes() {
        return this.contractMaximumMonthlyMinutes;
    }

    public void setContractMaximumMonthlyMinutes(HardMediumSoftLongScore contractMaximumMonthlyMinutes) {
        this.contractMaximumMonthlyMinutes = contractMaximumMonthlyMinutes;
    }

    public HardMediumSoftLongScore getContractMaximumYearlyMinutes() {
        return this.contractMaximumYearlyMinutes;
    }

    public void setContractMaximumYearlyMinutes(HardMediumSoftLongScore contractMaximumYearlyMinutes) {
        this.contractMaximumYearlyMinutes = contractMaximumYearlyMinutes;
    }

    public HardMediumSoftLongScore getAssignEveryShift() {
        return this.assignEveryShift;
    }

    public void setAssignEveryShift(HardMediumSoftLongScore assignEveryShift) {
        this.assignEveryShift = assignEveryShift;
    }

    public HardMediumSoftLongScore getNotOriginalEmployee() {
        return this.notOriginalEmployee;
    }

    public void setNotOriginalEmployee(HardMediumSoftLongScore notOriginalEmployee) {
        this.notOriginalEmployee = notOriginalEmployee;
    }

    public HardMediumSoftLongScore getUndesiredTimeSlot() {
        return this.undesiredTimeSlot;
    }

    public void setUndesiredTimeSlot(HardMediumSoftLongScore undesiredTimeSlot) {
        this.undesiredTimeSlot = undesiredTimeSlot;
    }

    public HardMediumSoftLongScore getDesiredTimeSlot() {
        return this.desiredTimeSlot;
    }

    public void setDesiredTimeSlot(HardMediumSoftLongScore desiredTimeSlot) {
        this.desiredTimeSlot = desiredTimeSlot;
    }

    public HardMediumSoftLongScore getNotRotationEmployee() {
        return this.notRotationEmployee;
    }

    public void setNotRotationEmployee(HardMediumSoftLongScore notRotationEmployee) {
        this.notRotationEmployee = notRotationEmployee;
    }
}

