/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.contract;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.contract.view.ContractView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class ContractRestControllerTest
extends AbstractEntityRequireTenantRestServiceTest {
    @Autowired
    private TestRestTemplate restTemplate;
    private final String contractPathURI = "http://localhost:8080/rest/tenant/{tenantId}/contract/";

    private ResponseEntity<List<Contract>> getContracts(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/contract/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Contract>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<Contract> getContract(Integer tenantId, Long id) {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/{tenantId}/contract/" + id, Contract.class, new Object[]{tenantId});
    }

    private void deleteContract(Integer tenantId, Long id) {
        this.restTemplate.delete("http://localhost:8080/rest/tenant/{tenantId}/contract/" + id, new Object[]{tenantId});
    }

    private ResponseEntity<Contract> addContract(Integer tenantId, ContractView contractView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/contract/add", (Object)contractView, Contract.class, new Object[]{tenantId});
    }

    private ResponseEntity<Contract> updateContract(Integer tenantId, ContractView contractView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/contract/update", (Object)contractView, Contract.class, new Object[]{tenantId});
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void contractCrudTest() {
        Integer maximumMinutesPerDay = 50;
        Integer maximumMinutesPerWeek = 250;
        Integer maximumMinutesPerMonth = 1000;
        Integer maximumMinutesPerYear = 12000;
        ContractView contractView = new ContractView(this.TENANT_ID, "contract", maximumMinutesPerDay, maximumMinutesPerWeek, maximumMinutesPerMonth, maximumMinutesPerYear);
        ResponseEntity<Contract> postResponse = this.addContract(this.TENANT_ID, contractView);
        Assertions.assertThat((Comparable)postResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        ResponseEntity<Contract> response = this.getContract(this.TENANT_ID, ((Contract)postResponse.getBody()).getId());
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)response.getBody()).isEqualToComparingFieldByFieldRecursively(postResponse.getBody());
        ContractView updatedContractView = new ContractView(this.TENANT_ID, "updatedContract", maximumMinutesPerDay, maximumMinutesPerWeek, maximumMinutesPerMonth, maximumMinutesPerYear);
        updatedContractView.setId(((Contract)postResponse.getBody()).getId());
        ResponseEntity<Contract> putResponse = this.updateContract(this.TENANT_ID, updatedContractView);
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        response = this.getContract(this.TENANT_ID, ((Contract)putResponse.getBody()).getId());
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)putResponse.getBody()).isEqualToComparingFieldByFieldRecursively(response.getBody());
        this.deleteContract(this.TENANT_ID, ((Contract)putResponse.getBody()).getId());
        ResponseEntity<List<Contract>> getListResponse = this.getContracts(this.TENANT_ID);
        Assertions.assertThat((Comparable)getListResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)getListResponse.getBody())).isEmpty();
    }
}

