/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.rotation;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.rotation.view.ShiftTemplateView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class RotationRestControllerTest
extends AbstractEntityRequireTenantRestServiceTest {
    @Autowired
    private TestRestTemplate restTemplate;
    private final String shiftTemplatePathURI = "http://localhost:8080/rest/tenant/{tenantId}/rotation/";
    private final String spotPathURI = "http://localhost:8080/rest/tenant/{tenantId}/spot/";

    private ResponseEntity<List<ShiftTemplateView>> getShiftTemplates(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/rotation/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ShiftTemplateView>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<ShiftTemplateView> getShiftTemplate(Integer tenantId, Long id) {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/{tenantId}/rotation/" + id, ShiftTemplateView.class, new Object[]{tenantId});
    }

    private void deleteShiftTemplate(Integer tenantId, Long id) {
        this.restTemplate.delete("http://localhost:8080/rest/tenant/{tenantId}/rotation/" + id, new Object[]{tenantId});
    }

    private ResponseEntity<ShiftTemplateView> addShiftTemplate(Integer tenantId, ShiftTemplateView shiftTemplateView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/rotation/add", (Object)shiftTemplateView, ShiftTemplateView.class, new Object[]{tenantId});
    }

    private ResponseEntity<ShiftTemplateView> updateShiftTemplate(Integer tenantId, HttpEntity<ShiftTemplateView> request) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/rotation/update", HttpMethod.PUT, request, ShiftTemplateView.class, new Object[]{tenantId});
    }

    private ResponseEntity<Spot> addSpot(Integer tenantId, SpotView spotView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/spot/add", (Object)spotView, Spot.class, new Object[]{tenantId});
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void shiftTemplateCrudTest() {
        ResponseEntity<Spot> spotResponseA = this.addSpot(this.TENANT_ID, new SpotView(this.TENANT_ID, "A", Collections.emptySet()));
        Spot spotA = (Spot)spotResponseA.getBody();
        ShiftTemplateView shiftTemplateView = new ShiftTemplateView(this.TENANT_ID, spotA.getId(), Duration.ofDays(0L), Duration.ofDays(0L), null, Collections.emptyList());
        ResponseEntity<ShiftTemplateView> postResponse = this.addShiftTemplate(this.TENANT_ID, shiftTemplateView);
        Assertions.assertThat((Comparable)postResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        ResponseEntity<ShiftTemplateView> response = this.getShiftTemplate(this.TENANT_ID, ((ShiftTemplateView)postResponse.getBody()).getId());
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)response.getBody()).isEqualToComparingFieldByFieldRecursively(postResponse.getBody());
        ShiftTemplateView updatedShiftTemplate = new ShiftTemplateView(this.TENANT_ID, spotA.getId(), Duration.ofDays(1L), Duration.ofDays(1L), null, Collections.emptyList());
        updatedShiftTemplate.setId(((ShiftTemplateView)postResponse.getBody()).getId());
        HttpEntity request = new HttpEntity((Object)updatedShiftTemplate);
        ResponseEntity<ShiftTemplateView> putResponse = this.updateShiftTemplate(this.TENANT_ID, (HttpEntity<ShiftTemplateView>)request);
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        response = this.getShiftTemplate(this.TENANT_ID, ((ShiftTemplateView)putResponse.getBody()).getId());
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)putResponse.getBody()).isEqualTo(response.getBody());
        this.deleteShiftTemplate(this.TENANT_ID, ((ShiftTemplateView)putResponse.getBody()).getId());
        ResponseEntity<List<ShiftTemplateView>> getListResponse = this.getShiftTemplates(this.TENANT_ID);
        Assertions.assertThat((Comparable)getListResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)getListResponse.getBody())).isEmpty();
    }
}

