/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.rotation;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.rotation.view.ShiftTemplateView;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.optaweb.employeerostering.service.rotation.RotationService;
import org.optaweb.employeerostering.service.spot.SpotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringRunner.class)
@SpringBootTest
@AutoConfigureTestDatabase
@AutoConfigureMockMvc
@Transactional
public class RotationServiceTest
extends AbstractEntityRequireTenantRestServiceTest {
    private static final Logger logger = LoggerFactory.getLogger(RotationServiceTest.class);
    @Autowired
    private MockMvc mvc;
    @Autowired
    private RotationService rotationService;
    @Autowired
    private SpotService spotService;

    private Spot createSpot(Integer tenantId, String name, Set<Skill> requiredSkillSet) {
        SpotView spotView = new SpotView(tenantId, name, requiredSkillSet);
        return this.spotService.createSpot(tenantId, spotView);
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void getShiftTemplateListTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/rotation/", (Object[])new Object[]{this.TENANT_ID}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getShiftTemplateTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        ShiftTemplateView shiftTemplateView = new ShiftTemplateView(this.TENANT_ID, spot.getId(), Duration.ofDays(0L), Duration.ofDays(0L), null, Collections.emptyList());
        ShiftTemplateView persistedShiftTemplate = this.rotationService.createShiftTemplate(this.TENANT_ID, shiftTemplateView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/rotation/{id}", (Object[])new Object[]{this.TENANT_ID, persistedShiftTemplate.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.spotId", (Object[])new Object[0]).value((Object)spot.getId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.durationBetweenRotationStartAndTemplateStart", (Object[])new Object[0]).value((Object)"PT0S")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.shiftTemplateDuration", (Object[])new Object[0]).value((Object)"PT0S"));
    }

    @Test
    public void getNonExistentShiftTemplateTest() throws Exception {
        String exceptionMessage = "No ShiftTemplate entity found with ID (0).";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/rotation/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void deleteShiftTemplateTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        ShiftTemplateView shiftTemplateView = new ShiftTemplateView(this.TENANT_ID, spot.getId(), Duration.ofDays(0L), Duration.ofDays(0L), null, Collections.emptyList());
        ShiftTemplateView persistedShiftTemplate = this.rotationService.createShiftTemplate(this.TENANT_ID, shiftTemplateView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/rotation/{id}", (Object[])new Object[]{this.TENANT_ID, persistedShiftTemplate.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("true"));
    }

    @Test
    public void deleteNonMatchingShiftTemplateTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        ShiftTemplateView shiftTemplateView = new ShiftTemplateView(this.TENANT_ID, spot.getId(), Duration.ofDays(0L), Duration.ofDays(0L), null, Collections.emptyList());
        ShiftTemplateView persistedShiftTemplate = this.rotationService.createShiftTemplate(this.TENANT_ID, shiftTemplateView);
        String shiftTemplateName = "[ShiftTemplate-" + persistedShiftTemplate.getId() + "]";
        String exceptionMessage = "The tenantId (0) does not match the persistable (" + shiftTemplateName + ")'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/rotation/{id}", (Object[])new Object[]{0, persistedShiftTemplate.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void createShiftTemplateTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        ShiftTemplateView shiftTemplateView = new ShiftTemplateView(this.TENANT_ID, spot.getId(), Duration.ofDays(0L), Duration.ofDays(0L), null, Collections.emptyList());
        String body = new ObjectMapper().writeValueAsString((Object)shiftTemplateView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/rotation/add", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.spotId", (Object[])new Object[0]).value((Object)spot.getId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.durationBetweenRotationStartAndTemplateStart", (Object[])new Object[0]).value((Object)"PT0S")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.shiftTemplateDuration", (Object[])new Object[0]).value((Object)"PT0S"));
    }

    @Test
    public void createNonMatchingShiftTemplateTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        ShiftTemplateView shiftTemplateView = new ShiftTemplateView(Integer.valueOf(0), spot.getId(), Duration.ofDays(0L), Duration.ofDays(0L), null, Collections.emptyList());
        String body = new ObjectMapper().writeValueAsString((Object)shiftTemplateView);
        String shiftTemplateName = "[ShiftTemplate-null]";
        String exceptionMessage = "The tenantId (" + this.TENANT_ID + ") does not match the persistable (" + shiftTemplateName + ")'s tenantId (0).";
        String exceptionClass = "java.lang.IllegalStateException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/rotation/add", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateShiftTemplateTest() throws Exception {
        Spot spotA = this.createSpot(this.TENANT_ID, "A", Collections.emptySet());
        Spot spotB = this.createSpot(this.TENANT_ID, "B", Collections.emptySet());
        ShiftTemplateView shiftTemplateView = new ShiftTemplateView(this.TENANT_ID, spotA.getId(), Duration.ofDays(0L), Duration.ofDays(0L), null, Collections.emptyList());
        ShiftTemplateView persistedShiftTemplate = this.rotationService.createShiftTemplate(this.TENANT_ID, shiftTemplateView);
        ShiftTemplateView updatedShiftTemplate = new ShiftTemplateView(this.TENANT_ID, spotB.getId(), Duration.ofDays(1L), Duration.ofDays(1L), null, Collections.emptyList());
        updatedShiftTemplate.setId(persistedShiftTemplate.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedShiftTemplate);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/tenant/{tenantId}/rotation/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.spotId", (Object[])new Object[0]).value((Object)spotB.getId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.durationBetweenRotationStartAndTemplateStart", (Object[])new Object[0]).value((Object)"PT24H")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.shiftTemplateDuration", (Object[])new Object[0]).value((Object)"PT24H"));
    }

    @Test
    public void updateNonExistentShiftTemplateTest() throws Exception {
        String exceptionMessage = "ShiftTemplate entity with ID (0) not found.";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        ShiftTemplateView shiftTemplateView = new ShiftTemplateView(this.TENANT_ID, spot.getId(), Duration.ofDays(0L), Duration.ofDays(0L), null, Collections.emptyList());
        shiftTemplateView.setId(Long.valueOf(0L));
        String body = new ObjectMapper().writeValueAsString((Object)shiftTemplateView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/tenant/{tenantId}/rotation/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }
}

