/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.solver;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.test.impl.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreVerifier;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailabilityState;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.tenant.RosterConstraintConfiguration;
import org.optaweb.employeerostering.domain.tenant.Tenant;
import org.optaweb.employeerostering.service.roster.RosterGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.http.ResponseEntity;

public abstract class AbstractSolverTest {
    public static final String BEST_SCORE_TERMINATION_LIMIT = "0hard/0medium/-9223372036854775808soft";
    private static final int TENANT_ID = 0;
    private static final LocalDate START_DATE = LocalDate.of(2019, 5, 13);
    private static final RosterConstraintConfiguration ROSTER_CONSTRAINT_CONFIGURATION = new RosterConstraintConfiguration();
    private static final String ROSTER_PATH_URI = "http://localhost:8080/rest/tenant/{tenantId}/roster/";
    @Autowired
    private TestRestTemplate restTemplate;

    private ResponseEntity<Void> terminateSolver(Integer tenantId) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/roster/terminate", null, Void.class, new Object[]{tenantId});
    }

    public abstract SolverFactory<Roster> getSolverFactory();

    private HardMediumSoftLongScoreVerifier<Roster> getScoreVerifier() {
        return new HardMediumSoftLongScoreVerifier(this.getSolverFactory());
    }

    @Test
    public void testTerminateNonExistentSolver() {
        try {
            this.terminateSolver(0);
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("The roster with tenantId (0) is not being solved currently.");
        }
    }

    @Test(timeout=600000L)
    public void testFeasibleSolution() {
        Solver solver = this.getSolverFactory().buildSolver();
        RosterGenerator rosterGenerator = this.buildRosterGenerator();
        Roster roster = rosterGenerator.generateRoster(10, 7);
        roster = (Roster)solver.solve((Object)roster);
        Assert.assertNotNull((Object)roster.getScore());
        Assert.assertTrue((boolean)roster.getScore().isFeasible());
        Assert.assertFalse((boolean)roster.getShiftList().isEmpty());
        Assert.assertTrue((boolean)roster.getShiftList().stream().anyMatch(s -> s.getEmployee() != null));
    }

    @Test(timeout=600000L)
    public void testMoveOnlyDraftShifts() {
        Solver solver = this.getSolverFactory().buildSolver();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterConstraintConfiguration constraintConfiguration = this.getRosterConstraintConfiguration(idGenerator);
        Contract contract = this.getDefaultContract(idGenerator);
        Skill skill = new Skill(Integer.valueOf(0), "Skill");
        skill.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Employee employeeB = new Employee(Integer.valueOf(0), "Bill", contract, Collections.singleton(skill));
        employeeB.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot", Collections.singleton(skill));
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(rosterState.getFirstPublishedDate().atTime(9, 0), ZoneOffset.UTC);
        ShiftBuilder shiftBuilder = new ShiftBuilder(idGenerator).forSpot(spotA).startingAtDate(firstDateTime).withShiftLength(Duration.ofHours(8L)).withTimeBetweenShifts(Duration.ofDays(1L));
        List<Shift> shiftList = shiftBuilder.generateShifts(14);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Arrays.asList(employeeA, employeeB));
        roster.setSkillList(Collections.singletonList(skill));
        roster.setRosterConstraintConfiguration(constraintConfiguration);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(shiftList);
        roster = (Roster)solver.solve((Object)roster);
        Assert.assertTrue((boolean)roster.getShiftList().stream().filter(s -> !rosterState.isDraft(s)).allMatch(s -> s.getEmployee().equals((Object)employeeA)));
        Assert.assertTrue((boolean)roster.getShiftList().stream().filter(arg_0 -> ((RosterState)rosterState).isDraft(arg_0)).allMatch(s -> s.getEmployee().equals((Object)employeeB)));
    }

    private void testContractConstraint(ContractField contractField) {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterConstraintConfiguration rosterConstraintConfiguration = this.getRosterConstraintConfiguration(idGenerator);
        Contract contract = contractField.getContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        LocalDate firstDayOfWeek = START_DATE.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        OffsetDateTime firstDateTime = OffsetDateTime.of(firstDayOfWeek, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        ShiftBuilder shiftBuilder = new ShiftBuilder(idGenerator).forSpot(spotA).startingAtDate(firstDateTime).withShiftLength(Duration.ofHours(1L));
        List<Shift> shiftList = contractField.generateShifts(shiftBuilder);
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterConstraintConfiguration(rosterConstraintConfiguration);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(shiftList);
        shiftList.get(0).setEmployee(employeeA);
        shiftList.get(1).setEmployee(employeeA);
        shiftList.get(3).setEmployee(employeeA);
        shiftList.get(4).setEmployee(employeeA);
        Constraints constraint = contractField.getConstraint();
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
        shiftList.get(2).setEmployee(employeeA);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 60);
        shiftList.get(5).setEmployee(employeeA);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 120);
        shiftList.get(1).setEmployee(null);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 60);
    }

    @Test(timeout=600000L)
    public void testContractConstraints() {
        for (ContractField field : ContractField.values()) {
            this.testContractConstraint(field);
        }
    }

    @Test(timeout=600000L)
    public void testRequiredSkillForShiftConstraint() {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterConstraintConfiguration rosterConstraintConfiguration = this.getRosterConstraintConfiguration(idGenerator);
        Skill skillA = new Skill(Integer.valueOf(0), "Skill A");
        Skill skillB = new Skill(Integer.valueOf(0), "Skill B");
        skillA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        skillB.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot A", new HashSet<Skill>(Arrays.asList(skillA, skillB)));
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        Shift shift = new Shift(Integer.valueOf(0), spotA, firstDateTime, firstDateTime.plusHours(9L));
        shift.setId(Long.valueOf(idGenerator.getAndIncrement()));
        shift.setEmployee(employeeA);
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Arrays.asList(skillA, skillB));
        roster.setRosterConstraintConfiguration(rosterConstraintConfiguration);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(Collections.singletonList(shift));
        Constraints constraint = Constraints.REQUIRED_SKILL_FOR_A_SHIFT;
        constraint.verifyNumOfInstances(scoreVerifier, roster, 540);
        employeeA.setSkillProficiencySet(new HashSet<Skill>(Collections.singleton(skillA)));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 540);
        employeeA.setSkillProficiencySet(new HashSet<Skill>(Collections.singleton(skillB)));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 540);
        employeeA.setSkillProficiencySet(new HashSet<Skill>(Arrays.asList(skillA, skillB)));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
    }

    private void testAvailabilityConstraint(EmployeeAvailabilityState availabilityState) {
        Constraints constraint;
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterConstraintConfiguration rosterConstraintConfiguration = this.getRosterConstraintConfiguration(idGenerator);
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        Shift shift = new Shift(Integer.valueOf(0), spotA, firstDateTime, firstDateTime.plusHours(9L));
        shift.setId(Long.valueOf(idGenerator.getAndIncrement()));
        shift.setEmployee(employeeA);
        EmployeeAvailability availability = new EmployeeAvailability(Integer.valueOf(0), employeeA, firstDateTime, firstDateTime.plusHours(9L));
        availability.setId(Long.valueOf(idGenerator.getAndIncrement()));
        availability.setState(availabilityState);
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterConstraintConfiguration(rosterConstraintConfiguration);
        roster.setEmployeeAvailabilityList(Collections.singletonList(availability));
        roster.setShiftList(Collections.singletonList(shift));
        switch (availabilityState) {
            case DESIRED: {
                constraint = Constraints.DESIRED_TIME_SLOT_FOR_AN_EMPLOYEE;
                break;
            }
            case UNDESIRED: {
                constraint = Constraints.UNDESIRED_TIME_SLOT_FOR_AN_EMPLOYEE;
                break;
            }
            case UNAVAILABLE: {
                constraint = Constraints.UNAVAILABLE_TIME_SLOT_FOR_AN_EMPLOYEE;
                break;
            }
            default: {
                throw new IllegalArgumentException("No case for (" + availabilityState + ")");
            }
        }
        constraint.verifyNumOfInstances(scoreVerifier, roster, 540);
        shift.setStartDateTime(firstDateTime.minusHours(3L));
        shift.setEndDateTime(firstDateTime.plusHours(6L));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 540);
        shift.setStartDateTime(firstDateTime.plusHours(3L));
        shift.setEndDateTime(firstDateTime.plusHours(12L));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 540);
        shift.setStartDateTime(firstDateTime.plusHours(12L));
        shift.setEndDateTime(firstDateTime.plusHours(21L));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
    }

    @Test(timeout=600000L)
    public void testEmployeeAvilabilityConstraints() {
        for (EmployeeAvailabilityState state : EmployeeAvailabilityState.values()) {
            this.testAvailabilityConstraint(state);
        }
    }

    @Test(timeout=600000L)
    public void testNoMoreThan2ConsecutiveShifts() {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterConstraintConfiguration rosterConstraintConfiguration = this.getRosterConstraintConfiguration(idGenerator);
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        ShiftBuilder shiftBuilder = new ShiftBuilder(idGenerator).forSpot(spotA).startingAtDate(firstDateTime).withShiftLength(Duration.ofHours(1L)).withTimeBetweenShifts(Duration.ofHours(1L));
        List<Shift> shiftList = shiftBuilder.generateShifts(2);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterConstraintConfiguration(rosterConstraintConfiguration);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(shiftList);
        Constraints constraint = Constraints.NO_MORE_THAN_2_CONSECUTIVE_SHIFTS;
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
        shiftList = shiftBuilder.generateShifts(3);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setShiftList(shiftList);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 60);
        shiftBuilder.withTimeBetweenShifts(Duration.ofHours(-1L));
        shiftList = shiftBuilder.generateShifts(3);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setShiftList(shiftList);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 60);
    }

    @Test(timeout=600000L)
    public void testBreaksBetweenConsecutiveShiftsAtLeast10Hours() {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterConstraintConfiguration rosterConstraintConfiguration = this.getRosterConstraintConfiguration(idGenerator);
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        ShiftBuilder shiftBuilder = new ShiftBuilder(idGenerator).forSpot(spotA).startingAtDate(firstDateTime).withShiftLength(Duration.ofHours(1L)).withTimeBetweenShifts(Duration.ofHours(2L));
        List<Shift> shiftList = shiftBuilder.generateShifts(2);
        System.out.println(shiftList);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterConstraintConfiguration(rosterConstraintConfiguration);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(shiftList);
        Constraints constraint = Constraints.BREAKS_AT_LEAST_10_HOURS;
        constraint.verifyNumOfInstances(scoreVerifier, roster, 540);
        shiftBuilder.withTimeBetweenShifts(Duration.ofHours(10L));
        shiftList = shiftBuilder.generateShifts(2);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setShiftList(shiftList);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 60);
        shiftBuilder.withTimeBetweenShifts(Duration.ofHours(11L));
        shiftList = shiftBuilder.generateShifts(2);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setShiftList(shiftList);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
        shiftBuilder.withTimeBetweenShifts(Duration.ofHours(-2L));
        shiftList = shiftBuilder.generateShifts(2);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setShiftList(shiftList);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 540);
    }

    @Test(timeout=600000L)
    public void testAssignEveryShift() {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterConstraintConfiguration rosterConstraintConfiguration = this.getRosterConstraintConfiguration(idGenerator);
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        ShiftBuilder shiftBuilder = new ShiftBuilder(idGenerator).forSpot(spotA).startingAtDate(firstDateTime).withShiftLength(Duration.ofHours(1L)).withTimeBetweenShifts(Duration.ofDays(1L));
        List<Shift> shiftList = shiftBuilder.generateShifts(3);
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterConstraintConfiguration(rosterConstraintConfiguration);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(shiftList);
        Constraints constraint = Constraints.ASSIGN_EVERY_SHIFT;
        constraint.verifyNumOfInstances(scoreVerifier, roster, 3);
        shiftList.get(0).setEmployee(employeeA);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 2);
        shiftList.get(1).setEmployee(employeeA);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        shiftList.get(2).setEmployee(employeeA);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
    }

    @Ignore(value="Disabled as in this new world, predictability of schedules does not matter.")
    @Test(timeout=600000L)
    public void testEmployeeIsNotRotationEmployeeConstraint() {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterConstraintConfiguration rosterConstraintConfiguration = this.getRosterConstraintConfiguration(idGenerator);
        Spot spotA = new Spot(Integer.valueOf(0), "Spot A", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Employee rotationEmployee = new Employee(Integer.valueOf(0), "Anna", contract, Collections.emptySet());
        rotationEmployee.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        Shift shift = new Shift(Integer.valueOf(0), spotA, firstDateTime, firstDateTime.plusHours(9L));
        shift.setId(Long.valueOf(idGenerator.getAndIncrement()));
        shift.setEmployee(employeeA);
        shift.setRotationEmployee(rotationEmployee);
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterConstraintConfiguration(rosterConstraintConfiguration);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(Collections.singletonList(shift));
        Constraints constraint = Constraints.EMPLOYEE_IS_NOT_ROTATION_EMPLOYEE;
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        shift.setEmployee(rotationEmployee);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
    }

    protected RosterGenerator buildRosterGenerator() {
        EntityManager entityManager = (EntityManager)Mockito.mock(EntityManager.class);
        AtomicInteger tenantIdGenerator = new AtomicInteger(0);
        ((EntityManager)Mockito.doAnswer(invocation -> {
            Tenant tenant = (Tenant)invocation.getArgument(0);
            tenant.setId(Integer.valueOf(tenantIdGenerator.getAndIncrement()));
            return invocation;
        }).when((Object)entityManager)).persist(ArgumentMatchers.any(Tenant.class));
        AtomicLong idGenerator = new AtomicLong(0L);
        ((EntityManager)Mockito.doAnswer(invocation -> {
            AbstractPersistable o = (AbstractPersistable)invocation.getArgument(0);
            o.setId(Long.valueOf(idGenerator.getAndIncrement()));
            return invocation;
        }).when((Object)entityManager)).persist(ArgumentMatchers.any(AbstractPersistable.class));
        RosterGenerator rosterGenerator = new RosterGenerator(entityManager);
        rosterGenerator.setUpGeneratedData();
        return rosterGenerator;
    }

    private RosterState getRosterState(AtomicLong idGenerator) {
        int PUBLISH_NOTICE = 7;
        int PUBLISH_LENGTH = 7;
        int DRAFT_LENGTH = 14;
        boolean ROTATION_OFFSET = false;
        int ROTATION_LENGTH = 7;
        RosterState rosterState = new RosterState(Integer.valueOf(0), Integer.valueOf(7), START_DATE.minusDays(7L), Integer.valueOf(7), Integer.valueOf(14), Integer.valueOf(0), Integer.valueOf(7), START_DATE.minusDays(14L), ZoneId.systemDefault());
        rosterState.setId(Long.valueOf(idGenerator.getAndIncrement()));
        return rosterState;
    }

    private Contract getDefaultContract(AtomicLong idGenerator) {
        Contract out = new Contract(Integer.valueOf(0), "Default Contract", null, null, null, null);
        out.setId(Long.valueOf(idGenerator.getAndIncrement()));
        return out;
    }

    private RosterConstraintConfiguration getRosterConstraintConfiguration(AtomicLong idGenerator) {
        ROSTER_CONSTRAINT_CONFIGURATION.setTenantId(Integer.valueOf(0));
        ROSTER_CONSTRAINT_CONFIGURATION.setId(Long.valueOf(idGenerator.getAndIncrement()));
        ROSTER_CONSTRAINT_CONFIGURATION.setWeekStartDay(DayOfWeek.MONDAY);
        return ROSTER_CONSTRAINT_CONFIGURATION;
    }

    static /* synthetic */ RosterConstraintConfiguration access$000() {
        return ROSTER_CONSTRAINT_CONFIGURATION;
    }

    private static class ShiftBuilder {
        OffsetDateTime firstShiftStartTime;
        Duration lengthOfShift;
        Duration durationBetweenShifts;
        Spot shiftSpot;
        AtomicLong idGenerator;

        public ShiftBuilder(AtomicLong idGenerator) {
            this.idGenerator = idGenerator;
        }

        public ShiftBuilder startingAtDate(OffsetDateTime startDate) {
            this.firstShiftStartTime = startDate;
            return this;
        }

        public ShiftBuilder withShiftLength(Duration duration) {
            this.lengthOfShift = duration;
            return this;
        }

        public ShiftBuilder withTimeBetweenShifts(Duration duration) {
            this.durationBetweenShifts = duration;
            return this;
        }

        public ShiftBuilder forSpot(Spot spot) {
            this.shiftSpot = spot;
            return this;
        }

        public List<Shift> generateShifts(int numberOfShifts) {
            if (this.firstShiftStartTime == null || this.lengthOfShift == null || this.durationBetweenShifts == null || this.shiftSpot == null) {
                throw new IllegalStateException("ShiftBuilder not initialized");
            }
            ArrayList<Shift> out = new ArrayList<Shift>();
            OffsetDateTime shiftStart = this.firstShiftStartTime;
            int i = 0;
            while (i < numberOfShifts) {
                out.add(new Shift(Integer.valueOf(0), this.shiftSpot, shiftStart, shiftStart.plus(this.lengthOfShift)));
                ((Shift)out.get(i)).setId(Long.valueOf(this.idGenerator.getAndIncrement()));
                ++i;
                shiftStart = shiftStart.plus(this.durationBetweenShifts);
            }
            return out;
        }
    }

    private static enum ContractField {
        DAILY(Constraints.DAILY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM, 120, null, null, null, Duration.ofHours(6L), Duration.ofDays(1L)),
        WEEKLY(Constraints.WEEKLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM, null, 120, null, null, Duration.ofDays(1L), Duration.ofDays(7L)),
        MONTHLY(Constraints.MONTHLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM, null, null, 120, null, Duration.ofDays(7L), Duration.ofDays(31L)),
        ANNUALLY(Constraints.YEARLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM, null, null, null, 120, Duration.ofDays(31L), Duration.ofDays(366L));

        Constraints constraint;
        Integer dailyHours;
        Integer weeklyHours;
        Integer monthlyHours;
        Integer yearlyHours;
        Duration timeBetweenShifts;
        Duration periodLength;

        private ContractField(Constraints constraint, Integer dailyHours, Integer weeklyHours, Integer monthlyHours, Integer yearlyHours, Duration timeBetweenShifts, Duration periodLength) {
            this.constraint = constraint;
            this.dailyHours = dailyHours;
            this.weeklyHours = weeklyHours;
            this.monthlyHours = monthlyHours;
            this.yearlyHours = yearlyHours;
            this.timeBetweenShifts = timeBetweenShifts;
            this.periodLength = periodLength;
        }

        public Constraints getConstraint() {
            return this.constraint;
        }

        public Contract getContract(AtomicLong idGenerator) {
            Contract out = new Contract(Integer.valueOf(0), "Contract", this.dailyHours, this.weeklyHours, this.monthlyHours, this.yearlyHours);
            out.setId(Long.valueOf(idGenerator.getAndIncrement()));
            return out;
        }

        public List<Shift> generateShifts(ShiftBuilder shiftBuilder) {
            ArrayList<Shift> out = new ArrayList<Shift>();
            shiftBuilder.withTimeBetweenShifts(this.timeBetweenShifts);
            out.addAll(shiftBuilder.generateShifts(3));
            shiftBuilder.startingAtDate(shiftBuilder.firstShiftStartTime.plus(this.periodLength));
            out.addAll(shiftBuilder.generateShifts(3));
            return out;
        }
    }

    private static enum Constraints {
        REQUIRED_SKILL_FOR_A_SHIFT("Required skill for a shift", AbstractSolverTest.access$000().getRequiredSkill().negate()),
        UNAVAILABLE_TIME_SLOT_FOR_AN_EMPLOYEE("Unavailable time slot for an employee", AbstractSolverTest.access$000().getUnavailableTimeSlot().negate()),
        NO_MORE_THAN_2_CONSECUTIVE_SHIFTS("No more than 2 consecutive shifts", AbstractSolverTest.access$000().getNoMoreThan2ConsecutiveShifts().negate()),
        BREAKS_AT_LEAST_10_HOURS("Break between non-consecutive shifts is at least 10 hours", AbstractSolverTest.access$000().getBreakBetweenNonConsecutiveShiftsAtLeast10Hours().negate()),
        DAILY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM("Daily minutes must not exceed contract maximum", AbstractSolverTest.access$000().getContractMaximumDailyMinutes().negate()),
        WEEKLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM("Weekly minutes must not exceed contract maximum", AbstractSolverTest.access$000().getContractMaximumWeeklyMinutes().negate()),
        MONTHLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM("Monthly minutes must not exceed contract maximum", AbstractSolverTest.access$000().getContractMaximumMonthlyMinutes().negate()),
        YEARLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM("Yearly minutes must not exceed contract maximum", AbstractSolverTest.access$000().getContractMaximumYearlyMinutes().negate()),
        ASSIGN_EVERY_SHIFT("Assign every shift", AbstractSolverTest.access$000().getAssignEveryShift().negate()),
        UNDESIRED_TIME_SLOT_FOR_AN_EMPLOYEE("Undesired time slot for an employee", AbstractSolverTest.access$000().getUndesiredTimeSlot().negate()),
        DESIRED_TIME_SLOT_FOR_AN_EMPLOYEE("Desired time slot for an employee", AbstractSolverTest.access$000().getDesiredTimeSlot()),
        EMPLOYEE_IS_NOT_ROTATION_EMPLOYEE("Employee is not rotation employee", AbstractSolverTest.access$000().getNotRotationEmployee().negate());

        String constraintName;
        HardMediumSoftLongScore constraintWeight;

        private Constraints(String constraintName, HardMediumSoftLongScore constraintWeight) {
            this.constraintName = constraintName;
            this.constraintWeight = constraintWeight;
        }

        public void verifyNumOfInstances(HardMediumSoftLongScoreVerifier<Roster> scoreVerifier, Roster roster, int numOfInstances) {
            scoreVerifier.assertHardWeight(this.constraintName, this.constraintWeight.getHardScore() * (long)numOfInstances, (Object)roster);
            scoreVerifier.assertMediumWeight(this.constraintName, this.constraintWeight.getMediumScore() * (long)numOfInstances, (Object)roster);
            scoreVerifier.assertSoftWeight(this.constraintName, this.constraintWeight.getSoftScore() * (long)numOfInstances, (Object)roster);
        }
    }
}

