/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.solver;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.service.roster.RosterGenerator;
import org.optaweb.employeerostering.service.solver.WannabeSolverManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class SolverManagerTest {
    @Autowired
    private RosterGenerator rosterGenerator;
    @Autowired
    protected WannabeSolverManager solverManager;

    @Test
    public void testSolveRoster() throws InterruptedException {
        this.solverManager.setUpSolverFactory();
        Roster roster = this.rosterGenerator.generateRoster(10, 7);
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.schedule(() -> this.solverManager.terminate(roster.getTenantId()), 3L, TimeUnit.SECONDS);
        CountDownLatch solverEndedLatch = this.solverManager.solve(roster.getTenantId());
        solverEndedLatch.await();
        ScoreDirector scoreDirector = this.solverManager.getScoreDirector();
        scoreDirector.setWorkingSolution((Object)roster);
        roster.setScore((HardMediumSoftLongScore)scoreDirector.calculateScore());
        Assert.assertNotNull((Object)roster.getScore());
        Assert.assertTrue((boolean)roster.getScore().isFeasible());
        Assert.assertFalse((boolean)roster.getShiftList().isEmpty());
        Assert.assertTrue((boolean)roster.getShiftList().stream().anyMatch(s -> s.getEmployee() != null));
    }

    @Test
    public void testReplanRoster() throws InterruptedException {
        this.solverManager.setUpSolverFactory();
        Roster roster = this.rosterGenerator.generateRoster(1, 7);
        Shift unassignedShift = roster.getShiftList().stream().filter(shift -> shift.getEmployee() != null).findFirst().get();
        unassignedShift.setEmployee(null);
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.schedule(() -> this.solverManager.terminate(roster.getTenantId()), 3L, TimeUnit.SECONDS);
        CountDownLatch solverEndedLatch = this.solverManager.replan(roster.getTenantId());
        solverEndedLatch.await();
        ScoreDirector scoreDirector = this.solverManager.getScoreDirector();
        scoreDirector.setWorkingSolution((Object)roster);
        roster.setScore((HardMediumSoftLongScore)scoreDirector.calculateScore());
        Assert.assertNotNull((Object)roster.getScore());
        Assert.assertTrue((boolean)roster.getScore().isFeasible());
        Assert.assertFalse((boolean)roster.getShiftList().isEmpty());
        Assert.assertTrue((boolean)roster.getShiftList().stream().anyMatch(s -> s.getEmployee() != null));
    }
}

