/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.tenant;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.roster.view.RosterStateView;
import org.optaweb.employeerostering.domain.tenant.RosterConstraintConfiguration;
import org.optaweb.employeerostering.domain.tenant.Tenant;
import org.optaweb.employeerostering.domain.tenant.view.RosterConstraintConfigurationView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class TenantRestControllerTest
extends AbstractEntityRequireTenantRestServiceTest {
    @Autowired
    private TestRestTemplate restTemplate;
    private final String tenantPathURI = "http://localhost:8080/rest/tenant/";

    private ResponseEntity<Tenant> getTenant(Integer id) {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/" + id, Tenant.class, new Object[0]);
    }

    private ResponseEntity<Tenant> addTenant(RosterStateView initialRosterStateView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/add", (Object)initialRosterStateView, Tenant.class, new Object[0]);
    }

    private void deleteTenant(Integer id) {
        this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/remove/" + id, null, Void.class, new Object[0]);
    }

    private ResponseEntity<RosterConstraintConfiguration> getRosterConstraintParametrization(Integer tenantId) {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/" + tenantId + "/config/constraint", RosterConstraintConfiguration.class, new Object[0]);
    }

    private ResponseEntity<RosterConstraintConfiguration> updateRosterConstraintParametrization(Integer tenantId, RosterConstraintConfigurationView rosterConstraintConfigurationView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/" + tenantId + "/config/constraint/update", (Object)rosterConstraintConfigurationView, RosterConstraintConfiguration.class, new Object[0]);
    }

    private ResponseEntity<List> getSupportedTimezones() {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/supported/timezones", List.class, new Object[0]);
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void tenantCrudTest() {
        RosterStateView rosterStateView = new RosterStateView(Integer.valueOf(0), Integer.valueOf(0), LocalDate.of(2000, 1, 1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(2), LocalDate.of(2000, 1, 2), ZoneId.of("America/Toronto"));
        rosterStateView.setTenant(new Tenant("tenant"));
        ResponseEntity<Tenant> postResponse = this.addTenant(rosterStateView);
        Assertions.assertThat((Comparable)postResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        ResponseEntity<Tenant> getResponse = this.getTenant(((Tenant)postResponse.getBody()).getId());
        Assertions.assertThat((Comparable)getResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)getResponse.getBody()).isEqualToComparingFieldByFieldRecursively(postResponse.getBody());
        this.deleteTenant(((Tenant)postResponse.getBody()).getId());
    }

    @Test
    public void rosterConstraintConfigurationCrudTest() {
        ResponseEntity<RosterConstraintConfiguration> getResponse = this.getRosterConstraintParametrization(this.TENANT_ID);
        Assertions.assertThat((Comparable)getResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)getResponse.getBody()).isNotNull();
        ResponseEntity<RosterConstraintConfiguration> updateResponse = this.updateRosterConstraintParametrization(this.TENANT_ID, new RosterConstraintConfigurationView(this.TENANT_ID, DayOfWeek.TUESDAY));
        Assertions.assertThat((Comparable)updateResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Comparable)((Object)((RosterConstraintConfiguration)updateResponse.getBody()).getWeekStartDay())).isEqualTo((Object)DayOfWeek.TUESDAY);
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getRequiredSkill()).isEqualTo((Object)HardMediumSoftLongScore.ofHard((long)100L));
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getUnavailableTimeSlot()).isEqualTo((Object)HardMediumSoftLongScore.ofHard((long)50L));
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getNoMoreThan2ConsecutiveShifts()).isEqualTo((Object)HardMediumSoftLongScore.ofHard((long)10L));
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getBreakBetweenNonConsecutiveShiftsAtLeast10Hours()).isEqualTo((Object)HardMediumSoftLongScore.ofHard((long)1L));
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getContractMaximumDailyMinutes()).isEqualTo((Object)HardMediumSoftLongScore.ofHard((long)1L));
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getContractMaximumWeeklyMinutes()).isEqualTo((Object)HardMediumSoftLongScore.ofHard((long)1L));
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getContractMaximumMonthlyMinutes()).isEqualTo((Object)HardMediumSoftLongScore.ofHard((long)1L));
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getContractMaximumYearlyMinutes()).isEqualTo((Object)HardMediumSoftLongScore.ofHard((long)1L));
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getAssignEveryShift()).isEqualTo((Object)HardMediumSoftLongScore.ofMedium((long)1L));
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getUndesiredTimeSlot()).isEqualTo((Object)HardMediumSoftLongScore.ofSoft((long)1L));
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getDesiredTimeSlot()).isEqualTo((Object)HardMediumSoftLongScore.ofSoft((long)1L));
        Assertions.assertThat((Comparable)((RosterConstraintConfiguration)updateResponse.getBody()).getNotRotationEmployee()).isEqualTo((Object)HardMediumSoftLongScore.ofSoft((long)1L));
    }

    @Test
    public void getSupportedTimezonesTest() {
        ResponseEntity<List> getResponse = this.getSupportedTimezones();
        Assertions.assertThat((Comparable)getResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)getResponse.getBody())).contains(new Object[]{"America/Toronto"});
        Assertions.assertThat((List)((List)getResponse.getBody())).contains(new Object[]{"Europe/Berlin"});
        Assertions.assertThat((List)((List)getResponse.getBody())).contains(new Object[]{"Zulu"});
    }
}

