/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.employee;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.skill.Skill;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"tenantId", "name"})})
public class Employee
extends AbstractPersistable {
    @NotNull
    @Size(min=1, max=120)
    @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces")
    private @NotNull @Size(min=1, max=120) @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces") String name;
    @NotNull
    @ManyToOne
    private Contract contract;
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="EmployeeSkillProficiencySet", joinColumns={@JoinColumn(name="employeeId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="skillId", referencedColumnName="id")})
    private Set<Skill> skillProficiencySet;

    public Employee() {
    }

    public Employee(Integer tenantId, String name, Contract contract, Set<Skill> skillProficiencySet) {
        super(tenantId);
        this.name = name;
        this.contract = contract;
        this.skillProficiencySet = skillProficiencySet;
    }

    public boolean hasSkill(Skill skill) {
        return this.skillProficiencySet.contains(skill);
    }

    public boolean hasSkills(Collection<Skill> skills) {
        return this.skillProficiencySet.containsAll(skills);
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Skill> getSkillProficiencySet() {
        return this.skillProficiencySet;
    }

    public void setSkillProficiencySet(Set<Skill> skillProficiencySet) {
        this.skillProficiencySet = skillProficiencySet;
    }

    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Employee) {
            Employee other = (Employee)o;
            return this.name.equals(other.getName()) && this.contract.equals(other.getContract()) && this.skillProficiencySet.equals(other.getSkillProficiencySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.contract, this.skillProficiencySet);
    }
}

