/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.employee;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.persistence.EntityNotFoundException;
import javax.validation.Validator;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.optaweb.employeerostering.domain.employee.view.EmployeeAvailabilityView;
import org.optaweb.employeerostering.domain.employee.view.EmployeeView;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.employee.EmployeeAvailabilityRepository;
import org.optaweb.employeerostering.service.employee.EmployeeRepository;
import org.optaweb.employeerostering.service.roster.RosterStateRepository;
import org.optaweb.employeerostering.util.EmployeeListXlsxFileIO;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeService
extends AbstractRestService {
    private final EmployeeRepository employeeRepository;
    private final EmployeeAvailabilityRepository employeeAvailabilityRepository;
    private final RosterStateRepository rosterStateRepository;
    private final EmployeeListXlsxFileIO employeeListXlsxFileIO;

    public EmployeeService(Validator validator, EmployeeRepository employeeRepository, EmployeeAvailabilityRepository employeeAvailabilityRepository, RosterStateRepository rosterStateRepository, EmployeeListXlsxFileIO employeeListXlsxFileIO) {
        super(validator);
        this.employeeRepository = employeeRepository;
        this.employeeAvailabilityRepository = employeeAvailabilityRepository;
        this.rosterStateRepository = rosterStateRepository;
        this.employeeListXlsxFileIO = employeeListXlsxFileIO;
    }

    public Employee convertFromEmployeeView(Integer tenantId, EmployeeView employeeView) {
        Employee employee = new Employee(employeeView.getTenantId(), employeeView.getName(), employeeView.getContract(), employeeView.getSkillProficiencySet());
        this.validateEmployee(tenantId, employee);
        employee.setId(employeeView.getId());
        employee.setVersion(employeeView.getVersion());
        return employee;
    }

    @Transactional
    public List<Employee> getEmployeeList(Integer tenantId) {
        return this.employeeRepository.findAllByTenantId(tenantId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
    }

    @Transactional
    public Employee getEmployee(Integer tenantId, Long id) {
        Employee employee = (Employee)this.employeeRepository.findById(id).orElseThrow(() -> new EntityNotFoundException("No Employee entity found with ID (" + id + ")."));
        this.validateEmployee(tenantId, employee);
        return employee;
    }

    @Transactional
    public Boolean deleteEmployee(Integer tenantId, Long id) {
        Optional employeeOptional = this.employeeRepository.findById(id);
        if (!employeeOptional.isPresent()) {
            return false;
        }
        this.validateEmployee(tenantId, (Employee)employeeOptional.get());
        this.employeeRepository.deleteById(id);
        return true;
    }

    @Transactional
    public Employee createEmployee(Integer tenantId, EmployeeView employeeView) {
        Employee employee = this.convertFromEmployeeView(tenantId, employeeView);
        this.validateEmployee(tenantId, employee);
        return (Employee)this.employeeRepository.save(employee);
    }

    @Transactional
    public Employee updateEmployee(Integer tenantId, EmployeeView employeeView) {
        Employee newEmployee = this.convertFromEmployeeView(tenantId, employeeView);
        Employee oldEmployee = (Employee)this.employeeRepository.findById(newEmployee.getId()).orElseThrow(() -> new EntityNotFoundException("Employee entity with ID (" + newEmployee.getId() + ") not found."));
        if (!oldEmployee.getTenantId().equals(newEmployee.getTenantId())) {
            throw new IllegalStateException("Employee entity with tenantId (" + oldEmployee.getTenantId() + ") cannot change tenants.");
        }
        this.validateEmployee(tenantId, newEmployee);
        oldEmployee.setName(newEmployee.getName());
        oldEmployee.setSkillProficiencySet(newEmployee.getSkillProficiencySet());
        oldEmployee.setContract(newEmployee.getContract());
        return (Employee)this.employeeRepository.save(oldEmployee);
    }

    @Transactional
    public List<Employee> importEmployeesFromExcel(Integer tenantId, InputStream excelInputStream) throws IOException {
        List<EmployeeView> excelEmployeeList = this.employeeListXlsxFileIO.getEmployeeListFromExcelFile(tenantId, excelInputStream);
        HashSet addedEmployeeSet = new HashSet();
        excelEmployeeList.stream().flatMap(employee -> {
            if (addedEmployeeSet.contains(employee.getName().toLowerCase())) {
                return Stream.empty();
            }
            addedEmployeeSet.add(employee.getName().toLowerCase());
            return Stream.of(employee);
        }).forEach(employee -> {
            this.validateEmployee(tenantId, this.convertFromEmployeeView(tenantId, (EmployeeView)employee));
            Employee oldEmployee = this.employeeRepository.findEmployeeByName(tenantId, employee.getName());
            if (oldEmployee != null) {
                employee.setContract(oldEmployee.getContract());
                employee.setId(oldEmployee.getId());
                employee.setVersion(oldEmployee.getVersion());
                this.updateEmployee(tenantId, (EmployeeView)employee);
            } else {
                this.createEmployee(tenantId, (EmployeeView)employee);
            }
        });
        return this.getEmployeeList(tenantId);
    }

    protected void validateEmployee(Integer tenantId, Employee employee) {
        super.validateBean(tenantId, employee);
        for (Skill skill : employee.getSkillProficiencySet()) {
            if (Objects.equals(skill.getTenantId(), tenantId)) continue;
            throw new IllegalStateException("The tenantId (" + tenantId + ") does not match the skillProficiency (" + skill + ")'s tenantId (" + skill.getTenantId() + ").");
        }
    }

    private EmployeeAvailability convertFromEmployeeAvailabilityView(Integer tenantId, EmployeeAvailabilityView employeeAvailabilityView) {
        this.validateBean(tenantId, employeeAvailabilityView);
        Employee employee = (Employee)this.employeeRepository.findById(employeeAvailabilityView.getEmployeeId()).orElseThrow(() -> new EntityNotFoundException("Employee entity with ID (" + employeeAvailabilityView.getEmployeeId() + ") not found."));
        this.validateBean(tenantId, employee);
        RosterState rosterState = this.rosterStateRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("RosterState entity with tenantId (" + tenantId + ") not found."));
        EmployeeAvailability employeeAvailability = new EmployeeAvailability(rosterState.getTimeZone(), employeeAvailabilityView, employee);
        employeeAvailability.setState(employeeAvailabilityView.getState());
        return employeeAvailability;
    }

    @Transactional
    public EmployeeAvailabilityView getEmployeeAvailability(Integer tenantId, Long id) {
        EmployeeAvailability employeeAvailability = (EmployeeAvailability)this.employeeAvailabilityRepository.findById(id).orElseThrow(() -> new EntityNotFoundException("No EmployeeAvailability entity found with ID (" + id + ")."));
        this.validateBean(tenantId, employeeAvailability);
        RosterState rosterState = this.rosterStateRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("No RosterState entity found with tenantId (" + tenantId + ")."));
        return new EmployeeAvailabilityView(rosterState.getTimeZone(), employeeAvailability);
    }

    @Transactional
    public EmployeeAvailabilityView createEmployeeAvailability(Integer tenantId, EmployeeAvailabilityView employeeAvailabilityView) {
        EmployeeAvailability employeeAvailability = this.convertFromEmployeeAvailabilityView(tenantId, employeeAvailabilityView);
        this.employeeAvailabilityRepository.save(employeeAvailability);
        RosterState rosterState = this.rosterStateRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("No RosterState entity found with tenantId (" + tenantId + ")."));
        return new EmployeeAvailabilityView(rosterState.getTimeZone(), employeeAvailability);
    }

    @Transactional
    public EmployeeAvailabilityView updateEmployeeAvailability(Integer tenantId, EmployeeAvailabilityView employeeAvailabilityView) {
        EmployeeAvailability newEmployeeAvailability = this.convertFromEmployeeAvailabilityView(tenantId, employeeAvailabilityView);
        EmployeeAvailability oldEmployeeAvailability = (EmployeeAvailability)this.employeeAvailabilityRepository.findById(newEmployeeAvailability.getId()).orElseThrow(() -> new EntityNotFoundException("EmployeeAvailability entity with ID (" + newEmployeeAvailability.getId() + ") not found."));
        if (!oldEmployeeAvailability.getTenantId().equals(newEmployeeAvailability.getTenantId())) {
            throw new IllegalStateException("EmployeeAvailability entity with tenantId (" + newEmployeeAvailability.getTenantId() + ") cannot change tenants.");
        }
        this.validateBean(tenantId, newEmployeeAvailability);
        oldEmployeeAvailability.setEmployee(newEmployeeAvailability.getEmployee());
        oldEmployeeAvailability.setStartDateTime(newEmployeeAvailability.getStartDateTime());
        oldEmployeeAvailability.setEndDateTime(newEmployeeAvailability.getEndDateTime());
        oldEmployeeAvailability.setState(newEmployeeAvailability.getState());
        EmployeeAvailability updatedEmployeeAvailability = (EmployeeAvailability)this.employeeAvailabilityRepository.saveAndFlush(oldEmployeeAvailability);
        RosterState rosterState = this.rosterStateRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("No RosterState entity found with tenantId (" + tenantId + ")."));
        return new EmployeeAvailabilityView(rosterState.getTimeZone(), updatedEmployeeAvailability);
    }

    @Transactional
    public Boolean deleteEmployeeAvailability(Integer tenantId, Long id) {
        Optional employeeAvailabilityOptional = this.employeeAvailabilityRepository.findById(id);
        if (!employeeAvailabilityOptional.isPresent()) {
            return false;
        }
        this.validateBean(tenantId, (AbstractPersistable)employeeAvailabilityOptional.get());
        this.employeeAvailabilityRepository.deleteById(id);
        return true;
    }
}

