/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.contract;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.contract.view.ContractView;
import org.optaweb.employeerostering.service.contract.ContractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringRunner.class)
@SpringBootTest
@AutoConfigureTestDatabase
@AutoConfigureMockMvc
@Transactional
public class ContractServiceTest
extends AbstractEntityRequireTenantRestServiceTest {
    private static final Logger logger = LoggerFactory.getLogger(ContractServiceTest.class);
    @Autowired
    private MockMvc mvc;
    @Autowired
    private ContractService contractService;

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void getContractListTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/contract/", (Object[])new Object[]{this.TENANT_ID}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getContractTest() throws Exception {
        Integer maximumMinutesPerDay = 50;
        Integer maximumMinutesPerWeek = 250;
        Integer maximumMinutesPerMonth = 1000;
        Integer maximumMinutesPerYear = 12000;
        ContractView contractView = new ContractView(this.TENANT_ID, "contract", maximumMinutesPerDay, maximumMinutesPerWeek, maximumMinutesPerMonth, maximumMinutesPerYear);
        Contract contract = this.contractService.createContract(this.TENANT_ID, contractView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/contract/{id}", (Object[])new Object[]{this.TENANT_ID, contract.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"contract")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerDay", (Object[])new Object[0]).value((Object)maximumMinutesPerDay)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerWeek", (Object[])new Object[0]).value((Object)maximumMinutesPerWeek)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerMonth", (Object[])new Object[0]).value((Object)maximumMinutesPerMonth)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerYear", (Object[])new Object[0]).value((Object)maximumMinutesPerYear));
    }

    @Test
    public void getNonExistentContractTest() throws Exception {
        String exceptionMessage = "No Contract entity found with ID (0).";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/contract/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void getNonMatchingContractTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (contract)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        ContractView contractView = new ContractView(this.TENANT_ID, "contract");
        Contract contract = this.contractService.createContract(this.TENANT_ID, contractView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/contract/{id}", (Object[])new Object[]{0, contract.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void deleteContractTest() throws Exception {
        ContractView contractView = new ContractView(this.TENANT_ID, "contract");
        Contract contract = this.contractService.createContract(this.TENANT_ID, contractView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/contract/{id}", (Object[])new Object[]{this.TENANT_ID, contract.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("true"));
    }

    @Test
    public void deleteNonExistentContractTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/contract/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("false"));
    }

    @Test
    public void deleteNonMatchingContractTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (contract)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        ContractView contractView = new ContractView(this.TENANT_ID, "contract");
        Contract contract = this.contractService.createContract(this.TENANT_ID, contractView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/contract/{id}", (Object[])new Object[]{0, contract.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void createContractTest() throws Exception {
        Integer maximumMinutesPerDay = 50;
        Integer maximumMinutesPerWeek = 250;
        Integer maximumMinutesPerMonth = 1000;
        Integer maximumMinutesPerYear = 12000;
        ContractView contractView = new ContractView(this.TENANT_ID, "contract", maximumMinutesPerDay, maximumMinutesPerWeek, maximumMinutesPerMonth, maximumMinutesPerYear);
        String body = new ObjectMapper().writeValueAsString((Object)contractView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/contract/add", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"contract")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerDay", (Object[])new Object[0]).value((Object)maximumMinutesPerDay)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerWeek", (Object[])new Object[0]).value((Object)maximumMinutesPerWeek)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerMonth", (Object[])new Object[0]).value((Object)maximumMinutesPerMonth)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerYear", (Object[])new Object[0]).value((Object)maximumMinutesPerYear));
    }

    @Test
    public void createNonMatchingContractTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (contract)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        ContractView contractView = new ContractView(this.TENANT_ID, "contract");
        String body = new ObjectMapper().writeValueAsString((Object)contractView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/contract/add", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateContractTest() throws Exception {
        Integer maximumMinutesPerDay = 50;
        Integer maximumMinutesPerWeek = 250;
        Integer maximumMinutesPerMonth = 1000;
        Integer maximumMinutesPerYear = 12000;
        ContractView contractView = new ContractView(this.TENANT_ID, "contract");
        Contract contract = this.contractService.createContract(this.TENANT_ID, contractView);
        ContractView updatedContractView = new ContractView(this.TENANT_ID, "updatedContract", maximumMinutesPerDay, maximumMinutesPerWeek, maximumMinutesPerMonth, maximumMinutesPerYear);
        updatedContractView.setId(contract.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedContractView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/contract/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"updatedContract")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerDay", (Object[])new Object[0]).value((Object)maximumMinutesPerDay)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerWeek", (Object[])new Object[0]).value((Object)maximumMinutesPerWeek)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerMonth", (Object[])new Object[0]).value((Object)maximumMinutesPerMonth)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maximumMinutesPerYear", (Object[])new Object[0]).value((Object)maximumMinutesPerYear));
    }

    @Test
    public void updateNonMatchingContractTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (updatedContract)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        ContractView contractView = new ContractView(this.TENANT_ID, "contract");
        this.contractService.createContract(this.TENANT_ID, contractView);
        ContractView updatedContractView = new ContractView(this.TENANT_ID, "updatedContract");
        String body = new ObjectMapper().writeValueAsString((Object)updatedContractView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/contract/update", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateNonExistentContractTest() throws Exception {
        String exceptionMessage = "Contract entity with ID (0) not found.";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        ContractView contractView = new ContractView(this.TENANT_ID, "contract");
        contractView.setId(Long.valueOf(0L));
        String body = new ObjectMapper().writeValueAsString((Object)contractView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/contract/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateChangeTenantIdContractTest() throws Exception {
        String exceptionMessage = "Contract entity with tenantId (" + this.TENANT_ID + ") cannot change tenants.";
        String exceptionClass = "java.lang.IllegalStateException";
        ContractView contractView = new ContractView(this.TENANT_ID, "contract");
        Contract contract = this.contractService.createContract(this.TENANT_ID, contractView);
        ContractView updatedContract = new ContractView(Integer.valueOf(0), "updatedContract");
        updatedContract.setId(contract.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedContract);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/contract/update", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void getOrCreateDefaultContractNotExistsTest() {
        Contract contract = this.contractService.getOrCreateDefaultContract(this.TENANT_ID);
        Assert.assertEquals((Object)contract.getName(), (Object)"Default Contract");
        Assert.assertNull((Object)contract.getMaximumMinutesPerDay());
        Assert.assertNull((Object)contract.getMaximumMinutesPerWeek());
        Assert.assertNull((Object)contract.getMaximumMinutesPerMonth());
        Assert.assertNull((Object)contract.getMaximumMinutesPerYear());
    }

    @Test
    public void getOrCreateDefaultContractExistsTest() {
        ContractView contractView = new ContractView();
        contractView.setTenantId(this.TENANT_ID);
        contractView.setName("Default Contract");
        contractView.setMaximumMinutesPerDay(Integer.valueOf(10));
        Contract contract = this.contractService.createContract(this.TENANT_ID, contractView);
        Contract defaultContract = this.contractService.getOrCreateDefaultContract(this.TENANT_ID);
        Assert.assertEquals((Object)contract, (Object)defaultContract);
    }
}

