/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.employee;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailabilityState;
import org.optaweb.employeerostering.domain.employee.view.EmployeeAvailabilityView;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class EmployeeRestControllerTest
extends AbstractEntityRequireTenantRestServiceTest {
    @Autowired
    private TestRestTemplate restTemplate;
    private final String employeePathURI = "http://localhost:8080/rest/tenant/{tenantId}/employee/";
    private final String contractPathURI = "http://localhost:8080/rest/tenant/{tenantId}/contract/";
    private final String skillPathURI = "http://localhost:8080/rest/tenant/{tenantId}/skill/";
    private final String employeeAvailabilityPathURI = "http://localhost:8080/rest/tenant/{tenantId}/employee/availability/";

    private ResponseEntity<List<Employee>> getEmployees(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/employee/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Employee>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<Employee> getEmployee(Integer tenantId, Long id) {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/{tenantId}/employee/" + id, Employee.class, new Object[]{tenantId});
    }

    private void deleteEmployee(Integer tenantId, Long id) {
        this.restTemplate.delete("http://localhost:8080/rest/tenant/{tenantId}/employee/" + id, new Object[]{tenantId});
    }

    private ResponseEntity<Employee> addEmployee(Integer tenantId, Employee employee) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/employee/add", (Object)employee, Employee.class, new Object[]{tenantId});
    }

    private ResponseEntity<Employee> updateEmployee(Integer tenantId, Employee employee) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/employee/update", (Object)employee, Employee.class, new Object[]{tenantId});
    }

    private ResponseEntity<Skill> addSkill(Integer tenantId, Skill skill) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/skill/add", (Object)skill, Skill.class, new Object[]{tenantId});
    }

    private ResponseEntity<Contract> addContract(Integer tenantId, Contract contract) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/contract/add", (Object)contract, Contract.class, new Object[]{tenantId});
    }

    private ResponseEntity<EmployeeAvailabilityView> getEmployeeAvailability(Integer tenantId, Long id) {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/{tenantId}/employee/availability/" + id, EmployeeAvailabilityView.class, new Object[]{tenantId});
    }

    private void deleteEmployeeAvailability(Integer tenantId, Long id) {
        this.restTemplate.delete("http://localhost:8080/rest/tenant/{tenantId}/employee/availability/" + id, new Object[]{tenantId});
    }

    private ResponseEntity<EmployeeAvailabilityView> addEmployeeAvailability(Integer tenantId, EmployeeAvailabilityView employeeAvailabilityView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/employee/availability/add", (Object)employeeAvailabilityView, EmployeeAvailabilityView.class, new Object[]{tenantId});
    }

    private ResponseEntity<EmployeeAvailabilityView> updateEmployeeAvailability(Integer tenantId, HttpEntity<EmployeeAvailabilityView> request) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/employee/availability/update", HttpMethod.PUT, request, EmployeeAvailabilityView.class, new Object[]{tenantId});
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void employeeCrudTest() {
        ResponseEntity<Skill> skillResponseA = this.addSkill(this.TENANT_ID, new Skill(this.TENANT_ID, "A"));
        ResponseEntity<Skill> skillResponseB = this.addSkill(this.TENANT_ID, new Skill(this.TENANT_ID, "B"));
        Skill skillA = (Skill)skillResponseA.getBody();
        Skill skillB = (Skill)skillResponseB.getBody();
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        ResponseEntity<Contract> contractResponseEntity = this.addContract(this.TENANT_ID, new Contract(this.TENANT_ID, "A"));
        Contract contractA = (Contract)contractResponseEntity.getBody();
        Employee employee = new Employee(this.TENANT_ID, "employee", contractA, testSkillSet);
        ResponseEntity<Employee> postResponse = this.addEmployee(this.TENANT_ID, employee);
        Assertions.assertThat((Comparable)postResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        ResponseEntity<Employee> response = this.getEmployee(this.TENANT_ID, ((Employee)postResponse.getBody()).getId());
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)response.getBody()).isEqualToComparingFieldByFieldRecursively(postResponse.getBody());
        Employee updatedEmployee = new Employee(this.TENANT_ID, "updatedEmployee", contractA, testSkillSet);
        updatedEmployee.setId(((Employee)postResponse.getBody()).getId());
        ResponseEntity<Employee> putResponse = this.updateEmployee(this.TENANT_ID, updatedEmployee);
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        response = this.getEmployee(this.TENANT_ID, ((Employee)putResponse.getBody()).getId());
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)putResponse.getBody()).isEqualToComparingFieldByFieldRecursively(response.getBody());
        this.deleteEmployee(this.TENANT_ID, ((Employee)putResponse.getBody()).getId());
        ResponseEntity<List<Employee>> getListResponse = this.getEmployees(this.TENANT_ID);
        Assertions.assertThat((Comparable)getListResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)getListResponse.getBody())).isEmpty();
    }

    @Test
    public void employeeAvailabilityCrudTest() {
        ResponseEntity<Contract> contractResponseEntity = this.addContract(this.TENANT_ID, new Contract(this.TENANT_ID, "contract"));
        Contract contract = (Contract)contractResponseEntity.getBody();
        ResponseEntity<Employee> employeeResponseEntity = this.addEmployee(this.TENANT_ID, new Employee(this.TENANT_ID, "employee", contract, Collections.emptySet()));
        Employee employee = (Employee)employeeResponseEntity.getBody();
        LocalDateTime startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59);
        LocalDateTime endDateTime = LocalDateTime.of(2000, 1, 1, 0, 0);
        ResponseEntity<EmployeeAvailabilityView> postResponse = this.addEmployeeAvailability(this.TENANT_ID, new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.UNAVAILABLE));
        Assertions.assertThat((Comparable)postResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        ResponseEntity<EmployeeAvailabilityView> getResponse = this.getEmployeeAvailability(this.TENANT_ID, ((EmployeeAvailabilityView)postResponse.getBody()).getId());
        Assertions.assertThat((Comparable)getResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)getResponse.getBody()).isEqualToComparingFieldByFieldRecursively(postResponse.getBody());
        EmployeeAvailabilityView newEmployeeAvailabilityView = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.DESIRED);
        newEmployeeAvailabilityView.setId(((EmployeeAvailabilityView)postResponse.getBody()).getId());
        HttpEntity request = new HttpEntity((Object)newEmployeeAvailabilityView);
        ResponseEntity<EmployeeAvailabilityView> putResponse = this.updateEmployeeAvailability(this.TENANT_ID, (HttpEntity<EmployeeAvailabilityView>)request);
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        getResponse = this.getEmployeeAvailability(this.TENANT_ID, ((EmployeeAvailabilityView)putResponse.getBody()).getId());
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)getResponse.getBody()).isEqualToComparingFieldByFieldRecursively(putResponse.getBody());
        this.deleteEmployeeAvailability(this.TENANT_ID, ((EmployeeAvailabilityView)putResponse.getBody()).getId());
    }
}

