/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.rotation;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalTime;
import java.util.Collections;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.rotation.TimeBucket;
import org.optaweb.employeerostering.domain.rotation.view.TimeBucketView;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.optaweb.employeerostering.service.rotation.RotationService;
import org.optaweb.employeerostering.service.spot.SpotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringRunner.class)
@SpringBootTest
@AutoConfigureTestDatabase
@AutoConfigureMockMvc
@Transactional
public class RotationServiceTest
extends AbstractEntityRequireTenantRestServiceTest {
    private static final Logger logger = LoggerFactory.getLogger(RotationServiceTest.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private MockMvc mvc;
    @Autowired
    private RotationService rotationService;
    @Autowired
    private SpotService spotService;

    private Spot createSpot(Integer tenantId, String name, Set<Skill> requiredSkillSet) {
        SpotView spotView = new SpotView(tenantId, name, requiredSkillSet);
        return this.spotService.createSpot(tenantId, spotView);
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void getTimeBucketListTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/rotation/", (Object[])new Object[]{this.TENANT_ID}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getTimeBucketTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        TimeBucketView timeBucketView = new TimeBucketView(new TimeBucket(this.TENANT_ID, spot, LocalTime.of(9, 0), LocalTime.of(17, 0), Collections.emptySet(), Collections.emptySet(), Collections.emptyList()));
        TimeBucketView persistedTimeBucket = this.rotationService.createTimeBucket(this.TENANT_ID, timeBucketView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/rotation/{id}", (Object[])new Object[]{this.TENANT_ID, persistedTimeBucket.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.spotId", (Object[])new Object[0]).value((Object)spot.getId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.startTime", (Object[])new Object[0]).value((Object)"09:00:00")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.endTime", (Object[])new Object[0]).value((Object)"17:00:00"));
    }

    @Test
    public void getNonExistentTimeBucketTest() throws Exception {
        String exceptionMessage = "No TimeBucket entity found with ID (0).";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/rotation/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void deleteTimeBucketTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        TimeBucketView timeBucketView = new TimeBucketView(new TimeBucket(this.TENANT_ID, spot, LocalTime.of(9, 0), LocalTime.of(17, 0), Collections.emptySet(), Collections.emptySet(), Collections.emptyList()));
        TimeBucketView persistedTimeBucket = this.rotationService.createTimeBucket(this.TENANT_ID, timeBucketView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/rotation/{id}", (Object[])new Object[]{this.TENANT_ID, persistedTimeBucket.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("true"));
    }

    @Test
    public void deleteNonMatchingTimeBucketTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        TimeBucketView timeBucketView = new TimeBucketView(new TimeBucket(this.TENANT_ID, spot, LocalTime.of(9, 0), LocalTime.of(17, 0), Collections.emptySet(), Collections.emptySet(), Collections.emptyList()));
        TimeBucketView persistedTimeBucket = this.rotationService.createTimeBucket(this.TENANT_ID, timeBucketView);
        String timeBucketName = "[TimeBucket-" + persistedTimeBucket.getId() + "]";
        String exceptionMessage = "The tenantId (0) does not match the persistable (" + timeBucketName + ")'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/rotation/{id}", (Object[])new Object[]{0, persistedTimeBucket.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void createTimeBucketTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        TimeBucketView timeBucketView = new TimeBucketView(new TimeBucket(this.TENANT_ID, spot, LocalTime.of(9, 0), LocalTime.of(17, 0), Collections.emptySet(), Collections.emptySet(), Collections.emptyList()));
        String body = this.objectMapper.writeValueAsString((Object)timeBucketView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/rotation/add", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.spotId", (Object[])new Object[0]).value((Object)spot.getId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.startTime", (Object[])new Object[0]).value((Object)"09:00:00")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.endTime", (Object[])new Object[0]).value((Object)"17:00:00"));
    }

    @Test
    public void createNonMatchingTimeBucketTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        TimeBucketView timeBucketView = new TimeBucketView(new TimeBucket(Integer.valueOf(0), spot, LocalTime.of(9, 0), LocalTime.of(17, 0), Collections.emptySet(), Collections.emptySet(), Collections.emptyList()));
        String body = this.objectMapper.writeValueAsString((Object)timeBucketView);
        String timeBucketName = "[TimeBucket-null]";
        String exceptionMessage = "The tenantId (" + this.TENANT_ID + ") does not match the persistable (" + timeBucketName + ")'s tenantId (0).";
        String exceptionClass = "java.lang.IllegalStateException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/rotation/add", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateTimeBucketTest() throws Exception {
        Spot spotA = this.createSpot(this.TENANT_ID, "A", Collections.emptySet());
        Spot spotB = this.createSpot(this.TENANT_ID, "B", Collections.emptySet());
        TimeBucketView timeBucketView = new TimeBucketView(new TimeBucket(this.TENANT_ID, spotA, LocalTime.of(9, 0), LocalTime.of(17, 0), Collections.emptySet(), Collections.emptySet(), Collections.emptyList()));
        TimeBucketView persistedTimeBucket = this.rotationService.createTimeBucket(this.TENANT_ID, timeBucketView);
        TimeBucketView updatedTimeBucket = new TimeBucketView(new TimeBucket(this.TENANT_ID, spotB, LocalTime.of(9, 0), LocalTime.of(17, 0), Collections.emptySet(), Collections.emptySet(), Collections.emptyList()));
        updatedTimeBucket.setId(persistedTimeBucket.getId());
        String body = this.objectMapper.writeValueAsString((Object)updatedTimeBucket);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/tenant/{tenantId}/rotation/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.spotId", (Object[])new Object[0]).value((Object)spotB.getId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.startTime", (Object[])new Object[0]).value((Object)"09:00:00")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.endTime", (Object[])new Object[0]).value((Object)"17:00:00"));
    }

    @Test
    public void updateNonExistentTimeBucketTest() throws Exception {
        String exceptionMessage = "TimeBucket entity with ID (0) not found.";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        Spot spot = this.createSpot(this.TENANT_ID, "spot", Collections.emptySet());
        TimeBucketView timeBucketView = new TimeBucketView(new TimeBucket(this.TENANT_ID, spot, LocalTime.of(9, 0), LocalTime.of(17, 0), Collections.emptySet(), Collections.emptySet(), Collections.emptyList()));
        timeBucketView.setId(Long.valueOf(0L));
        String body = this.objectMapper.writeValueAsString((Object)timeBucketView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/tenant/{tenantId}/rotation/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }
}

