/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.skill;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.skill.view.SkillView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class SkillRestControllerTest
extends AbstractEntityRequireTenantRestServiceTest {
    @Autowired
    private TestRestTemplate restTemplate;
    private final String skillPathURI = "http://localhost:8080/rest/tenant/{tenantId}/skill/";

    private ResponseEntity<List<Skill>> getSkills(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/skill/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Skill>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<Skill> getSkill(Integer tenantId, Long id) {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/{tenantId}/skill/" + id, Skill.class, new Object[]{tenantId});
    }

    private void deleteSkill(Integer tenantId, Long id) {
        this.restTemplate.delete("http://localhost:8080/rest/tenant/{tenantId}/skill/" + id, new Object[]{tenantId});
    }

    private ResponseEntity<Skill> addSkill(Integer tenantId, SkillView skillView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/skill/add", (Object)skillView, Skill.class, new Object[]{tenantId});
    }

    private ResponseEntity<Skill> updateSkill(Integer tenantId, SkillView skillView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/skill/update", (Object)skillView, Skill.class, new Object[]{tenantId});
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void skillCrudTest() {
        SkillView skillView = new SkillView(this.TENANT_ID, "skill");
        ResponseEntity<Skill> postResponse = this.addSkill(this.TENANT_ID, skillView);
        Assertions.assertThat((Comparable)postResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        ResponseEntity<Skill> response = this.getSkill(this.TENANT_ID, ((Skill)postResponse.getBody()).getId());
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)response.getBody()).isEqualToComparingFieldByFieldRecursively(postResponse.getBody());
        SkillView updatedSkill = new SkillView(this.TENANT_ID, "updatedSkill");
        updatedSkill.setId(((Skill)postResponse.getBody()).getId());
        ResponseEntity<Skill> putResponse = this.updateSkill(this.TENANT_ID, updatedSkill);
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        response = this.getSkill(this.TENANT_ID, ((Skill)putResponse.getBody()).getId());
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)putResponse.getBody()).isEqualToComparingFieldByFieldRecursively(response.getBody());
        this.deleteSkill(this.TENANT_ID, ((Skill)postResponse.getBody()).getId());
        ResponseEntity<List<Skill>> getListResponse = this.getSkills(this.TENANT_ID);
        Assertions.assertThat((Comparable)getListResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)getListResponse.getBody())).isEmpty();
    }
}

