/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.spot;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class SpotRestControllerTest
extends AbstractEntityRequireTenantRestServiceTest {
    @Autowired
    private TestRestTemplate restTemplate;
    private final String spotPathURI = "http://localhost:8080/rest/tenant/{tenantId}/spot/";

    private ResponseEntity<List<Spot>> getSpots(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/spot/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Spot>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<Spot> getSpot(Integer tenantId, Long id) {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/{tenantId}/spot/" + id, Spot.class, new Object[]{tenantId});
    }

    private void deleteSpot(Integer tenantId, Long id) {
        this.restTemplate.delete("http://localhost:8080/rest/tenant/{tenantId}/spot/" + id, new Object[]{tenantId});
    }

    private ResponseEntity<Spot> addSpot(Integer tenantId, SpotView spotView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/spot/add", (Object)spotView, Spot.class, new Object[]{tenantId});
    }

    private ResponseEntity<Spot> updateSpot(Integer tenantId, SpotView spotView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/spot/update", (Object)spotView, Spot.class, new Object[]{tenantId});
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void spotCrudTest() {
        SpotView spotView = new SpotView(this.TENANT_ID, "spot", Collections.emptySet());
        ResponseEntity<Spot> postResponse = this.addSpot(this.TENANT_ID, spotView);
        Assertions.assertThat((Comparable)postResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        ResponseEntity<Spot> response = this.getSpot(this.TENANT_ID, ((Spot)postResponse.getBody()).getId());
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)response.getBody()).isEqualToComparingFieldByFieldRecursively(postResponse.getBody());
        SpotView updatedSpot = new SpotView(this.TENANT_ID, "updatedSpot", Collections.emptySet());
        updatedSpot.setId(((Spot)postResponse.getBody()).getId());
        ResponseEntity<Spot> putResponse = this.updateSpot(this.TENANT_ID, updatedSpot);
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        response = this.getSpot(this.TENANT_ID, ((Spot)putResponse.getBody()).getId());
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)putResponse.getBody()).isEqualToComparingFieldByFieldRecursively(response.getBody());
        this.deleteSpot(this.TENANT_ID, ((Spot)postResponse.getBody()).getId());
        ResponseEntity<List<Spot>> getListResponse = this.getSpots(this.TENANT_ID);
        Assertions.assertThat((Comparable)getListResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)getListResponse.getBody())).isEmpty();
    }
}

