/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.common;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.violation.ContractMinutesViolation;
import org.optaweb.employeerostering.domain.violation.DesiredTimeslotForEmployeeReward;
import org.optaweb.employeerostering.domain.violation.IndictmentSummary;
import org.optaweb.employeerostering.domain.violation.NoBreakViolation;
import org.optaweb.employeerostering.domain.violation.PublishedShiftReassignedPenalty;
import org.optaweb.employeerostering.domain.violation.RequiredSkillViolation;
import org.optaweb.employeerostering.domain.violation.RotationViolationPenalty;
import org.optaweb.employeerostering.domain.violation.ShiftEmployeeConflict;
import org.optaweb.employeerostering.domain.violation.UnassignedShiftPenalty;
import org.optaweb.employeerostering.domain.violation.UnavailableEmployeeViolation;
import org.optaweb.employeerostering.domain.violation.UndesiredTimeslotForEmployeePenalty;
import org.optaweb.employeerostering.service.solver.WannabeSolverManager;
import org.springframework.stereotype.Component;

@Component
public class IndictmentUtils {
    public static final String CONSTRAINT_MATCH_PACKAGE = "org.optaweb.employeerostering.service.solver";
    private WannabeSolverManager solverManager;

    public IndictmentUtils(WannabeSolverManager solverManager) {
        this.solverManager = solverManager;
    }

    public Map<Object, Indictment> getIndictmentMapForRoster(Roster roster) {
        try (ScoreDirector<Roster> scoreDirector = this.solverManager.getScoreDirector();){
            scoreDirector.setWorkingSolution((Object)roster);
            scoreDirector.calculateScore();
            Map map = scoreDirector.getIndictmentMap();
            return map;
        }
    }

    public IndictmentSummary getIndictmentSummaryForRoster(Roster roster) {
        try (ScoreDirector<Roster> scoreDirector = this.solverManager.getScoreDirector();){
            scoreDirector.setWorkingSolution((Object)roster);
            scoreDirector.calculateScore();
            Map constraintMatchTotalMap = scoreDirector.getConstraintMatchTotalMap();
            IndictmentSummary out = new IndictmentSummary();
            out.setConstraintToCountMap(constraintMatchTotalMap.values().stream().collect(Collectors.toMap(ConstraintMatchTotal::getConstraintName, ConstraintMatchTotal::getConstraintMatchCount)));
            out.setConstraintToScoreImpactMap(constraintMatchTotalMap.values().stream().collect(Collectors.toMap(ConstraintMatchTotal::getConstraintName, cmt -> (HardMediumSoftLongScore)cmt.getScore())));
            IndictmentSummary indictmentSummary = out;
            return indictmentSummary;
        }
    }

    public ShiftView getShiftViewWithIndictment(ZoneId zoneId, Shift shift, Indictment indictment) {
        return new ShiftView(zoneId, shift, this.getRequiredSkillViolationList(indictment), this.getUnavailableEmployeeViolationList(indictment), this.getShiftEmployeeConflictList(indictment), this.getDesiredTimeslotForEmployeeRewardList(indictment), this.getUndesiredTimeslotForEmployeePenaltyList(indictment), this.getRotationViolationPenaltyList(indictment), this.getUnassignedShiftPenaltyList(indictment), this.getContractMinutesViolationList(indictment), this.getNoBreakViolationList(indictment), this.getPublishedShiftReassignedPenaltyList(indictment), indictment != null ? (HardMediumSoftLongScore)indictment.getScore() : HardMediumSoftLongScore.ZERO);
    }

    public List<RequiredSkillViolation> getRequiredSkillViolationList(Indictment indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(cm -> cm.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && cm.getConstraintName().equals("Required skill for a shift")).map(cm -> new RequiredSkillViolation((Shift)cm.getJustificationList().get(0), (HardMediumSoftLongScore)cm.getScore())).collect(Collectors.toList());
    }

    public List<UnavailableEmployeeViolation> getUnavailableEmployeeViolationList(Indictment indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(cm -> cm.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && cm.getConstraintName().equals("Unavailable time slot for an employee")).map(cm -> new UnavailableEmployeeViolation((Shift)cm.getJustificationList().get(0), (EmployeeAvailability)cm.getJustificationList().get(1), (HardMediumSoftLongScore)cm.getScore())).collect(Collectors.toList());
    }

    public List<DesiredTimeslotForEmployeeReward> getDesiredTimeslotForEmployeeRewardList(Indictment indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(cm -> cm.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && cm.getConstraintName().equals("Desired time slot for an employee")).map(cm -> new DesiredTimeslotForEmployeeReward((Shift)cm.getJustificationList().get(0), (EmployeeAvailability)cm.getJustificationList().get(1), (HardMediumSoftLongScore)cm.getScore())).collect(Collectors.toList());
    }

    public List<UndesiredTimeslotForEmployeePenalty> getUndesiredTimeslotForEmployeePenaltyList(Indictment indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(cm -> cm.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && cm.getConstraintName().equals("Undesired time slot for an employee")).map(cm -> new UndesiredTimeslotForEmployeePenalty((Shift)cm.getJustificationList().get(0), (EmployeeAvailability)cm.getJustificationList().get(1), (HardMediumSoftLongScore)cm.getScore())).collect(Collectors.toList());
    }

    public List<ShiftEmployeeConflict> getShiftEmployeeConflictList(Indictment indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        List<String> employeeShiftConstraintNameList = Arrays.asList("Break between non-consecutive shifts is at least 10 hours", "No overlapping shifts");
        return indictment.getConstraintMatchSet().stream().filter(cm -> cm.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && employeeShiftConstraintNameList.contains(cm.getConstraintName())).map(cm -> new ShiftEmployeeConflict((Shift)cm.getJustificationList().get(0), (Shift)cm.getJustificationList().get(1), (HardMediumSoftLongScore)cm.getScore())).collect(Collectors.toList());
    }

    public List<NoBreakViolation> getNoBreakViolationList(Indictment indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(cm -> cm.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && cm.getConstraintName().equals("No more than 2 consecutive shifts")).map(cm -> new NoBreakViolation((Shift)cm.getJustificationList().get(0), (Shift)cm.getJustificationList().get(1), (Shift)cm.getJustificationList().get(2), (HardMediumSoftLongScore)cm.getScore())).collect(Collectors.toList());
    }

    public List<RotationViolationPenalty> getRotationViolationPenaltyList(Indictment indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(cm -> cm.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && cm.getConstraintName().equals("Employee is not rotation employee")).map(cm -> new RotationViolationPenalty((Shift)cm.getJustificationList().get(0), (HardMediumSoftLongScore)cm.getScore())).collect(Collectors.toList());
    }

    public List<UnassignedShiftPenalty> getUnassignedShiftPenaltyList(Indictment indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(cm -> cm.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && cm.getConstraintName().equals("Assign every shift")).map(cm -> new UnassignedShiftPenalty((Shift)cm.getJustificationList().get(0), (HardMediumSoftLongScore)cm.getScore())).collect(Collectors.toList());
    }

    public List<ContractMinutesViolation> getContractMinutesViolationList(Indictment indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        List<String> contractMinutesConstraintNameList = Arrays.asList("Daily minutes must not exceed contract maximum", "Weekly minutes must not exceed contract maximum", "Monthly minutes must not exceed contract maximum", "Yearly minutes must not exceed contract maximum");
        return indictment.getConstraintMatchSet().stream().filter(cm -> cm.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && contractMinutesConstraintNameList.contains(cm.getConstraintName())).map(cm -> new ContractMinutesViolation((Employee)cm.getJustificationList().stream().filter(o -> o instanceof Employee).findFirst().get(), ContractMinutesViolation.Type.getTypeForViolation(cm.getConstraintName()), (Long)cm.getJustificationList().stream().filter(o -> o instanceof Long).findFirst().get(), (HardMediumSoftLongScore)cm.getScore())).collect(Collectors.toList());
    }

    public List<PublishedShiftReassignedPenalty> getPublishedShiftReassignedPenaltyList(Indictment indictment) {
        if (indictment == null) {
            return Collections.emptyList();
        }
        return indictment.getConstraintMatchSet().stream().filter(cm -> cm.getConstraintPackage().equals(CONSTRAINT_MATCH_PACKAGE) && cm.getConstraintName().equals("Employee is not original employee")).map(cm -> new PublishedShiftReassignedPenalty((Shift)cm.getJustificationList().get(0), (HardMediumSoftLongScore)cm.getScore())).collect(Collectors.toList());
    }
}

