/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.generator;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.rotation.view.TimeBucketView;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.tenant.Tenant;
import org.optaweb.employeerostering.service.roster.RosterGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class RosterGeneratorTest {
    @Autowired
    private TestRestTemplate restTemplate;
    @Autowired
    private RosterGenerator rosterGenerator;
    private Integer tenantId;
    private final String skillPathURI = "http://localhost:8080/rest/tenant/{tenantId}/skill/";
    private final String spotPathURI = "http://localhost:8080/rest/tenant/{tenantId}/spot/";
    private final String contractPathURI = "http://localhost:8080/rest/tenant/{tenantId}/contract/";
    private final String employeePathURI = "http://localhost:8080/rest/tenant/{tenantId}/employee/";
    private final String rotationPathURI = "http://localhost:8080/rest/tenant/{tenantId}/rotation/";
    private final String tenantPathURI = "http://localhost:8080/rest/tenant/";
    private final String shiftPathURI = "http://localhost:8080/rest/tenant/{tenantId}/shift/";

    private ResponseEntity<List<Skill>> getSkills(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/skill/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Skill>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<List<Spot>> getSpots(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/spot/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Spot>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<List<Contract>> getContracts(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/contract/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Contract>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<List<Employee>> getEmployees(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/employee/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Employee>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<List<TimeBucketView>> getTimeBuckets(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/rotation/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<TimeBucketView>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<List<ShiftView>> getShifts(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/shift/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ShiftView>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<List<Tenant>> getTenants() {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<Tenant>>(){}, new Object[0]);
    }

    @Before
    public void setup() {
        this.tenantId = this.rosterGenerator.generateRoster(2, 7).getTenantId();
    }

    @After
    public void cleanup() {
        this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/remove/" + this.tenantId, null, Void.class, new Object[0]);
    }

    @Test
    public void generateSkillListTest() {
        ResponseEntity<List<Skill>> response = this.getSkills(this.tenantId);
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)response.getBody())).size().isGreaterThan(0);
    }

    @Test
    public void generateSpotListTest() {
        ResponseEntity<List<Spot>> response = this.getSpots(this.tenantId);
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)response.getBody())).size().isGreaterThan(0);
    }

    @Test
    public void generateContractListTest() {
        ResponseEntity<List<Contract>> response = this.getContracts(this.tenantId);
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)response.getBody())).size().isGreaterThan(0);
    }

    @Test
    public void generateEmployeeListTest() {
        ResponseEntity<List<Employee>> response = this.getEmployees(this.tenantId);
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)response.getBody())).size().isGreaterThan(0);
    }

    @Test
    public void generateShiftTemplateListTest() {
        ResponseEntity<List<TimeBucketView>> response = this.getTimeBuckets(this.tenantId);
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)response.getBody())).size().isGreaterThan(0);
    }

    @Test
    public void generateShiftListTest() {
        ResponseEntity<List<ShiftView>> response = this.getShifts(this.tenantId);
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
    }

    @Test
    public void generateTenantListTest() {
        ResponseEntity<List<Tenant>> response = this.getTenants();
        Assertions.assertThat((List)((List)response.getBody())).size().isGreaterThan(0);
    }
}

