/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.rotation;

import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.rotation.TimeBucket;
import org.optaweb.employeerostering.domain.rotation.view.TimeBucketView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class RotationRestControllerTest
extends AbstractEntityRequireTenantRestServiceTest {
    @Autowired
    private TestRestTemplate restTemplate;
    private final String timeBucketPathURI = "http://localhost:8080/rest/tenant/{tenantId}/rotation/";
    private final String spotPathURI = "http://localhost:8080/rest/tenant/{tenantId}/spot/";

    private ResponseEntity<List<TimeBucketView>> getTimeBuckets(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/rotation/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<TimeBucketView>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<TimeBucketView> getTimeBucket(Integer tenantId, Long id) {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/{tenantId}/rotation/" + id, TimeBucketView.class, new Object[]{tenantId});
    }

    private void deleteTimeBucket(Integer tenantId, Long id) {
        this.restTemplate.delete("http://localhost:8080/rest/tenant/{tenantId}/rotation/" + id, new Object[]{tenantId});
    }

    private ResponseEntity<TimeBucketView> addTimeBucket(Integer tenantId, TimeBucketView shiftTemplateView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/rotation/add", (Object)shiftTemplateView, TimeBucketView.class, new Object[]{tenantId});
    }

    private ResponseEntity<TimeBucketView> updateTimeBucket(Integer tenantId, HttpEntity<TimeBucketView> request) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/rotation/update", HttpMethod.PUT, request, TimeBucketView.class, new Object[]{tenantId});
    }

    private ResponseEntity<Spot> addSpot(Integer tenantId, SpotView spotView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/spot/add", (Object)spotView, Spot.class, new Object[]{tenantId});
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void shiftTemplateCrudTest() {
        ResponseEntity<Spot> spotResponseA = this.addSpot(this.TENANT_ID, new SpotView(this.TENANT_ID, "A", Collections.emptySet()));
        Spot spotA = (Spot)spotResponseA.getBody();
        TimeBucketView timeBucketView = new TimeBucketView(new TimeBucket(this.TENANT_ID, spotA, LocalTime.of(9, 0), LocalTime.of(17, 0), Collections.emptySet(), Collections.emptySet(), Collections.emptyList()));
        ResponseEntity<TimeBucketView> postResponse = this.addTimeBucket(this.TENANT_ID, timeBucketView);
        Assertions.assertThat((Comparable)postResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        ResponseEntity<TimeBucketView> response = this.getTimeBucket(this.TENANT_ID, ((TimeBucketView)postResponse.getBody()).getId());
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)response.getBody()).usingRecursiveComparison().isEqualTo(postResponse.getBody());
        TimeBucketView updatedTimeBucket = new TimeBucketView(new TimeBucket(this.TENANT_ID, spotA, LocalTime.of(9, 0), LocalTime.of(17, 0), Collections.emptySet(), Collections.emptySet(), Collections.emptyList()));
        updatedTimeBucket.setId(((TimeBucketView)postResponse.getBody()).getId());
        HttpEntity request = new HttpEntity((Object)updatedTimeBucket);
        ResponseEntity<TimeBucketView> putResponse = this.updateTimeBucket(this.TENANT_ID, (HttpEntity<TimeBucketView>)request);
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        response = this.getTimeBucket(this.TENANT_ID, ((TimeBucketView)putResponse.getBody()).getId());
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)putResponse.getBody()).isEqualTo(response.getBody());
        this.deleteTimeBucket(this.TENANT_ID, ((TimeBucketView)putResponse.getBody()).getId());
        ResponseEntity<List<TimeBucketView>> getListResponse = this.getTimeBuckets(this.TENANT_ID);
        Assertions.assertThat((Comparable)getListResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)getListResponse.getBody())).isEmpty();
    }
}

