/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shift;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class ShiftRestControllerTest
extends AbstractEntityRequireTenantRestServiceTest {
    @Autowired
    private TestRestTemplate restTemplate;
    private final String shiftPathURI = "http://localhost:8080/rest/tenant/{tenantId}/shift/";
    private final String employeePathURI = "http://localhost:8080/rest/tenant/{tenantId}/employee/";
    private final String contractPathURI = "http://localhost:8080/rest/tenant/{tenantId}/contract/";
    private final String spotPathURI = "http://localhost:8080/rest/tenant/{tenantId}/spot/";

    private ResponseEntity<List<ShiftView>> getShifts(Integer tenantId) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/shift/", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ShiftView>>(){}, new Object[]{tenantId});
    }

    private ResponseEntity<ShiftView> getShift(Integer tenantId, Long id) {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/{tenantId}/shift/" + id, ShiftView.class, new Object[]{tenantId});
    }

    private void deleteShift(Integer tenantId, Long id) {
        this.restTemplate.delete("http://localhost:8080/rest/tenant/{tenantId}/shift/" + id, new Object[]{tenantId});
    }

    private ResponseEntity<ShiftView> addShift(Integer tenantId, ShiftView shiftView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/shift/add", (Object)shiftView, ShiftView.class, new Object[]{tenantId});
    }

    private ResponseEntity<ShiftView> updateShift(Integer tenantId, HttpEntity<ShiftView> request) {
        return this.restTemplate.exchange("http://localhost:8080/rest/tenant/{tenantId}/shift/update", HttpMethod.PUT, request, ShiftView.class, new Object[]{tenantId});
    }

    private ResponseEntity<Employee> addEmployee(Integer tenantId, Employee employee) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/employee/add", (Object)employee, Employee.class, new Object[]{tenantId});
    }

    private ResponseEntity<Contract> addContract(Integer tenantId, Contract contract) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/contract/add", (Object)contract, Contract.class, new Object[]{tenantId});
    }

    private ResponseEntity<Spot> addSpot(Integer tenantId, SpotView spotView) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/spot/add", (Object)spotView, Spot.class, new Object[]{tenantId});
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void shiftCrudTest() {
        ResponseEntity<Spot> spotResponseEntity = this.addSpot(this.TENANT_ID, new SpotView(this.TENANT_ID, "spot", Collections.emptySet()));
        Spot spot = (Spot)spotResponseEntity.getBody();
        ResponseEntity<Contract> contractResponseEntity = this.addContract(this.TENANT_ID, new Contract(this.TENANT_ID, "contract"));
        Contract contract = (Contract)contractResponseEntity.getBody();
        ResponseEntity<Employee> rotationEmployeeResponseEntity = this.addEmployee(this.TENANT_ID, new Employee(this.TENANT_ID, "rotationEmployee", contract, Collections.emptySet()));
        Employee rotationEmployee = (Employee)rotationEmployeeResponseEntity.getBody();
        LocalDateTime startDateTime = LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0);
        LocalDateTime endDateTime = startDateTime.plusHours(8L);
        ShiftView shiftView = new ShiftView(this.TENANT_ID, spot, startDateTime, endDateTime, rotationEmployee);
        ResponseEntity<ShiftView> postResponse = this.addShift(this.TENANT_ID, shiftView);
        Assertions.assertThat((Comparable)postResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        ResponseEntity<ShiftView> getResponse = this.getShift(this.TENANT_ID, ((ShiftView)postResponse.getBody()).getId());
        Assertions.assertThat((Comparable)getResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)getResponse.getBody()).isEqualToComparingFieldByFieldRecursively(postResponse.getBody());
        ShiftView updatedShiftView = new ShiftView(this.TENANT_ID, spot, startDateTime, endDateTime);
        updatedShiftView.setId(((ShiftView)postResponse.getBody()).getId());
        HttpEntity request = new HttpEntity((Object)updatedShiftView);
        ResponseEntity<ShiftView> putResponse = this.updateShift(this.TENANT_ID, (HttpEntity<ShiftView>)request);
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        getResponse = this.getShift(this.TENANT_ID, ((ShiftView)putResponse.getBody()).getId());
        Assertions.assertThat((Comparable)putResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)putResponse.getBody()).isEqualToComparingFieldByFieldRecursively(getResponse.getBody());
        this.deleteShift(this.TENANT_ID, ((ShiftView)putResponse.getBody()).getId());
        ResponseEntity<List<ShiftView>> getShiftListResponse = this.getShifts(this.TENANT_ID);
        Assertions.assertThat((Comparable)getShiftListResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((List)((List)getShiftListResponse.getBody())).isEmpty();
    }
}

