/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.skill;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.skill.view.SkillView;
import org.optaweb.employeerostering.service.skill.SkillService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringRunner.class)
@SpringBootTest
@AutoConfigureTestDatabase
@AutoConfigureMockMvc
@Transactional
public class SkillServiceTest
extends AbstractEntityRequireTenantRestServiceTest {
    private static final Logger logger = LoggerFactory.getLogger(SkillServiceTest.class);
    @Autowired
    private MockMvc mvc;
    @Autowired
    private SkillService skillService;

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void getSkillListTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/skill/", (Object[])new Object[]{this.TENANT_ID}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getSkillTest() throws Exception {
        SkillView skillView = new SkillView(this.TENANT_ID, "skill");
        Skill skill = this.skillService.createSkill(this.TENANT_ID, skillView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/skill/{id}", (Object[])new Object[]{this.TENANT_ID, skill.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"skill"));
    }

    @Test
    public void getNonExistentSkillTest() throws Exception {
        String exceptionMessage = "No Skill entity found with ID (0).";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/skill/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void getNonMatchingSkillTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (skill)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        SkillView skillView = new SkillView(this.TENANT_ID, "skill");
        Skill skill = this.skillService.createSkill(this.TENANT_ID, skillView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/skill/{id}", (Object[])new Object[]{0, skill.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void deleteSkillTest() throws Exception {
        SkillView skillView = new SkillView(this.TENANT_ID, "skill");
        Skill skill = this.skillService.createSkill(this.TENANT_ID, skillView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/skill/{id}", (Object[])new Object[]{this.TENANT_ID, skill.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("true"));
    }

    @Test
    public void deleteNonExistentSkillTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/skill/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("false"));
    }

    @Test
    public void deleteNonMatchingSkillTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (skill)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        SkillView skillView = new SkillView(this.TENANT_ID, "skill");
        Skill skill = this.skillService.createSkill(this.TENANT_ID, skillView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/skill/{id}", (Object[])new Object[]{0, skill.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void createSkillTest() throws Exception {
        SkillView skillView = new SkillView(this.TENANT_ID, "skill");
        String body = new ObjectMapper().writeValueAsString((Object)skillView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/skill/add", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"skill"));
    }

    @Test
    public void createNonMatchingSkillTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (skill)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        SkillView skillView = new SkillView(this.TENANT_ID, "skill");
        String body = new ObjectMapper().writeValueAsString((Object)skillView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/skill/add", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateSkillTest() throws Exception {
        SkillView skillView = new SkillView(this.TENANT_ID, "skill");
        Skill skill = this.skillService.createSkill(this.TENANT_ID, skillView);
        SkillView updatedSkill = new SkillView(this.TENANT_ID, "updatedSkill");
        updatedSkill.setId(skill.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedSkill);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/skill/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"updatedSkill"));
    }

    @Test
    public void updateNonMatchingSkillTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (updatedSkill)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        SkillView skillView = new SkillView(this.TENANT_ID, "skill");
        this.skillService.createSkill(this.TENANT_ID, skillView);
        SkillView updatedSkill = new SkillView(this.TENANT_ID, "updatedSkill");
        String body = new ObjectMapper().writeValueAsString((Object)updatedSkill);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/skill/update", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateNonExistentSkillTest() throws Exception {
        String exceptionMessage = "Skill entity with ID (0) not found.";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        SkillView skillView = new SkillView(this.TENANT_ID, "skill");
        skillView.setId(Long.valueOf(0L));
        String body = new ObjectMapper().writeValueAsString((Object)skillView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/skill/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateChangeTenantIdSkillTest() throws Exception {
        String exceptionMessage = "Skill entity with tenantId (" + this.TENANT_ID + ") cannot change tenants.";
        String exceptionClass = "java.lang.IllegalStateException";
        SkillView skillView = new SkillView(this.TENANT_ID, "skill");
        Skill skill = this.skillService.createSkill(this.TENANT_ID, skillView);
        SkillView updatedSkill = new SkillView(Integer.valueOf(0), "updatedSkill");
        updatedSkill.setId(skill.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedSkill);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/skill/update", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }
}

