/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.spot;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashSet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.skill.view.SkillView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.optaweb.employeerostering.service.skill.SkillService;
import org.optaweb.employeerostering.service.spot.SpotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringRunner.class)
@SpringBootTest
@AutoConfigureTestDatabase
@AutoConfigureMockMvc
@Transactional
public class SpotServiceTest
extends AbstractEntityRequireTenantRestServiceTest {
    private static final Logger logger = LoggerFactory.getLogger(SpotServiceTest.class);
    @Autowired
    private MockMvc mvc;
    @Autowired
    private SpotService spotService;
    @Autowired
    private SkillService skillService;

    private Skill createSkill(Integer tenantId, String name) {
        SkillView skillView = new SkillView(tenantId, name);
        return this.skillService.createSkill(tenantId, skillView);
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void getSpotListTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/spot/", (Object[])new Object[]{this.TENANT_ID}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getSpotTest() throws Exception {
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        SpotView spotView = new SpotView(this.TENANT_ID, "spot", testSkillSet);
        Spot spot = this.spotService.createSpot(this.TENANT_ID, spotView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/spot/{id}", (Object[])new Object[]{this.TENANT_ID, spot.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"spot")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.requiredSkillSet", (Object[])new Object[0]).isNotEmpty());
    }

    @Test
    public void getNonExistentSpotTest() throws Exception {
        String exceptionMessage = "No Spot entity found with ID (0).";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/spot/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void getNonMatchingSpotTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (spot)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        SpotView spotView = new SpotView(this.TENANT_ID, "spot", testSkillSet);
        Spot spot = this.spotService.createSpot(this.TENANT_ID, spotView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/spot/{id}", (Object[])new Object[]{0, spot.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void deleteSpotTest() throws Exception {
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        SpotView spotView = new SpotView(this.TENANT_ID, "spot", testSkillSet);
        Spot spot = this.spotService.createSpot(this.TENANT_ID, spotView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/spot/{id}", (Object[])new Object[]{this.TENANT_ID, spot.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("true"));
    }

    @Test
    public void deleteNonExistentSpotTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/spot/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("false"));
    }

    @Test
    public void deleteNonMatchingSpotTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (spot)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        SpotView spotView = new SpotView(this.TENANT_ID, "spot", testSkillSet);
        Spot spot = this.spotService.createSpot(this.TENANT_ID, spotView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/spot/{id}", (Object[])new Object[]{0, spot.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void createSpotTest() throws Exception {
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        SpotView spotView = new SpotView(this.TENANT_ID, "spot", testSkillSet);
        String body = new ObjectMapper().writeValueAsString((Object)spotView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/spot/add", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"spot")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.requiredSkillSet", (Object[])new Object[0]).isNotEmpty());
    }

    @Test
    public void createNonMatchingSpotTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (spot)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        SpotView spotView = new SpotView(this.TENANT_ID, "spot", testSkillSet);
        String body = new ObjectMapper().writeValueAsString((Object)spotView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/spot/add", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateSpotTest() throws Exception {
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        SpotView spotView = new SpotView(this.TENANT_ID, "spot", testSkillSet);
        Spot spot = this.spotService.createSpot(this.TENANT_ID, spotView);
        SpotView updatedSpot = new SpotView(this.TENANT_ID, "updatedSpot", testSkillSet);
        updatedSpot.setId(spot.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedSpot);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/spot/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"updatedSpot")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.requiredSkillSet", (Object[])new Object[0]).isNotEmpty());
    }

    @Test
    public void updateNonMatchingSpotTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (updatedSpot)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        SpotView spotView = new SpotView(this.TENANT_ID, "spot", testSkillSet);
        this.spotService.createSpot(this.TENANT_ID, spotView);
        SpotView updatedSpot = new SpotView(this.TENANT_ID, "updatedSpot", testSkillSet);
        String body = new ObjectMapper().writeValueAsString((Object)updatedSpot);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/spot/update", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateNonExistentSpotTest() throws Exception {
        String exceptionMessage = "Spot entity with ID (0) not found.";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        SpotView spotView = new SpotView(this.TENANT_ID, "spot", Collections.emptySet());
        spotView.setId(Long.valueOf(0L));
        String body = new ObjectMapper().writeValueAsString((Object)spotView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/spot/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateChangeTenantIdSpotTest() throws Exception {
        String exceptionMessage = "Spot entity with tenantId (" + this.TENANT_ID + ") cannot change tenants.";
        String exceptionClass = "java.lang.IllegalStateException";
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        SpotView spotView = new SpotView(this.TENANT_ID, "spot", testSkillSet);
        Spot spot = this.spotService.createSpot(this.TENANT_ID, spotView);
        SpotView updatedSpot = new SpotView(Integer.valueOf(0), "updatedSpot", testSkillSet);
        updatedSpot.setId(spot.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedSpot);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/spot/update", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }
}

