/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.service.roster.RosterGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.transaction.annotation.Transactional;

@SpringBootApplication
public class OptaWebEmployeeRosteringBenchmarkApplication
implements ApplicationRunner {
    @PersistenceContext
    private EntityManager entityManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static void main(String[] args) {
        SpringApplication.run(OptaWebEmployeeRosteringBenchmarkApplication.class, (String[])args);
    }

    @Transactional
    public void run(ApplicationArguments args) {
        List rosterList = this.generateRosters();
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"employeeRosteringBenchmarkConfig.xml", (ClassLoader)this.getClass().getClassLoader());
        PlannerBenchmark plannerBenchmark = benchmarkFactory.buildPlannerBenchmark(rosterList);
        plannerBenchmark.benchmark();
    }

    private List<Roster> generateRosters() {
        RosterGenerator rosterGenerator = new RosterGenerator(this.entityManager);
        ArrayList<Roster> rosterList = new ArrayList<Roster>();
        rosterList.add(rosterGenerator.generateRoster(10, 7));
        rosterList.add(rosterGenerator.generateRoster(80, 112));
        return rosterList;
    }
}

