/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering;

import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.annotations.QuarkusMain;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.service.admin.SystemPropertiesRetriever;
import org.optaweb.employeerostering.service.roster.RosterGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusMain
public class OptaWebEmployeeRosteringBenchmarkApplication
implements QuarkusApplication {
    @PersistenceContext
    EntityManager entityManager;
    @Inject
    UserTransaction userTransaction;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static void main(String[] args) {
        Quarkus.run(OptaWebEmployeeRosteringBenchmarkApplication.class, (String[])args);
    }

    public int run(String ... args) {
        List<Roster> rosterList = this.generateRosters();
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"employeeRosteringBenchmarkConfig.xml", (ClassLoader)this.getClass().getClassLoader());
        PlannerBenchmark plannerBenchmark = benchmarkFactory.buildPlannerBenchmark(rosterList);
        plannerBenchmark.benchmark();
        return 0;
    }

    private List<Roster> generateRosters() {
        try {
            this.userTransaction.begin();
            RosterGenerator rosterGenerator = new RosterGenerator(this.entityManager, new SystemPropertiesRetriever());
            ArrayList<Roster> rosterList = new ArrayList<Roster>();
            rosterList.add(rosterGenerator.generateRoster(10, 7));
            rosterList.add(rosterGenerator.generateRoster(80, 112));
            this.userTransaction.commit();
            return rosterList;
        }
        catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e) {
            throw new IllegalStateException("Failed to generate rosters.", e);
        }
    }
}

