/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.tenant;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.ZoneId;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.optaweb.employeerostering.domain.roster.view.RosterStateView;
import org.optaweb.employeerostering.domain.tenant.RosterParametrization;
import org.optaweb.employeerostering.domain.tenant.Tenant;
import org.optaweb.employeerostering.domain.tenant.view.RosterParametrizationView;
import org.optaweb.employeerostering.service.tenant.TenantService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/tenant"})
@CrossOrigin
@Validated
@Api(tags={"Tenant"})
public class TenantController {
    private final TenantService tenantService;

    public TenantController(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @ApiOperation(value="Get a list of all tenants")
    @GetMapping(value={"/"})
    public ResponseEntity<List<Tenant>> getTenantList() {
        return new ResponseEntity((Object)this.tenantService.getTenantList(), HttpStatus.OK);
    }

    @ApiOperation(value="Get a tenant by id")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<Tenant> getTenant(@PathVariable @Min(value=0L) @Min(value=0L) Integer id) {
        return new ResponseEntity((Object)this.tenantService.getTenant(id), HttpStatus.OK);
    }

    @ApiOperation(value="Add a new tenant")
    @PostMapping(value={"/add"})
    public ResponseEntity<Tenant> createTenant(@RequestBody @Valid RosterStateView initialRosterStateView) {
        return new ResponseEntity((Object)this.tenantService.createTenant(initialRosterStateView), HttpStatus.OK);
    }

    @ApiOperation(value="Delete a tenant")
    @PostMapping(value={"/remove/{id}"})
    public ResponseEntity<Boolean> deleteTenant(@PathVariable @Min(value=0L) @Min(value=0L) Integer id) {
        return new ResponseEntity((Object)this.tenantService.deleteTenant(id), HttpStatus.OK);
    }

    @ApiOperation(value="Get a tenant roster parametrization")
    @GetMapping(value={"/{tenantId}/parametrization"})
    public ResponseEntity<RosterParametrization> getRosterParametrization(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity((Object)this.tenantService.getRosterParametrization(tenantId), HttpStatus.OK);
    }

    @ApiOperation(value="Update a tenant roster parametrization")
    @PostMapping(value={"/parametrization/update"})
    public ResponseEntity<RosterParametrization> updateRosterParametrization(@RequestBody @Valid RosterParametrizationView rosterParametrizationView) {
        return new ResponseEntity((Object)this.tenantService.updateRosterParametrization(rosterParametrizationView), HttpStatus.OK);
    }

    @ApiOperation(value="Get supported timezones")
    @GetMapping(value={"/supported/timezones"})
    public ResponseEntity<List<ZoneId>> getSupportedTimezones() {
        return new ResponseEntity((Object)this.tenantService.getSupportedTimezones(), HttpStatus.OK);
    }
}

