/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.roster;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.optaweb.employeerostering.domain.employee.view.EmployeeAvailabilityView;
import org.optaweb.employeerostering.domain.roster.Pagination;
import org.optaweb.employeerostering.domain.roster.PublishResult;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.roster.view.AvailabilityRosterView;
import org.optaweb.employeerostering.domain.roster.view.ShiftRosterView;
import org.optaweb.employeerostering.domain.rotation.ShiftTemplate;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.tenant.RosterConstraintConfiguration;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.common.IndictmentUtils;
import org.optaweb.employeerostering.service.employee.EmployeeAvailabilityRepository;
import org.optaweb.employeerostering.service.employee.EmployeeRepository;
import org.optaweb.employeerostering.service.roster.RosterStateRepository;
import org.optaweb.employeerostering.service.rotation.ShiftTemplateRepository;
import org.optaweb.employeerostering.service.shift.ShiftRepository;
import org.optaweb.employeerostering.service.skill.SkillRepository;
import org.optaweb.employeerostering.service.solver.WannabeSolverManager;
import org.optaweb.employeerostering.service.spot.SpotRepository;
import org.optaweb.employeerostering.service.tenant.RosterConstraintConfigurationRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RosterService
extends AbstractRestService {
    private RosterStateRepository rosterStateRepository;
    private SkillRepository skillRepository;
    private SpotRepository spotRepository;
    private EmployeeRepository employeeRepository;
    private EmployeeAvailabilityRepository employeeAvailabilityRepository;
    private ShiftRepository shiftRepository;
    private RosterConstraintConfigurationRepository rosterConstraintConfigurationRepository;
    private ShiftTemplateRepository shiftTemplateRepository;
    private WannabeSolverManager solverManager;
    private IndictmentUtils indictmentUtils;

    public RosterService(RosterStateRepository rosterStateRepository, SkillRepository skillRepository, SpotRepository spotRepository, EmployeeRepository employeeRepository, EmployeeAvailabilityRepository employeeAvailabilityRepository, ShiftRepository shiftRepository, RosterConstraintConfigurationRepository rosterConstraintConfigurationRepository, ShiftTemplateRepository shiftTemplateRepository, WannabeSolverManager solverManager, IndictmentUtils indictmentUtils) {
        this.rosterStateRepository = rosterStateRepository;
        this.skillRepository = skillRepository;
        this.spotRepository = spotRepository;
        this.employeeRepository = employeeRepository;
        this.employeeAvailabilityRepository = employeeAvailabilityRepository;
        this.shiftRepository = shiftRepository;
        this.rosterConstraintConfigurationRepository = rosterConstraintConfigurationRepository;
        this.shiftTemplateRepository = shiftTemplateRepository;
        this.solverManager = solverManager;
        this.indictmentUtils = indictmentUtils;
    }

    @Transactional
    public RosterState getRosterState(Integer tenantId) {
        RosterState rosterState = (RosterState)this.rosterStateRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("No RosterState entity found with tenantId (" + tenantId + ")."));
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)rosterState);
        return rosterState;
    }

    @Transactional
    public ShiftRosterView getCurrentShiftRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate startDate = rosterState.getFirstPublishedDate();
        LocalDate endDate = rosterState.getFirstUnplannedDate();
        return this.getShiftRosterView(tenantId, startDate, endDate, Pagination.of((Integer)pageNumber, (Integer)numberOfItemsPerPage));
    }

    @Transactional
    public ShiftRosterView getShiftRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString) {
        return this.getShiftRosterView(tenantId, LocalDate.parse(startDateString), LocalDate.parse(endDateString), Pagination.of((Integer)pageNumber, (Integer)numberOfItemsPerPage));
    }

    private ShiftRosterView getShiftRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, Pagination pagination) {
        PageRequest spotPage = PageRequest.of((int)pagination.getPageNumber(), (int)pagination.getNumberOfItemsPerPage());
        List spots = this.spotRepository.findAllByTenantId(tenantId, (Pageable)spotPage);
        return this.getShiftRosterView(tenantId, startDate, endDate, spots);
    }

    @Transactional
    public ShiftRosterView getShiftRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Spot> spotList) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        if (spotList == null) {
            throw new IllegalArgumentException("The spotList (" + spotList + ") must not be null.");
        }
        return this.getShiftRosterView(tenantId, startDate, endDate, spotList);
    }

    private ShiftRosterView getShiftRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, List<Spot> spotList) {
        ShiftRosterView shiftRosterView = new ShiftRosterView(tenantId, startDate, endDate);
        shiftRosterView.setSpotList(spotList);
        List employeeList = this.employeeRepository.findAllByTenantId(tenantId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        shiftRosterView.setEmployeeList(employeeList);
        HashSet<Spot> spotSet = new HashSet<Spot>(spotList);
        ZoneId timeZone = this.getRosterState(tenantId).getTimeZone();
        List shiftList = this.shiftRepository.filterWithSpots(tenantId, spotSet, startDate.atStartOfDay(timeZone).toOffsetDateTime(), endDate.atStartOfDay(timeZone).toOffsetDateTime());
        LinkedHashMap<Long, List> spotIdToShiftViewListMap = new LinkedHashMap<Long, List>(spotList.size());
        Roster roster = this.solverManager.getRoster(tenantId);
        if (roster == null) {
            roster = this.buildRoster(tenantId);
        }
        Map indictmentMap = this.indictmentUtils.getIndictmentMapForRoster(roster);
        for (Shift shift : shiftList) {
            Indictment indictment = (Indictment)indictmentMap.get(shift);
            spotIdToShiftViewListMap.computeIfAbsent(shift.getSpot().getId(), k -> new ArrayList()).add(this.indictmentUtils.getShiftViewWithIndictment(timeZone, shift, indictment));
        }
        shiftRosterView.setSpotIdToShiftViewListMap(spotIdToShiftViewListMap);
        shiftRosterView.setScore(roster == null ? null : roster.getScore());
        shiftRosterView.setRosterState(this.getRosterState(tenantId));
        return shiftRosterView;
    }

    @Transactional
    public AvailabilityRosterView getCurrentAvailabilityRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate startDate = rosterState.getLastHistoricDate();
        LocalDate endDate = rosterState.getFirstUnplannedDate();
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, Pagination.of((Integer)pageNumber, (Integer)numberOfItemsPerPage));
    }

    @Transactional
    public AvailabilityRosterView getAvailabilityRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, Pagination.of((Integer)pageNumber, (Integer)numberOfItemsPerPage));
    }

    @Transactional
    public AvailabilityRosterView getAvailabilityRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Employee> employeeList) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        if (employeeList == null) {
            throw new IllegalArgumentException("The employeeList (" + employeeList + ") must not be null.");
        }
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, employeeList);
    }

    private AvailabilityRosterView getAvailabilityRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, Pagination pagination) {
        PageRequest employeePage = PageRequest.of((int)pagination.getPageNumber(), (int)pagination.getNumberOfItemsPerPage());
        List employeeList = this.employeeRepository.findAllByTenantId(tenantId, (Pageable)employeePage);
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, employeeList);
    }

    private AvailabilityRosterView getAvailabilityRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, List<Employee> employeeList) {
        AvailabilityRosterView availabilityRosterView = new AvailabilityRosterView(tenantId, startDate, endDate);
        List spotList = this.spotRepository.findAllByTenantId(tenantId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        availabilityRosterView.setSpotList(spotList);
        availabilityRosterView.setEmployeeList(employeeList);
        LinkedHashMap<Long, List> employeeIdToShiftViewListMap = new LinkedHashMap<Long, List>(employeeList.size());
        ArrayList<ShiftView> unassignedShiftViewList = new ArrayList<ShiftView>();
        HashSet<Employee> employeeSet = new HashSet<Employee>(employeeList);
        ZoneId timeZone = this.getRosterState(tenantId).getTimeZone();
        List shiftList = this.shiftRepository.filterWithEmployees(tenantId, employeeSet, startDate.atStartOfDay(timeZone).toOffsetDateTime(), endDate.atStartOfDay(timeZone).toOffsetDateTime());
        Roster roster = this.solverManager.getRoster(tenantId);
        if (roster == null) {
            roster = this.buildRoster(tenantId);
        }
        Map indictmentMap = this.indictmentUtils.getIndictmentMapForRoster(roster);
        for (Shift shift : shiftList) {
            Indictment indictment = (Indictment)indictmentMap.get(shift);
            if (shift.getEmployee() != null) {
                employeeIdToShiftViewListMap.computeIfAbsent(shift.getEmployee().getId(), k -> new ArrayList()).add(this.indictmentUtils.getShiftViewWithIndictment(timeZone, shift, indictment));
                continue;
            }
            unassignedShiftViewList.add(this.indictmentUtils.getShiftViewWithIndictment(timeZone, shift, indictment));
        }
        availabilityRosterView.setEmployeeIdToShiftViewListMap(employeeIdToShiftViewListMap);
        availabilityRosterView.setUnassignedShiftViewList(unassignedShiftViewList);
        LinkedHashMap<Long, List> employeeIdToAvailabilityViewListMap = new LinkedHashMap<Long, List>(employeeList.size());
        List employeeAvailabilityList = this.employeeAvailabilityRepository.filterWithEmployee(tenantId, employeeSet, startDate.atStartOfDay(timeZone).toOffsetDateTime(), endDate.atStartOfDay(timeZone).toOffsetDateTime());
        for (EmployeeAvailability employeeAvailability : employeeAvailabilityList) {
            employeeIdToAvailabilityViewListMap.computeIfAbsent(employeeAvailability.getEmployee().getId(), k -> new ArrayList()).add(new EmployeeAvailabilityView(timeZone, employeeAvailability));
        }
        availabilityRosterView.setEmployeeIdToAvailabilityViewListMap(employeeIdToAvailabilityViewListMap);
        availabilityRosterView.setScore(roster.getScore());
        availabilityRosterView.setRosterState(this.getRosterState(tenantId));
        return availabilityRosterView;
    }

    @Transactional
    public Roster buildRoster(Integer tenantId) {
        ZoneId zoneId = this.getRosterState(tenantId).getTimeZone();
        List skillList = this.skillRepository.findAllByTenantId(tenantId);
        List spotList = this.spotRepository.findAllByTenantId(tenantId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        List employeeList = this.employeeRepository.findAllByTenantId(tenantId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        List employeeAvailabilityList = this.employeeAvailabilityRepository.findAllByTenantId(tenantId).stream().map(ea -> ea.inTimeZone(zoneId)).collect(Collectors.toList());
        List shiftList = this.shiftRepository.findAllByTenantId(tenantId).stream().map(s -> s.inTimeZone(zoneId)).collect(Collectors.toList());
        Roster roster = new Roster(Long.valueOf(tenantId.intValue()), tenantId, (RosterConstraintConfiguration)this.rosterConstraintConfigurationRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("No RosterConstraintConfiguration entity found with tenantId(" + tenantId + ").")), skillList, spotList, employeeList, employeeAvailabilityList, this.getRosterState(tenantId), shiftList);
        ScoreDirector scoreDirector = this.solverManager.getScoreDirector();
        scoreDirector.setWorkingSolution((Object)roster);
        roster.setScore((HardMediumSoftLongScore)scoreDirector.calculateScore());
        return roster;
    }

    @Transactional
    public void updateShiftsOfRoster(Roster newRoster) {
        Integer tenantId = newRoster.getTenantId();
        Map employeeIdMap = this.employeeRepository.findAllByTenantId(tenantId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        Map shiftIdMap = this.shiftRepository.findAllByTenantId(tenantId).stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (Shift shift : newRoster.getShiftList()) {
            Shift attachedShift = (Shift)shiftIdMap.get(shift.getId());
            if (attachedShift == null) continue;
            attachedShift.setEmployee(shift.getEmployee() == null ? null : (Employee)employeeIdMap.get(shift.getEmployee().getId()));
        }
    }

    public void solveRoster(Integer tenantId) {
        this.solverManager.solve(tenantId);
    }

    public void terminateRosterEarly(Integer tenantId) {
        this.solverManager.terminate(tenantId);
    }

    @Transactional
    public PublishResult publishAndProvision(Integer tenantId) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate publishFrom = rosterState.getFirstDraftDate();
        LocalDate publishTo = publishFrom.plusDays(rosterState.getPublishLength().intValue());
        LocalDate firstUnplannedDate = rosterState.getFirstUnplannedDate();
        rosterState.setFirstDraftDate(publishTo);
        List shiftTemplateList = this.shiftTemplateRepository.findAllByTenantId(tenantId);
        Map<Integer, List<ShiftTemplate>> dayOffsetToShiftTemplateListMap = shiftTemplateList.stream().collect(Collectors.groupingBy(ShiftTemplate::getStartDayOffset));
        int dayOffset = rosterState.getUnplannedRotationOffset();
        LocalDate shiftDate = firstUnplannedDate;
        for (int i = 0; i < rosterState.getPublishLength(); ++i) {
            List dayShiftTemplateList = dayOffsetToShiftTemplateListMap.getOrDefault(dayOffset, Collections.emptyList());
            for (ShiftTemplate shiftTemplate : dayShiftTemplateList) {
                Shift shift = shiftTemplate.createShiftOnDate(shiftDate, rosterState.getRotationLength().intValue(), rosterState.getTimeZone(), false);
                this.shiftRepository.save((Object)shift);
            }
            shiftDate = shiftDate.plusDays(1L);
            dayOffset = (dayOffset + 1) % rosterState.getRotationLength();
        }
        rosterState.setUnplannedRotationOffset(Integer.valueOf(dayOffset));
        return new PublishResult(publishFrom, publishTo);
    }
}

