/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.common.generator;

import java.util.ArrayList;
import java.util.List;

public class StringDataGenerator {
    private static final int[][] HALF_SEQUENCE_MAP = new int[][]{new int[0], {0}, {0, 1}, {0, 2, 1}, {0, 2, 1, 3}};
    private static final int[] DEFAULT_ELIMINATION_INDEX_MAP = new int[]{0, 1, 1, 1};
    private final boolean capitalizeFirstLetter;
    private final String delimiter;
    private List<String[]> partValuesList = new ArrayList();
    private int partValuesLength;
    private List<Integer> eliminationIndexMap = new ArrayList();
    private int requiredSize = 0;
    private List<String[]> filteredPartValuesList = this.partValuesList;
    private int index = 0;
    private int indexLimit;

    public static StringDataGenerator buildFullNames() {
        return new StringDataGenerator().addPart(true, 0, new String[]{"Amy", "Beth", "Chad", "Dan", "Elsa", "Flo", "Gus", "Hugo", "Ivy", "Jay"}).addPart(false, 1, new String[]{"A.", "B.", "C.", "D.", "E.", "F.", "G.", "H.", "I.", "J."}).addPart(false, 1, new String[]{"O.", "P.", "Q.", "R.", "S.", "T.", "U.", "V.", "W.", "X."}).addPart(false, 1, new String[]{"Cole", "Fox", "Green", "Jones", "King", "Li", "Poe", "Rye", "Smith", "Watt"});
    }

    public static StringDataGenerator buildCompanyNames() {
        return new StringDataGenerator().addPart(true, 0, new String[]{"Steel", "Paper", "Stone", "Wood", "Water", "Food", "Oil", "Car", "Power", "Computer"}).addPart(true, 1, new String[]{"Inc", "Corp", "Limited", "Express", "Telco", "Mobile", "Soft", "Mart", "Bank", "Labs"}).addPart(false, 2, new String[]{"US", "UK", "JP", "DE", "FR", "BE", "NL", "BR", "IN", "ES"});
    }

    public static StringDataGenerator buildLocationNames() {
        return new StringDataGenerator().addPart(true, 0, new String[]{"Los", "San", "Las", "Santa", "New", "Fort", "Mount", "Saint", "Little", "El"}).addPart(true, 1, new String[]{"Angeles", "Francisco", "Vegas", "Barbara", "York", "Collins", "Vernon", "Peter", "Rock", "Paso"}).addPart(false, 2, new String[]{"Town", "City", "Falls", "Ville", "Field", "Polis", "Shire", "Berg", "Borough", "Island"}).addPart(false, 3, new String[]{"AL", "CA", "DE", "FL", "GA", "HI", "IN", "KS", "LA", "ME"});
    }

    public static StringDataGenerator buildAssemblyLineNames() {
        return new StringDataGenerator().addPart(new String[]{"Chassis", "Engine", "Battery", "Radiator", "Tires", "Lights", "Doors", "Bumper", "Windows", "Sunroof", "Spoiler", "Seats", "Radio", "Airbag", "GPS"}).addPart(new String[]{"Factory A", "Factory B", "Factory C", "Factory D", "Factory E", "Factory F", "Factory G", "Factory H", "Factory I", "Factory J", "Factory K", "Factory L", "Factory M", "Factory N", "Factory O"}).addPart(new String[]{"line 1", "line 2", "line 3", "line 4", "line 5", "line 6", "line 7", "line 8", "line 9", "line 10", "line 11", "line 12", "line 13", "line 14", "line 15"});
    }

    public StringDataGenerator() {
        this(false);
    }

    public StringDataGenerator(boolean capitalizeFirstLetter) {
        this(capitalizeFirstLetter, " ");
    }

    public StringDataGenerator(String delimiter) {
        this(false, delimiter);
    }

    public StringDataGenerator(boolean capitalizeFirstLetter, String delimiter) {
        this.capitalizeFirstLetter = capitalizeFirstLetter;
        this.delimiter = delimiter;
    }

    public StringDataGenerator addPart(String ... partValues) {
        return this.addPart(false, DEFAULT_ELIMINATION_INDEX_MAP[this.partValuesList.size()], partValues);
    }

    public StringDataGenerator addAToZPart() {
        return this.addAToZPart(false, DEFAULT_ELIMINATION_INDEX_MAP[this.partValuesList.size()]);
    }

    public StringDataGenerator addAToZPart(boolean required, int eliminationIndex) {
        return this.addPart(required, eliminationIndex, new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"});
    }

    public StringDataGenerator addNumericPart(boolean required, int eliminationIndex, int from, int to) {
        String[] partValues = new String[to - from];
        for (int i = from; i < to; ++i) {
            partValues[i - from] = Integer.toString(i);
        }
        return this.addPart(required, eliminationIndex, partValues);
    }

    public StringDataGenerator addPart(boolean required, int eliminationIndex, String ... partValues) {
        if (this.partValuesList.isEmpty()) {
            this.partValuesLength = partValues.length;
        } else if (partValues.length != this.partValuesLength) {
            throw new IllegalStateException("The partValues length (" + partValues.length + ") is not the same as the partValuesLength (" + this.partValuesLength + ") of the others.");
        }
        if (required) {
            ++this.requiredSize;
        }
        this.partValuesList.add(partValues);
        this.eliminationIndexMap.add(eliminationIndex);
        this.indexLimit = (int)Math.pow(this.partValuesLength, this.partValuesList.size());
        this.filteredPartValuesList = this.partValuesList;
        return this;
    }

    public void reset() {
        this.filteredPartValuesList = this.partValuesList;
        this.index = 0;
    }

    public void predictMaximumSizeAndReset(int maximumSize) {
        this.indexLimit = (int)Math.pow(this.partValuesLength, this.partValuesList.size());
        this.filteredPartValuesList = this.partValuesList;
        for (int i = 1; i < this.partValuesList.size(); ++i) {
            int proposedIndexLimit = (int)Math.pow(this.partValuesLength, i);
            if (maximumSize > proposedIndexLimit) continue;
            this.filteredPartValuesList = new ArrayList(this.partValuesList);
            while (i < this.filteredPartValuesList.size() && this.filteredPartValuesList.size() > this.requiredSize) {
                int eliminationIndex = (Integer)this.eliminationIndexMap.get(this.filteredPartValuesList.size() - 1);
                this.filteredPartValuesList.remove(eliminationIndex);
            }
            this.indexLimit = proposedIndexLimit;
            break;
        }
        this.index = 0;
    }

    public String generateNextValue() {
        int i;
        if (this.index >= this.indexLimit) {
            throw new IllegalStateException("No more elements: the index (" + this.index + ") is higher than the indexLimit (" + this.indexLimit + ").\nMaybe predictMaximumSizeAndReset() was called with a too low maximumSize.");
        }
        int listSize = this.filteredPartValuesList.size();
        StringBuilder result = new StringBuilder(listSize * 80);
        if (listSize >= HALF_SEQUENCE_MAP.length) {
            throw new IllegalStateException("A listSize (" + listSize + ") is not yet supported.");
        }
        int[] halfSequence = HALF_SEQUENCE_MAP[listSize];
        int[] chosens = new int[listSize];
        int previousChosen = 0;
        for (i = 0; i < listSize; ++i) {
            int chosen;
            chosens[i] = chosen = (previousChosen + this.index % (int)Math.pow(this.partValuesLength, (double)halfSequence[i] + 1.0) / (int)Math.pow(this.partValuesLength, halfSequence[i])) % this.partValuesLength;
            previousChosen = chosen;
        }
        for (i = 0; i < listSize; ++i) {
            if (i > 0) {
                result.append(this.delimiter);
            }
            String[] partValues = (String[])this.filteredPartValuesList.get(i);
            result.append(partValues[chosens[i]]);
        }
        ++this.index;
        if (this.capitalizeFirstLetter) {
            result.setCharAt(0, Character.toUpperCase(result.charAt(0)));
        }
        return result.toString();
    }
}

