/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.contract;

import java.util.List;
import java.util.Optional;
import javax.persistence.EntityNotFoundException;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.contract.view.ContractView;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.contract.ContractRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractService
extends AbstractRestService {
    private final ContractRepository contractRepository;

    public ContractService(ContractRepository contractRepository) {
        this.contractRepository = contractRepository;
    }

    public Contract convertFromView(Integer tenantId, ContractView contractView) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)contractView);
        Contract contract = new Contract(tenantId, contractView.getName(), contractView.getMaximumMinutesPerDay(), contractView.getMaximumMinutesPerWeek(), contractView.getMaximumMinutesPerMonth(), contractView.getMaximumMinutesPerYear());
        contract.setId(contractView.getId());
        contract.setVersion(contractView.getVersion());
        return contract;
    }

    @Transactional
    public List<Contract> getContractList(Integer tenantId) {
        return this.contractRepository.findAllByTenantId(tenantId);
    }

    @Transactional
    public Contract getContract(Integer tenantId, Long id) {
        Contract contract = (Contract)this.contractRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("No Contract entity found with ID (" + id + ")."));
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)contract);
        return contract;
    }

    @Transactional
    public Boolean deleteContract(Integer tenantId, Long id) {
        Optional contractOptional = this.contractRepository.findById((Object)id);
        if (!contractOptional.isPresent()) {
            return false;
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)contractOptional.get());
        this.contractRepository.deleteById((Object)id);
        return true;
    }

    @Transactional
    public Contract createContract(Integer tenantId, ContractView contractView) {
        Contract contract = this.convertFromView(tenantId, contractView);
        return (Contract)this.contractRepository.save((Object)contract);
    }

    @Transactional
    public Contract updateContract(Integer tenantId, ContractView contractView) {
        Contract newContract = this.convertFromView(tenantId, contractView);
        Contract oldContract = (Contract)this.contractRepository.findById((Object)newContract.getId()).orElseThrow(() -> new EntityNotFoundException("Contract entity with ID (" + newContract.getId() + ") not found."));
        if (!oldContract.getTenantId().equals(newContract.getTenantId())) {
            throw new IllegalStateException("Contract entity with tenantId (" + oldContract.getTenantId() + ") cannot change tenants.");
        }
        oldContract.setName(newContract.getName());
        oldContract.setMaximumMinutesPerDay(newContract.getMaximumMinutesPerDay());
        oldContract.setMaximumMinutesPerWeek(newContract.getMaximumMinutesPerWeek());
        oldContract.setMaximumMinutesPerMonth(newContract.getMaximumMinutesPerMonth());
        oldContract.setMaximumMinutesPerYear(newContract.getMaximumMinutesPerYear());
        return (Contract)this.contractRepository.save((Object)oldContract);
    }

    @Transactional
    public Contract getOrCreateDefaultContract(Integer tenantId) {
        Optional<Contract> defaultContract = this.contractRepository.findAllByTenantId(tenantId).stream().filter(contract -> contract.getName().equals("Default Contract")).findAny();
        if (defaultContract.isPresent()) {
            return defaultContract.get();
        }
        Contract contract2 = new Contract();
        contract2.setName("Default Contract");
        contract2.setTenantId(tenantId);
        return (Contract)this.contractRepository.save((Object)contract2);
    }
}

