/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.employee;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Set;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EmployeeAvailabilityRepository
extends JpaRepository<EmployeeAvailability, Long> {
    @Query(value="select distinct ea from EmployeeAvailability ea left join fetch ea.employee e where ea.tenantId = :tenantId order by e.name, ea.startDateTime")
    public List<EmployeeAvailability> findAllByTenantId(@Param(value="tenantId") Integer var1);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="delete from EmployeeAvailability ea where ea.tenantId = :tenantId")
    public void deleteForTenant(@Param(value="tenantId") Integer var1);

    @Query(value="select distinct ea from EmployeeAvailability ea left join fetch ea.employee e where ea.tenantId = :tenantId and ea.employee IN :employeeSet and ea.endDateTime >= :startDateTime and ea.startDateTime < :endDateTime order by e.name, ea.startDateTime")
    public List<EmployeeAvailability> filterWithEmployee(@Param(value="tenantId") Integer var1, @Param(value="employeeSet") Set<Employee> var2, @Param(value="startDateTime") OffsetDateTime var3, @Param(value="endDateTime") OffsetDateTime var4);
}

