/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.roster;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailabilityState;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.rotation.ShiftTemplate;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.tenant.RosterConstraintConfiguration;
import org.optaweb.employeerostering.domain.tenant.Tenant;
import org.optaweb.employeerostering.service.admin.SystemPropertiesRetriever;
import org.optaweb.employeerostering.service.common.generator.StringDataGenerator;
import org.optaweb.employeerostering.service.roster.RosterGenerator;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RosterGenerator
implements ApplicationRunner {
    private static final double[] EXTRA_SHIFT_THRESHOLDS = new double[]{0.5, 0.8, 0.95};
    private final StringDataGenerator tenantNameGenerator = StringDataGenerator.buildLocationNames();
    private final StringDataGenerator employeeNameGenerator = StringDataGenerator.buildFullNames();
    private final List<DayOfWeek> ALL_WEEK = Arrays.asList(DayOfWeek.values());
    private final List<DayOfWeek> WEEKDAYS = Arrays.asList(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    private final List<DayOfWeek> WEEKENDS = Arrays.asList(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    private final GeneratorType hospitalGeneratorType = new GeneratorType("Hospital", new StringDataGenerator().addPart(new String[]{"Ambulatory care", "Critical care", "Midwife", "Gastroenterology", "Neuroscience", "Oncology", "Pediatric", "Psychiatric", "Geriatric", "Radiology"}).addPart(new String[]{"nurse", "physician", "doctor", "attendant", "specialist", "surgeon", "medic", "practitioner", "pharmacist", "researcher"}), new StringDataGenerator(true).addPart(false, 0, new String[]{"Basic", "Advanced", "Expert", "Specialized", "Elder", "Child", "Infant", "Baby", "Male", "Female", "Common", "Uncommon", "Research", "Administrative", "Regressing"}).addPart(true, 1, new String[]{"anaesthetics", "cardiology", "critical care", "emergency", "ear nose throat", "gastroenterology", "haematology", "maternity", "neurology", "oncology", "ophthalmology", "orthopaedics", "physiotherapy", "radiotherapy", "urology"}).addPart(false, 0, new String[]{"Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron"}), Arrays.asList(Triple.of((Object)LocalTime.of(6, 0), (Object)LocalTime.of(14, 0), (Object)this.ALL_WEEK), Triple.of((Object)LocalTime.of(9, 0), (Object)LocalTime.of(17, 0), (Object)this.ALL_WEEK), Triple.of((Object)LocalTime.of(14, 0), (Object)LocalTime.of(22, 0), (Object)this.ALL_WEEK), Triple.of((Object)LocalTime.of(22, 0), (Object)LocalTime.of(6, 0), (Object)this.ALL_WEEK)), 21, 6, (startDayOffset, timeslotRangesIndex) -> {
        switch (timeslotRangesIndex) {
            case 0: {
                return startDayOffset % 7 >= 5 ? 3 : startDayOffset / 7;
            }
            case 1: {
                return (startDayOffset + 2) % 7 < 4 ? 5 : (startDayOffset - 16 + 21) % 21 / 7;
            }
            case 2: {
                return startDayOffset % 7 < 3 ? 3 : 4;
            }
            case 3: {
                return startDayOffset % 7 < 1 ? 4 : (startDayOffset - 8 + 21) % 21 / 7;
            }
        }
        throw new IllegalStateException("Impossible state for timeslotRangesIndex (" + timeslotRangesIndex + ").");
    });
    private final GeneratorType factoryAssemblyGeneratorType = new GeneratorType("Factory assembly", new StringDataGenerator().addPart(new String[]{"Mechanical", "Electrical", "Safety", "Transportation", "Operational", "Physics", "Monitoring", "ICT"}).addPart(new String[]{"bachelor", "engineer", "instructor", "coordinator", "manager", "expert", "inspector", "analyst"}), StringDataGenerator.buildAssemblyLineNames(), Arrays.asList(Triple.of((Object)LocalTime.of(6, 0), (Object)LocalTime.of(14, 0), (Object)this.ALL_WEEK), Triple.of((Object)LocalTime.of(14, 0), (Object)LocalTime.of(22, 0), (Object)this.ALL_WEEK), Triple.of((Object)LocalTime.of(22, 0), (Object)LocalTime.of(6, 0), (Object)this.ALL_WEEK)), 28, 4, (startDayOffset, timeslotRangesIndex) -> (startDayOffset - 9 * timeslotRangesIndex + 28) % 28 / 7);
    private final GeneratorType guardSecurityGeneratorType = new GeneratorType("Guard security", new StringDataGenerator().addPart(new String[]{"Martial art", "Armed", "Surveillance", "Technical", "Computer"}).addPart(new String[]{"basic", "advanced", "expert", "master", "novice"}), new StringDataGenerator().addPart(new String[]{"Airport", "Harbor", "Bank", "Office", "Warehouse", "Store", "Factory", "Station", "Museum", "Mansion", "Monument", "City hall", "Prison", "Mine", "Palace"}).addPart(new String[]{"north gate", "south gate", "east gate", "west gate", "roof", "cellar", "north west gate", "north east gate", "south west gate", "south east gate", "main door", "back door", "side door", "balcony", "patio"}).addPart(new String[]{"Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron"}), Arrays.asList(Triple.of((Object)LocalTime.of(7, 0), (Object)LocalTime.of(19, 0), (Object)this.ALL_WEEK), Triple.of((Object)LocalTime.of(19, 0), (Object)LocalTime.of(7, 0), (Object)this.ALL_WEEK)), 21, 3, (startDayOffset, timeslotRangesIndex) -> {
        int offset;
        int n = offset = timeslotRangesIndex == 0 ? startDayOffset : (startDayOffset + 7) % 21;
        return offset < 3 ? 0 : (offset < 7 ? 1 : (offset < 10 ? 2 : (offset < 14 ? 0 : (offset < 17 ? 1 : (offset < 21 ? 2 : -1)))));
    });
    private final GeneratorType callCenterGeneratorType = new GeneratorType("Call center", new StringDataGenerator().addPart(new String[]{"English", "Spanish", "French", "German", "Japanese", "Chinese", "Dutch", "Portuguese", "Italian"}), new StringDataGenerator().addPart(new String[]{"Business loans", "Checking and savings accounts", "Debit and credit cards", "Insurances", "Merchant services", "Cash management", "Tax management", "Wealth management", "Mortgages", "Personal loans", "Online payment"}), Arrays.asList(Triple.of((Object)LocalTime.of(7, 0), (Object)LocalTime.of(16, 0), (Object)this.ALL_WEEK), Triple.of((Object)LocalTime.of(11, 0), (Object)LocalTime.of(20, 0), (Object)this.ALL_WEEK)), 7, 3, (startDayOffset, timeslotRangesIndex) -> timeslotRangesIndex == 0 ? (startDayOffset < 1 ? 1 : (startDayOffset < 6 ? 0 : (startDayOffset < 7 ? 1 : -1))) : (startDayOffset < 2 ? 2 : (startDayOffset < 4 ? 1 : (startDayOffset < 7 ? 2 : -1))));
    private final GeneratorType postOfficeGeneratorType = new GeneratorType("Post office", new StringDataGenerator().addPart(new String[]{"Truck license", "Bicycle license", "Computer certification", "Administration", "Transportation", "Monitoring", "Logistics", "Coordination", "Customer service"}), new StringDataGenerator().addPart(true, 1, new String[]{"North", "South", "East", "West", "North West", "North East", "South West", "South East", "Central"}).addPart(true, 1, new String[]{"Uptown", "Harbor", "Lakeshore", "Point", "Valley", "Port", "Heights", "Beach", "Downtown"}), Arrays.asList(Triple.of((Object)LocalTime.of(9, 0), (Object)LocalTime.of(17, 0), (Object)this.WEEKDAYS), Triple.of((Object)LocalTime.of(9, 0), (Object)LocalTime.of(15, 0), Arrays.asList(DayOfWeek.SATURDAY))), 7, 3, (startDayOffset, timeslotRangesIndex) -> timeslotRangesIndex == 0 ? (startDayOffset < 1 ? 1 : (startDayOffset < 6 ? 0 : (startDayOffset < 7 ? 1 : -1))) : (startDayOffset < 2 ? 2 : (startDayOffset < 4 ? 1 : (startDayOffset < 7 ? 2 : -1))));
    private Random random;
    @PersistenceContext
    private EntityManager entityManager;

    public RosterGenerator() {
    }

    public RosterGenerator(EntityManager entityManager) {
        this.entityManager = entityManager;
        this.random = new Random(37L);
    }

    @Transactional
    public void run(ApplicationArguments args) {
        this.checkForExistingData();
    }

    @Transactional
    public void checkForExistingData() {
        List tenantList = this.entityManager.createQuery("select t from Tenant t").getResultList();
        if (!tenantList.isEmpty()) {
            return;
        }
        this.setUpGeneratedData();
    }

    @Transactional
    public void setUpGeneratedData() {
        ZoneId zoneId = SystemPropertiesRetriever.determineZoneId();
        SystemPropertiesRetriever.InitialData initialData = SystemPropertiesRetriever.determineInitialData();
        this.random = new Random(37L);
        switch (1.$SwitchMap$org$optaweb$employeerostering$service$admin$SystemPropertiesRetriever$InitialData[initialData.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                this.tenantNameGenerator.predictMaximumSizeAndReset(12);
                this.generateRoster(10, 7, this.hospitalGeneratorType, zoneId);
                this.generateRoster(10, 7, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(10, 7, this.guardSecurityGeneratorType, zoneId);
                this.generateRoster(10, 7, this.callCenterGeneratorType, zoneId);
                this.generateRoster(10, 7, this.postOfficeGeneratorType, zoneId);
                this.generateRoster(10, 28, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(20, 28, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(40, 14, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(80, 28, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(10, 28, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(20, 28, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(40, 14, this.factoryAssemblyGeneratorType, zoneId);
                this.generateRoster(80, 28, this.factoryAssemblyGeneratorType, zoneId);
            }
        }
    }

    @Transactional
    public Roster generateRoster(int spotListSize, int lengthInDays, GeneratorType generatorType, ZoneId zoneId) {
        int maxShiftSizePerDay = generatorType.timeslotRangeList.size() + EXTRA_SHIFT_THRESHOLDS.length;
        int employeeListSize = spotListSize * maxShiftSizePerDay * 7 / 5;
        int skillListSize = (spotListSize + 4) / 5;
        Tenant tenant = this.createTenant(generatorType, employeeListSize);
        Integer tenantId = tenant.getId();
        RosterConstraintConfiguration rosterConstraintConfiguration = this.createTenantConfiguration(generatorType, tenantId, zoneId);
        RosterState rosterState = this.createRosterState(generatorType, tenant, zoneId, lengthInDays);
        List skillList = this.createSkillList(generatorType, tenantId, skillListSize);
        List spotList = this.createSpotList(generatorType, tenantId, spotListSize, skillList);
        List contractList = this.createContractList(tenantId);
        List employeeList = this.createEmployeeList(generatorType, tenantId, employeeListSize, contractList, skillList);
        List shiftTemplateList = this.createShiftTemplateList(generatorType, tenantId, rosterState, spotList, employeeList, skillList);
        List shiftList = this.createShiftList(generatorType, tenantId, rosterConstraintConfiguration, rosterState, spotList, shiftTemplateList);
        List employeeAvailabilityList = this.createEmployeeAvailabilityList(generatorType, tenantId, rosterConstraintConfiguration, rosterState, employeeList, shiftList);
        return new Roster(Long.valueOf(tenantId.intValue()), tenantId, rosterConstraintConfiguration, skillList, spotList, employeeList, employeeAvailabilityList, rosterState, shiftList);
    }

    @Transactional
    public Roster generateRoster(int spotListSize, int lengthInDays) {
        ZoneId zoneId = SystemPropertiesRetriever.determineZoneId();
        return this.generateRoster(spotListSize, lengthInDays, this.hospitalGeneratorType, zoneId);
    }

    @Transactional
    public Tenant createTenant(GeneratorType generatorType, int employeeListSize) {
        String tenantName = generatorType.tenantNamePrefix + " " + this.tenantNameGenerator.generateNextValue() + " (" + employeeListSize + " employees)";
        Tenant tenant = new Tenant(tenantName);
        this.entityManager.persist((Object)tenant);
        return tenant;
    }

    @Transactional
    public RosterConstraintConfiguration createTenantConfiguration(GeneratorType generatorType, Integer tenantId, ZoneId zoneId) {
        RosterConstraintConfiguration rosterConstraintConfiguration = new RosterConstraintConfiguration();
        rosterConstraintConfiguration.setTenantId(tenantId);
        this.entityManager.persist((Object)rosterConstraintConfiguration);
        return rosterConstraintConfiguration;
    }

    @Transactional
    public RosterState createRosterState(GeneratorType generatorType, Tenant tenant, ZoneId zoneId, int lengthInDays) {
        RosterState rosterState = new RosterState();
        rosterState.setTenantId(tenant.getId());
        int publishNotice = 14;
        rosterState.setPublishNotice(Integer.valueOf(publishNotice));
        LocalDate firstDraftDate = LocalDate.now().with(TemporalAdjusters.next(DayOfWeek.MONDAY)).plusDays(publishNotice);
        rosterState.setFirstDraftDate(firstDraftDate);
        rosterState.setDraftLength(Integer.valueOf(14));
        rosterState.setUnplannedRotationOffset(Integer.valueOf(0));
        rosterState.setRotationLength(Integer.valueOf(generatorType.rotationLength));
        rosterState.setLastHistoricDate(LocalDate.now().minusDays(1L));
        rosterState.setTimeZone(zoneId);
        rosterState.setTenant(tenant);
        this.entityManager.persist((Object)rosterState);
        return rosterState;
    }

    @Transactional
    public List<Skill> createSkillList(GeneratorType generatorType, Integer tenantId, int size) {
        ArrayList<Skill> skillList = new ArrayList<Skill>(size + 3);
        generatorType.skillNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = generatorType.skillNameGenerator.generateNextValue();
            Skill skill = new Skill(tenantId, name);
            this.entityManager.persist((Object)skill);
            skillList.add(skill);
        }
        return skillList;
    }

    @Transactional
    public List<Spot> createSpotList(GeneratorType generatorType, Integer tenantId, int size, List<Skill> skillList) {
        ArrayList<Spot> spotList = new ArrayList<Spot>(size);
        generatorType.spotNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = generatorType.spotNameGenerator.generateNextValue();
            HashSet requiredSkillSet = new HashSet(this.extractRandomSubList(skillList, new double[]{0.5, 0.9, 1.0}));
            Spot spot = new Spot(tenantId, name, requiredSkillSet);
            this.entityManager.persist((Object)spot);
            spotList.add(spot);
        }
        return spotList;
    }

    @Transactional
    public List<Contract> createContractList(Integer tenantId) {
        ArrayList<Contract> contractList = new ArrayList<Contract>(3);
        Contract contract = new Contract(tenantId, "Part Time Contract");
        this.entityManager.persist((Object)contract);
        contractList.add(contract);
        contract = new Contract(tenantId, "Max 16 Hours Per Week Contract", null, Integer.valueOf(960), null, null);
        this.entityManager.persist((Object)contract);
        contractList.add(contract);
        contract = new Contract(tenantId, "Max 16 Hours Per Week, 32 Hours Per Month Contract", null, Integer.valueOf(960), Integer.valueOf(1920), null);
        this.entityManager.persist((Object)contract);
        contractList.add(contract);
        return contractList;
    }

    @Transactional
    public List<Employee> createEmployeeList(GeneratorType generatorType, Integer tenantId, int size, List<Contract> contractList, List<Skill> generalSkillList) {
        ArrayList<Employee> employeeList = new ArrayList<Employee>(size);
        this.employeeNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = this.employeeNameGenerator.generateNextValue();
            HashSet skillProficiencySet = new HashSet(this.extractRandomSubList(generalSkillList, new double[]{0.1, 0.3, 0.5, 0.7, 0.9, 1.0}));
            Employee employee = new Employee(tenantId, name, contractList.get(this.generateRandomIntFromThresholds(new double[]{0.7, 0.5})), skillProficiencySet);
            this.entityManager.persist((Object)employee);
            employeeList.add(employee);
        }
        return employeeList;
    }

    @Transactional
    public List<ShiftTemplate> createShiftTemplateList(GeneratorType generatorType, Integer tenantId, RosterState rosterState, List<Spot> spotList, List<Employee> employeeList, List<Skill> skillList) {
        int rotationLength = rosterState.getRotationLength();
        ArrayList<ShiftTemplate> shiftTemplateList = new ArrayList<ShiftTemplate>(spotList.size() * rotationLength * generatorType.timeslotRangeList.size());
        ArrayList<Employee> remainingEmployeeList = new ArrayList<Employee>(employeeList);
        Consumer<Spot> createShiftTemplatesForWard = spot -> {
            Function<Predicate, List> findEmployees = p -> {
                List out = remainingEmployeeList.stream().filter(employee -> employee.getSkillProficiencySet().containsAll(spot.getRequiredSkillSet()) && employee.getContract().getMaximumMinutesPerWeek() == null && p.test(employee)).limit(generatorType.rotationEmployeeListSize).collect(Collectors.toList());
                remainingEmployeeList.removeAll(out);
                return out;
            };
            List rotationEmployeeList = findEmployees.apply(t -> true);
            for (int startDayOffset = 0; startDayOffset < rotationLength; ++startDayOffset) {
                for (int timeslotRangesIndex = 0; timeslotRangesIndex < generatorType.timeslotRangeList.size(); ++timeslotRangesIndex) {
                    int rotationEmployeeIndex;
                    Triple timeslotRange = (Triple)generatorType.timeslotRangeList.get(timeslotRangesIndex);
                    int dayOfWeek = startDayOffset % 7 + 1;
                    if (!((List)timeslotRange.getRight()).stream().anyMatch(d -> d.getValue() == dayOfWeek)) continue;
                    LocalTime startTime = (LocalTime)timeslotRange.getLeft();
                    LocalTime endTime = (LocalTime)timeslotRange.getMiddle();
                    int endDayOffset = startDayOffset;
                    if (endTime.compareTo(startTime) < 0) {
                        endDayOffset = (startDayOffset + 1) % rotationLength;
                    }
                    if ((rotationEmployeeIndex = ((Integer)generatorType.rotationEmployeeIndexCalculator.apply(startDayOffset, timeslotRangesIndex)).intValue()) < 0 || rotationEmployeeIndex >= generatorType.rotationEmployeeListSize) {
                        throw new IllegalStateException("The rotationEmployeeIndexCalculator for generatorType (" + generatorType.tenantNamePrefix + ") returns an invalid rotationEmployeeIndex (" + rotationEmployeeIndex + ") for startDayOffset (" + startDayOffset + ") and timeslotRangesIndex (" + timeslotRangesIndex + ").");
                    }
                    Employee rotationEmployee = rotationEmployeeIndex >= rotationEmployeeList.size() ? null : (Employee)rotationEmployeeList.get(rotationEmployeeIndex);
                    ShiftTemplate shiftTemplate = new ShiftTemplate(tenantId, spot, startDayOffset, startTime, endDayOffset, endTime, rotationEmployee);
                    this.entityManager.persist((Object)shiftTemplate);
                    shiftTemplateList.add(shiftTemplate);
                }
            }
        };
        spotList.stream().forEach(createShiftTemplatesForWard);
        return shiftTemplateList;
    }

    @Transactional
    public List<Shift> createShiftList(GeneratorType generatorType, Integer tenantId, RosterConstraintConfiguration rosterConstraintConfiguration, RosterState rosterState, List<Spot> spotList, List<ShiftTemplate> shiftTemplateList) {
        ZoneId zoneId = rosterState.getTimeZone();
        int rotationLength = rosterState.getRotationLength();
        LocalDate date = rosterState.getLastHistoricDate().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate firstDraftDate = rosterState.getFirstDraftDate();
        LocalDate firstUnplannedDate = rosterState.getFirstUnplannedDate();
        ArrayList<Shift> shiftList = new ArrayList<Shift>();
        Map<Pair, List<ShiftTemplate>> dayOffsetAndSpotToShiftTemplateListMap = shiftTemplateList.stream().collect(Collectors.groupingBy(shiftTemplate -> Pair.of((Object)shiftTemplate.getStartDayOffset(), (Object)shiftTemplate.getSpot())));
        int dayOffset = 0;
        while (date.compareTo(firstUnplannedDate) < 0) {
            for (Spot spot : spotList) {
                Shift shift;
                List subShiftTemplateList = dayOffsetAndSpotToShiftTemplateListMap.getOrDefault(Pair.of((Object)dayOffset, (Object)spot), Collections.emptyList());
                for (ShiftTemplate shiftTemplate2 : subShiftTemplateList) {
                    boolean defaultToRotationEmployee = date.compareTo(firstDraftDate) < 0;
                    shift = shiftTemplate2.createShiftOnDate(date, rosterState.getRotationLength().intValue(), zoneId, defaultToRotationEmployee);
                    if (date.compareTo(firstDraftDate) < 0) {
                        shift.setOriginalEmployee(shiftTemplate2.getRotationEmployee());
                    }
                    this.entityManager.persist((Object)shift);
                    shiftList.add(shift);
                }
                if (date.compareTo(firstDraftDate) < 0 || subShiftTemplateList.isEmpty()) continue;
                int extraShiftCount = this.generateRandomIntFromThresholds(EXTRA_SHIFT_THRESHOLDS);
                for (int i = 0; i < extraShiftCount; ++i) {
                    ShiftTemplate shiftTemplate3 = (ShiftTemplate)this.extractRandomElement(subShiftTemplateList);
                    shift = shiftTemplate3.createShiftOnDate(date, rosterState.getRotationLength().intValue(), zoneId, false);
                    this.entityManager.persist((Object)shift);
                    shiftList.add(shift);
                }
            }
            date = date.plusDays(1L);
            dayOffset = (dayOffset + 1) % rotationLength;
        }
        rosterState.setUnplannedRotationOffset(Integer.valueOf(dayOffset));
        return shiftList;
    }

    @Transactional
    public List<EmployeeAvailability> createEmployeeAvailabilityList(GeneratorType generatorType, Integer tenantId, RosterConstraintConfiguration rosterConstraintConfiguration, RosterState rosterState, List<Employee> employeeList, List<Shift> shiftList) {
        ZoneId zoneId = rosterState.getTimeZone();
        LocalDate date = rosterState.getFirstDraftDate().plusDays(1L);
        LocalDate firstUnplannedDate = rosterState.getFirstUnplannedDate();
        ArrayList<EmployeeAvailability> employeeAvailabilityList = new ArrayList<EmployeeAvailability>();
        Map<LocalDate, List<Shift>> startDayToShiftListMap = shiftList.stream().collect(Collectors.groupingBy(shift -> shift.getStartDateTime().toLocalDate()));
        while (date.compareTo(firstUnplannedDate) < 0) {
            List dayShiftList = startDayToShiftListMap.getOrDefault(date, Collections.emptyList());
            ArrayList<Employee> availableEmployeeList = new ArrayList<Employee>(employeeList);
            int stateCount = (employeeList.size() - dayShiftList.size()) / 4;
            if (stateCount <= 0) {
                stateCount = 1;
            }
            for (EmployeeAvailabilityState state : EmployeeAvailabilityState.values()) {
                for (int i = 0; i < stateCount; ++i) {
                    Employee employee = (Employee)availableEmployeeList.remove(this.random.nextInt(availableEmployeeList.size()));
                    LocalDateTime startDateTime = date.atTime(LocalTime.MIN);
                    LocalDateTime endDateTime = date.plusDays(1L).atTime(LocalTime.MIN);
                    OffsetDateTime startOffsetDateTime = OffsetDateTime.of(startDateTime, zoneId.getRules().getOffset(startDateTime));
                    OffsetDateTime endOffsetDateTime = OffsetDateTime.of(endDateTime, zoneId.getRules().getOffset(endDateTime));
                    EmployeeAvailability employeeAvailability = new EmployeeAvailability(tenantId, employee, startOffsetDateTime, endOffsetDateTime);
                    employeeAvailability.setState(state);
                    this.entityManager.persist((Object)employeeAvailability);
                    employeeAvailabilityList.add(employeeAvailability);
                }
            }
            date = date.plusDays(1L);
        }
        return employeeAvailabilityList;
    }

    private <E> E extractRandomElement(List<E> list) {
        return list.get(this.random.nextInt(list.size()));
    }

    private <E> List<E> extractRandomSubList(List<E> list, double ... thresholds) {
        int size = this.generateRandomIntFromThresholds(thresholds);
        if (size > list.size()) {
            size = list.size();
        }
        return this.extractRandomSubListOfSize(list, size);
    }

    private <E> List<E> extractRandomSubListOfSize(List<E> list, int size) {
        ArrayList<E> subList = new ArrayList<E>(list);
        Collections.shuffle(subList, this.random);
        subList.subList(size, subList.size()).clear();
        return subList;
    }

    private int generateRandomIntFromThresholds(double ... thresholds) {
        double randomDouble = this.random.nextDouble();
        for (int i = 0; i < thresholds.length; ++i) {
            if (!(randomDouble < thresholds[i])) continue;
            return i;
        }
        return thresholds.length;
    }
}

