/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.rotation;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import javax.validation.Validator;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.rotation.ShiftTemplate;
import org.optaweb.employeerostering.domain.rotation.view.ShiftTemplateView;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.employee.EmployeeService;
import org.optaweb.employeerostering.service.roster.RosterService;
import org.optaweb.employeerostering.service.rotation.ShiftTemplateRepository;
import org.optaweb.employeerostering.service.skill.SkillService;
import org.optaweb.employeerostering.service.spot.SpotService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class RotationService
extends AbstractRestService {
    private final ShiftTemplateRepository shiftTemplateRepository;
    private final RosterService rosterService;
    private final SpotService spotService;
    private final SkillService skillService;
    private final EmployeeService employeeService;

    public RotationService(Validator validator, ShiftTemplateRepository shiftTemplateRepository, RosterService rosterService, SpotService spotService, SkillService skillService, EmployeeService employeeService) {
        super(validator);
        this.shiftTemplateRepository = shiftTemplateRepository;
        this.rosterService = rosterService;
        Assert.notNull((Object)rosterService, (String)"rosterService must not be null.");
        this.spotService = spotService;
        Assert.notNull((Object)spotService, (String)"spotService must not be null.");
        this.skillService = skillService;
        Assert.notNull((Object)skillService, (String)"skillService must not be null.");
        this.employeeService = employeeService;
        Assert.notNull((Object)employeeService, (String)"employeeService must not be null.");
    }

    @Transactional
    public List<ShiftTemplateView> getShiftTemplateList(Integer tenantId) {
        RosterState rosterState = this.rosterService.getRosterState(tenantId);
        return this.shiftTemplateRepository.findAllByTenantId(tenantId).stream().map(st -> new ShiftTemplateView(rosterState.getRotationLength(), st)).collect(Collectors.toList());
    }

    private Set<Skill> getRequiredSkillSet(Integer tenantId, ShiftTemplateView shiftTemplateView) {
        return shiftTemplateView.getRequiredSkillSetIdList().stream().map(id -> this.skillService.getSkill(tenantId, id)).collect(Collectors.toCollection(HashSet::new));
    }

    @Transactional
    public ShiftTemplateView getShiftTemplate(Integer tenantId, Long id) {
        RosterState rosterState = this.rosterService.getRosterState(tenantId);
        ShiftTemplate shiftTemplate = (ShiftTemplate)this.shiftTemplateRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("No ShiftTemplate entity found with ID (" + id + ")."));
        this.validateBean(tenantId, (AbstractPersistable)shiftTemplate);
        return new ShiftTemplateView(rosterState.getRotationLength(), shiftTemplate);
    }

    @Transactional
    public ShiftTemplateView createShiftTemplate(Integer tenantId, ShiftTemplateView shiftTemplateView) {
        RosterState rosterState = this.rosterService.getRosterState(tenantId);
        Spot spot = this.spotService.getSpot(tenantId, shiftTemplateView.getSpotId());
        Set requiredSkillSet = this.getRequiredSkillSet(tenantId, shiftTemplateView);
        Employee employee = shiftTemplateView.getRotationEmployeeId() != null ? this.employeeService.getEmployee(tenantId, shiftTemplateView.getRotationEmployeeId()) : null;
        ShiftTemplate shiftTemplate = new ShiftTemplate(rosterState.getRotationLength(), shiftTemplateView, spot, employee, (Collection)requiredSkillSet);
        this.validateBean(tenantId, (AbstractPersistable)shiftTemplate);
        this.shiftTemplateRepository.save((Object)shiftTemplate);
        return new ShiftTemplateView(rosterState.getRotationLength(), shiftTemplate);
    }

    @Transactional
    public ShiftTemplateView updateShiftTemplate(Integer tenantId, ShiftTemplateView shiftTemplateView) {
        RosterState rosterState = this.rosterService.getRosterState(tenantId);
        Spot spot = this.spotService.getSpot(tenantId, shiftTemplateView.getSpotId());
        Set requiredSkillSet = this.getRequiredSkillSet(tenantId, shiftTemplateView);
        Employee employee = shiftTemplateView.getRotationEmployeeId() != null ? this.employeeService.getEmployee(tenantId, shiftTemplateView.getRotationEmployeeId()) : null;
        ShiftTemplate newShiftTemplate = new ShiftTemplate(rosterState.getRotationLength(), shiftTemplateView, spot, employee, (Collection)requiredSkillSet);
        this.validateBean(tenantId, (AbstractPersistable)newShiftTemplate);
        ShiftTemplate oldShiftTemplate = (ShiftTemplate)this.shiftTemplateRepository.findById((Object)newShiftTemplate.getId()).orElseThrow(() -> new EntityNotFoundException("ShiftTemplate entity with ID (" + newShiftTemplate.getId() + ") not found."));
        if (!oldShiftTemplate.getTenantId().equals(newShiftTemplate.getTenantId())) {
            throw new IllegalStateException("ShiftTemplate entity with tenantId (" + oldShiftTemplate.getTenantId() + ") cannot change tenants.");
        }
        oldShiftTemplate.setRotationEmployee(employee);
        oldShiftTemplate.setSpot(spot);
        oldShiftTemplate.setStartDayOffset(newShiftTemplate.getStartDayOffset());
        oldShiftTemplate.setEndDayOffset(newShiftTemplate.getEndDayOffset());
        oldShiftTemplate.setStartTime(newShiftTemplate.getStartTime());
        oldShiftTemplate.setEndTime(newShiftTemplate.getEndTime());
        ShiftTemplate updatedShiftTemplate = (ShiftTemplate)this.shiftTemplateRepository.saveAndFlush((Object)oldShiftTemplate);
        return new ShiftTemplateView(rosterState.getRotationLength(), updatedShiftTemplate);
    }

    @Transactional
    public Boolean deleteShiftTemplate(Integer tenantId, Long id) {
        Optional shiftTemplateOptional = this.shiftTemplateRepository.findById((Object)id);
        if (!shiftTemplateOptional.isPresent()) {
            return false;
        }
        this.validateBean(tenantId, (AbstractPersistable)shiftTemplateOptional.get());
        this.shiftTemplateRepository.deleteById((Object)id);
        return true;
    }
}

