/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.optaweb.employeerostering.service.common;

import java.util.Objects;
import java.util.Set;

import javax.validation.ConstraintViolation;
import javax.validation.Validator;

import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.exception.ConstraintViolatedException;

public class AbstractRestService {

    private Validator validator;

    public AbstractRestService(Validator validator) {
        this.validator = validator;
    }

    private void validateTenantIdParameter(Integer tenantId, AbstractPersistable persistable) {
        if (!Objects.equals(persistable.getTenantId(), tenantId)) {
            throw new IllegalStateException("The tenantId (" + tenantId + ") does not match the persistable ("
                    + persistable + ")'s tenantId ("
                    + persistable.getTenantId() + ").");
        }
    }

    protected void validateBean(Integer tenantId, AbstractPersistable persistable) {
        Set<ConstraintViolation<Object>> violationSet = validator.validate(persistable);
        if (!violationSet.isEmpty()) {
            throw new ConstraintViolatedException(persistable, persistable.getClass(), violationSet);
        }
        validateTenantIdParameter(tenantId, persistable);
    }
}
