/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.employee;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.common.HighContrastColor;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.skill.Skill;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"tenantId", "name"})})
public class Employee
extends AbstractPersistable {
    @NotNull
    @Size(min=1, max=120)
    @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces")
    private @NotNull @Size(min=1, max=120) @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces") String name;
    @NotNull
    @Size(min=1, max=3)
    @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces")
    private @NotNull @Size(min=1, max=3) @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces") String shortId;
    @NotNull
    @Size(min=7, max=7)
    @Pattern(regexp="^#[0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f]$")
    private @NotNull @Size(min=7, max=7) @Pattern(regexp="^#[0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f]$") String color;
    @NotNull
    @ManyToOne
    private Contract contract;
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="EmployeeSkillProficiencySet", joinColumns={@JoinColumn(name="employeeId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="skillId", referencedColumnName="id")})
    private Set<Skill> skillProficiencySet;

    public Employee() {
    }

    public Employee(Integer tenantId, String name, Contract contract, Set<Skill> skillProficiencySet) {
        super(tenantId);
        this.name = name;
        this.shortId = Employee.generateShortIdFromName((String)name);
        this.color = HighContrastColor.generateColorFromHashcode((Object)name);
        this.contract = contract;
        this.skillProficiencySet = skillProficiencySet;
    }

    public Employee(Integer tenantId, String name, Contract contract, Set<Skill> skillProficiencySet, String shortId, String color) {
        super(tenantId);
        this.name = name;
        this.shortId = shortId;
        this.color = color;
        this.contract = contract;
        this.skillProficiencySet = skillProficiencySet;
    }

    public boolean hasSkill(Skill skill) {
        return this.skillProficiencySet.contains(skill);
    }

    public boolean hasSkills(Collection<Skill> skills) {
        return this.skillProficiencySet.containsAll(skills);
    }

    public String toString() {
        return this.name;
    }

    public static String generateShortIdFromName(String name) {
        return Arrays.stream(name.split(" ")).limit(3L).map(s -> s.substring(0, 1)).collect(Collectors.joining(""));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Skill> getSkillProficiencySet() {
        return this.skillProficiencySet;
    }

    public void setSkillProficiencySet(Set<Skill> skillProficiencySet) {
        this.skillProficiencySet = skillProficiencySet;
    }

    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    public String getShortId() {
        return this.shortId;
    }

    public void setShortId(String shortId) {
        this.shortId = shortId;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public boolean equals(Object o) {
        if (o instanceof Employee) {
            Employee other = (Employee)o;
            return this.name.equals(other.getName()) && this.contract.equals((Object)other.getContract()) && this.skillProficiencySet.equals(other.getSkillProficiencySet());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.contract, this.skillProficiencySet);
    }
}

