/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.admin;

import org.optaweb.employeerostering.service.contract.ContractRepository;
import org.optaweb.employeerostering.service.employee.EmployeeAvailabilityRepository;
import org.optaweb.employeerostering.service.employee.EmployeeRepository;
import org.optaweb.employeerostering.service.roster.RosterGenerator;
import org.optaweb.employeerostering.service.roster.RosterStateRepository;
import org.optaweb.employeerostering.service.rotation.TimeBucketRepository;
import org.optaweb.employeerostering.service.shift.ShiftRepository;
import org.optaweb.employeerostering.service.skill.SkillRepository;
import org.optaweb.employeerostering.service.spot.SpotRepository;
import org.optaweb.employeerostering.service.tenant.RosterConstraintConfigurationRepository;
import org.optaweb.employeerostering.service.tenant.TenantRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdminService {
    private ShiftRepository shiftRepository;
    private EmployeeAvailabilityRepository employeeAvailabilityRepository;
    private TimeBucketRepository timeBucketRepository;
    private EmployeeRepository employeeRepository;
    private ContractRepository contractRepository;
    private SpotRepository spotRepository;
    private SkillRepository skillRepository;
    private RosterConstraintConfigurationRepository rosterConstraintConfigurationRepository;
    private RosterStateRepository rosterStateRepository;
    private TenantRepository tenantRepository;
    private RosterGenerator rosterGenerator;

    public AdminService(ShiftRepository shiftRepository, EmployeeAvailabilityRepository employeeAvailabilityRepository, TimeBucketRepository timeBucketRepository, EmployeeRepository employeeRepository, ContractRepository contractRepository, SpotRepository spotRepository, SkillRepository skillRepository, RosterConstraintConfigurationRepository rosterConstraintConfigurationRepository, RosterStateRepository rosterStateRepository, TenantRepository tenantRepository, RosterGenerator rosterGenerator) {
        this.shiftRepository = shiftRepository;
        this.employeeAvailabilityRepository = employeeAvailabilityRepository;
        this.timeBucketRepository = timeBucketRepository;
        this.employeeRepository = employeeRepository;
        this.contractRepository = contractRepository;
        this.spotRepository = spotRepository;
        this.skillRepository = skillRepository;
        this.rosterConstraintConfigurationRepository = rosterConstraintConfigurationRepository;
        this.rosterStateRepository = rosterStateRepository;
        this.tenantRepository = tenantRepository;
        this.rosterGenerator = rosterGenerator;
    }

    @Transactional
    public void resetApplication() {
        this.deleteAllEntities();
        this.rosterGenerator.setUpGeneratedData();
    }

    private void deleteAllEntities() {
        this.shiftRepository.deleteAllInBatch();
        this.employeeAvailabilityRepository.deleteAllInBatch();
        this.timeBucketRepository.deleteAllInBatch();
        this.employeeRepository.deleteAllInBatch();
        this.contractRepository.deleteAllInBatch();
        this.spotRepository.deleteAllInBatch();
        this.skillRepository.deleteAllInBatch();
        this.rosterConstraintConfigurationRepository.deleteAllInBatch();
        this.rosterStateRepository.deleteAllInBatch();
        this.tenantRepository.deleteAllInBatch();
    }
}

