/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.util;

import com.github.javaparser.StaticJavaParser;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.drools.mvelcompiler.MvelCompilerException;

public class TypeUtils {
    private TypeUtils() {
    }

    public static boolean isCollection(Type t) {
        return Stream.of(List.class, Map.class).anyMatch(cls -> {
            Class<?> clazz = TypeUtils.classFromType(t);
            return cls.isAssignableFrom(clazz);
        });
    }

    public static Class<?> classFromType(Type t) {
        Class clazz;
        if (t instanceof Class) {
            clazz = (Class)t;
        } else if (t instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)t).getRawType();
        } else {
            throw new MvelCompilerException("Unable to parse type");
        }
        return clazz;
    }

    public static com.github.javaparser.ast.type.Type toJPType(Type t) {
        return TypeUtils.toJPType(TypeUtils.classFromType(t));
    }

    public static com.github.javaparser.ast.type.Type toJPType(Class<?> c) {
        return StaticJavaParser.parseType((String)c.getCanonicalName());
    }
}

