/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.postgresql.runtime.graal;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.postgresql.core.BaseConnection;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.xml.DefaultPGXmlFactoryFactory;
import org.postgresql.xml.PGXmlFactoryFactory;

public final class DomHelper {
    public static String processDomResult(DOMResult domResult, BaseConnection conn) throws SQLException {
        return DomHelper.maybeProcessAsDomResult(domResult, conn);
    }

    public static String maybeProcessAsDomResult(DOMResult domResult, BaseConnection conn) throws SQLException {
        try {
            return (String)DomHelper.class.getMethod(DomHelper.obfuscatedMethodName(), DOMResult.class, BaseConnection.class).invoke(null, domResult, conn);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("Unexpected failure in reflective call - please report", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new RuntimeException("Unexpected failure in reflective call - please report", e);
        }
    }

    private static String obfuscatedMethodName() {
        return "reallyProcessDomResult";
    }

    public static String reallyProcessDomResult(DOMResult domResult, BaseConnection conn) throws SQLException {
        TransformerFactory factory = DomHelper.getXmlFactoryFactory(conn).newTransformerFactory();
        try {
            Transformer transformer = factory.newTransformer();
            DOMSource domSource = new DOMSource(domResult.getNode());
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(domSource, streamResult);
            return stringWriter.toString();
        }
        catch (TransformerException te) {
            throw new PSQLException(GT.tr((String)"Unable to convert DOMResult SQLXML data to a string.", (Object[])new Object[0]), PSQLState.DATA_ERROR, (Throwable)te);
        }
    }

    private static PGXmlFactoryFactory getXmlFactoryFactory(BaseConnection conn) throws SQLException {
        if (conn != null) {
            return conn.getXmlFactoryFactory();
        }
        return DefaultPGXmlFactoryFactory.INSTANCE;
    }
}

