/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.rotation;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.rotation.Seat;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;

@Entity(name="Time_Bucket")
public class TimeBucket
extends AbstractPersistable
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    private LocalTime startTime;
    private LocalTime endTime;
    @ManyToOne
    private Spot spot;
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="TimeBucketAdditionalSkillSet", joinColumns={@JoinColumn(name="timebucketId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="skillId", referencedColumnName="id")})
    private Set<Skill> additionalSkillSet;
    @ElementCollection
    @CollectionTable(name="repeat_on_day_set", joinColumns={@JoinColumn(name="day_id", referencedColumnName="id", foreignKey=@ForeignKey(name="DAY_FK", foreignKeyDefinition="FOREIGN KEY (day_id) references public.time_bucket (id) ON UPDATE NO ACTION ON DELETE CASCADE"))})
    private Set<DayOfWeek> repeatOnDaySet;
    @ElementCollection
    @CollectionTable(name="seat_list", joinColumns={@JoinColumn(name="seat_id", referencedColumnName="id", foreignKey=@ForeignKey(name="SEAT_FK", foreignKeyDefinition="FOREIGN KEY (seat_id) references public.time_bucket (id) ON UPDATE NO ACTION ON DELETE CASCADE"))})
    private List<Seat> seatList;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public TimeBucket() {
    }

    public TimeBucket(Integer tenantId, Spot spot, LocalTime startTime, LocalTime endTime, Set<Skill> additionalSkillSet, Set<DayOfWeek> repeatOnDaySet, DayOfWeek startOfWeek, int rotationLength) {
        this(tenantId, spot, startTime, endTime, additionalSkillSet, repeatOnDaySet, TimeBucket.generateDefaultSeatList(startOfWeek, repeatOnDaySet, rotationLength));
    }

    public TimeBucket(Integer tenantId, Spot spot, LocalTime startTime, LocalTime endTime, Set<Skill> additionalSkillSet, Set<DayOfWeek> repeatOnDaySet, List<Seat> seatList) {
        super(tenantId);
        this.$$_hibernate_write_spot(spot);
        this.$$_hibernate_write_startTime(startTime);
        this.$$_hibernate_write_endTime(endTime);
        this.$$_hibernate_write_additionalSkillSet(additionalSkillSet);
        this.$$_hibernate_write_repeatOnDaySet(repeatOnDaySet);
        this.$$_hibernate_write_seatList(new ArrayList<Seat>(seatList));
    }

    private static List<Seat> generateDefaultSeatList(DayOfWeek startOfWeek, Set<DayOfWeek> repeatOnDaySet, int rotationLength) {
        ArrayList<Seat> seatList = new ArrayList<Seat>();
        DayOfWeek rotationDay = startOfWeek;
        for (int i = 0; i < rotationLength; ++i) {
            if (repeatOnDaySet.contains(rotationDay)) {
                seatList.add(new Seat(i, null));
            }
            rotationDay = rotationDay.plus(1L);
        }
        return seatList;
    }

    public Spot getSpot() {
        return this.$$_hibernate_read_spot();
    }

    public void setSpot(Spot spot) {
        this.$$_hibernate_write_spot(spot);
    }

    public LocalTime getStartTime() {
        return this.$$_hibernate_read_startTime();
    }

    public void setStartTime(LocalTime startTime) {
        this.$$_hibernate_write_startTime(startTime);
    }

    public LocalTime getEndTime() {
        return this.$$_hibernate_read_endTime();
    }

    public void setEndTime(LocalTime endTime) {
        this.$$_hibernate_write_endTime(endTime);
    }

    public Set<Skill> getAdditionalSkillSet() {
        return this.$$_hibernate_read_additionalSkillSet();
    }

    public void setAdditionalSkillSet(Set<Skill> additionalSkillSet) {
        this.$$_hibernate_write_additionalSkillSet(additionalSkillSet);
    }

    public Set<DayOfWeek> getRepeatOnDaySet() {
        return this.$$_hibernate_read_repeatOnDaySet();
    }

    public void setRepeatOnDaySet(Set<DayOfWeek> repeatOnDaySet) {
        this.$$_hibernate_write_repeatOnDaySet(repeatOnDaySet);
    }

    public List<Seat> getSeatList() {
        return this.$$_hibernate_read_seatList();
    }

    public void setSeatList(List<Seat> seatList) {
        this.$$_hibernate_write_seatList(seatList);
    }

    public void setValuesFromTimeBucket(TimeBucket updatedTimeBucket) {
        this.setSpot(updatedTimeBucket.getSpot());
        this.setStartTime(updatedTimeBucket.getStartTime());
        this.setEndTime(updatedTimeBucket.getEndTime());
        this.setAdditionalSkillSet(updatedTimeBucket.getAdditionalSkillSet());
        this.setRepeatOnDaySet(updatedTimeBucket.getRepeatOnDaySet());
        this.setSeatList(updatedTimeBucket.getSeatList());
    }

    public Optional<Shift> createShiftForOffset(LocalDate startDate, int offset, ZoneId zoneId, boolean defaultToRotationEmployee) {
        return this.$$_hibernate_read_seatList().stream().filter(seat -> seat.getDayInRotation() == offset).findAny().map(seat -> {
            LocalDateTime startDateTime = startDate.atTime(this.getStartTime());
            LocalDate endDate = this.getStartTime().isBefore(this.getEndTime()) ? startDate : startDate.plusDays(1L);
            LocalDateTime endDateTime = endDate.atTime(this.getEndTime());
            OffsetDateTime startOffsetDateTime = OffsetDateTime.of(startDateTime, zoneId.getRules().getOffset(startDateTime));
            OffsetDateTime endOffsetDateTime = OffsetDateTime.of(endDateTime, zoneId.getRules().getOffset(endDateTime));
            Shift shift = new Shift(this.getTenantId(), this.getSpot(), startOffsetDateTime, endOffsetDateTime, seat.getEmployee(), new HashSet<Skill>(this.$$_hibernate_read_additionalSkillSet()), null);
            if (defaultToRotationEmployee) {
                shift.setEmployee(seat.getEmployee());
            }
            return shift;
        });
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        TimeBucket timeBucket = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block8: {
            int n2;
            block9: {
                TimeBucket timeBucket;
                TimeBucket timeBucket2;
                TimeBucket timeBucket3 = timeBucket2 = (timeBucket = this);
                int n3 = 0;
                if (n3 == 0 && timeBucket2.$$_hibernate_collectionTracker != null) {
                    int n4 = timeBucket2.$$_hibernate_collectionTracker.getSize("additionalSkillSet");
                    if (timeBucket2.additionalSkillSet == null && n4 != -1) {
                        n3 = 1;
                    } else if (timeBucket2.additionalSkillSet != null && (!(timeBucket2.additionalSkillSet instanceof PersistentCollection) || ((PersistentCollection)timeBucket2.additionalSkillSet).wasInitialized()) && n4 != timeBucket2.additionalSkillSet.size()) {
                        n3 = 1;
                    }
                }
                if ((n2 = n3) == 0 && timeBucket.$$_hibernate_collectionTracker != null) {
                    n3 = timeBucket.$$_hibernate_collectionTracker.getSize("repeatOnDaySet");
                    if (timeBucket.repeatOnDaySet == null && n3 != -1) {
                        n2 = 1;
                    } else if (timeBucket.repeatOnDaySet != null && (!(timeBucket.repeatOnDaySet instanceof PersistentCollection) || ((PersistentCollection)timeBucket.repeatOnDaySet).wasInitialized()) && n3 != timeBucket.repeatOnDaySet.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block8;
                n2 = this.$$_hibernate_collectionTracker.getSize("seatList");
                if (this.seatList != null || n2 == -1) break block9;
                n = 1;
                break block8;
            }
            if (this.seatList == null || this.seatList instanceof PersistentCollection && !((PersistentCollection)this.seatList).wasInitialized() || n2 == this.seatList.size()) break block8;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block8: {
            int n;
            block9: {
                TimeBucket timeBucket = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                TimeBucket timeBucket2 = timeBucket;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                TimeBucket timeBucket3 = timeBucket2;
                DirtyTracker dirtyTracker4 = dirtyTracker3;
                if (timeBucket2.$$_hibernate_collectionTracker != null) {
                    int n2 = timeBucket2.$$_hibernate_collectionTracker.getSize("additionalSkillSet");
                    if (timeBucket2.additionalSkillSet == null && n2 != -1) {
                        dirtyTracker3.add("additionalSkillSet");
                    } else if (timeBucket2.additionalSkillSet != null && (!(timeBucket2.additionalSkillSet instanceof PersistentCollection) || ((PersistentCollection)timeBucket2.additionalSkillSet).wasInitialized()) && n2 != timeBucket2.additionalSkillSet.size()) {
                        dirtyTracker3.add("additionalSkillSet");
                    }
                }
                if (timeBucket.$$_hibernate_collectionTracker != null) {
                    int n3 = timeBucket.$$_hibernate_collectionTracker.getSize("repeatOnDaySet");
                    if (timeBucket.repeatOnDaySet == null && n3 != -1) {
                        dirtyTracker2.add("repeatOnDaySet");
                    } else if (timeBucket.repeatOnDaySet != null && (!(timeBucket.repeatOnDaySet instanceof PersistentCollection) || ((PersistentCollection)timeBucket.repeatOnDaySet).wasInitialized()) && n3 != timeBucket.repeatOnDaySet.size()) {
                        dirtyTracker2.add("repeatOnDaySet");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block8;
                n = this.$$_hibernate_collectionTracker.getSize("seatList");
                if (this.seatList != null || n == -1) break block9;
                dirtyTracker.add("seatList");
                break block8;
            }
            if (this.seatList == null || this.seatList instanceof PersistentCollection && !((PersistentCollection)this.seatList).wasInitialized() || n == this.seatList.size()) break block8;
            dirtyTracker.add("seatList");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block9: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            TimeBucket timeBucket = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            TimeBucket timeBucket2 = timeBucket;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            TimeBucket timeBucket3 = timeBucket2;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor4 = lazyAttributeLoadingInterceptor3;
            if (lazyAttributeLoadingInterceptor3 == null || lazyAttributeLoadingInterceptor3.isAttributeLoaded("additionalSkillSet")) {
                if (timeBucket2.additionalSkillSet == null || timeBucket2.additionalSkillSet instanceof PersistentCollection && !((PersistentCollection)timeBucket2.additionalSkillSet).wasInitialized()) {
                    timeBucket2.$$_hibernate_collectionTracker.add("additionalSkillSet", -1);
                } else {
                    timeBucket2.$$_hibernate_collectionTracker.add("additionalSkillSet", timeBucket2.additionalSkillSet.size());
                }
            }
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("repeatOnDaySet")) {
                if (timeBucket.repeatOnDaySet == null || timeBucket.repeatOnDaySet instanceof PersistentCollection && !((PersistentCollection)timeBucket.repeatOnDaySet).wasInitialized()) {
                    timeBucket.$$_hibernate_collectionTracker.add("repeatOnDaySet", -1);
                } else {
                    timeBucket.$$_hibernate_collectionTracker.add("repeatOnDaySet", timeBucket.repeatOnDaySet.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("seatList")) break block9;
            if (this.seatList == null || this.seatList instanceof PersistentCollection && !((PersistentCollection)this.seatList).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("seatList", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("seatList", this.seatList.size());
            }
        }
    }

    public LocalTime $$_hibernate_read_startTime() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startTime = (LocalTime)this.$$_hibernate_getInterceptor().readObject((Object)this, "startTime", (Object)this.startTime);
        }
        return this.startTime;
    }

    public void $$_hibernate_write_startTime(LocalTime localTime) {
        if (!Objects.deepEquals(localTime, this.startTime)) {
            this.$$_hibernate_trackChange("startTime");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startTime = (LocalTime)this.$$_hibernate_getInterceptor().writeObject((Object)this, "startTime", (Object)this.startTime, (Object)localTime);
            return;
        }
        this.startTime = localTime;
    }

    public LocalTime $$_hibernate_read_endTime() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.endTime = (LocalTime)this.$$_hibernate_getInterceptor().readObject((Object)this, "endTime", (Object)this.endTime);
        }
        return this.endTime;
    }

    public void $$_hibernate_write_endTime(LocalTime localTime) {
        if (!Objects.deepEquals(localTime, this.endTime)) {
            this.$$_hibernate_trackChange("endTime");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.endTime = (LocalTime)this.$$_hibernate_getInterceptor().writeObject((Object)this, "endTime", (Object)this.endTime, (Object)localTime);
            return;
        }
        this.endTime = localTime;
    }

    public Spot $$_hibernate_read_spot() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.spot = (Spot)this.$$_hibernate_getInterceptor().readObject((Object)this, "spot", (Object)this.spot);
        }
        return this.spot;
    }

    public void $$_hibernate_write_spot(Spot spot) {
        if (!Objects.deepEquals(spot, this.spot)) {
            this.$$_hibernate_trackChange("spot");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.spot = (Spot)this.$$_hibernate_getInterceptor().writeObject((Object)this, "spot", (Object)this.spot, (Object)spot);
            return;
        }
        this.spot = spot;
    }

    public Set $$_hibernate_read_additionalSkillSet() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.additionalSkillSet = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "additionalSkillSet", this.additionalSkillSet);
        }
        return this.additionalSkillSet;
    }

    public void $$_hibernate_write_additionalSkillSet(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.additionalSkillSet = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "additionalSkillSet", this.additionalSkillSet, (Object)set);
            return;
        }
        this.additionalSkillSet = set;
    }

    public Set $$_hibernate_read_repeatOnDaySet() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.repeatOnDaySet = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "repeatOnDaySet", this.repeatOnDaySet);
        }
        return this.repeatOnDaySet;
    }

    public void $$_hibernate_write_repeatOnDaySet(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.repeatOnDaySet = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "repeatOnDaySet", this.repeatOnDaySet, (Object)set);
            return;
        }
        this.repeatOnDaySet = set;
    }

    public List $$_hibernate_read_seatList() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.seatList = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "seatList", this.seatList);
        }
        return this.seatList;
    }

    public void $$_hibernate_write_seatList(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.seatList = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "seatList", this.seatList, (Object)list);
            return;
        }
        this.seatList = list;
    }

    @Override
    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)super.$$_hibernate_read_id()));
        }
        return super.$$_hibernate_read_id();
    }

    @Override
    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_id((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)super.$$_hibernate_read_id(), (Object)l));
            return;
        }
        super.$$_hibernate_write_id(l);
    }

    @Override
    public Integer $$_hibernate_read_tenantId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId()));
        }
        return super.$$_hibernate_read_tenantId();
    }

    @Override
    public void $$_hibernate_write_tenantId(Integer n) {
        if (!Objects.deepEquals(n, ((AbstractPersistable)this).$$_hibernate_read_tenantId())) {
            this.$$_hibernate_trackChange("tenantId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_tenantId((Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tenantId", (Object)super.$$_hibernate_read_tenantId(), (Object)n));
            return;
        }
        super.$$_hibernate_write_tenantId(n);
    }

    @Override
    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)super.$$_hibernate_read_version()));
        }
        return super.$$_hibernate_read_version();
    }

    @Override
    public void $$_hibernate_write_version(Long l) {
        if (!Objects.deepEquals(l, ((AbstractPersistable)this).$$_hibernate_read_version())) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_version((Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)super.$$_hibernate_read_version(), (Object)l));
            return;
        }
        super.$$_hibernate_write_version(l);
    }
}

