/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.skill;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.skill.view.SkillView;
import org.optaweb.employeerostering.service.skill.SkillService;

@Path(value="/rest/tenant/{tenantId}/skill")
@ApplicationScoped
@Tag(name="Skill")
public class SkillController {
    private final SkillService skillService;

    @Inject
    public SkillController(SkillService skillService) {
        this.skillService = skillService;
    }

    @GET
    @Path(value="/")
    @Operation(summary="List Skills", description="Get a list of all skills")
    public List<Skill> getSkillList(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return this.skillService.getSkillList(tenantId);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get Skill", description="Gets a skill by id")
    public Skill getSkill(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.skillService.getSkill(tenantId, id);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete Skill", description="Deletes a skill by id")
    public Boolean deleteSkill(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.skillService.deleteSkill(tenantId, id);
    }

    @POST
    @Path(value="/add")
    @Operation(summary="Add Skill", description="Adds a new skill")
    public Skill createSkill(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid SkillView skillView) {
        return this.skillService.createSkill(tenantId, skillView);
    }

    @POST
    @Path(value="/update")
    @Operation(summary="Update Skill", description="Updates a skill")
    public Skill updateSkill(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid SkillView skillView) {
        return this.skillService.updateSkill(tenantId, skillView);
    }
}

