/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.service;

import io.quarkus.hibernate.orm.runtime.service.QuarkusSimplifiedIdentifierGeneratorFactory;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.dialect.Dialect;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;

public final class QuarkusMutableIdentifierGeneratorFactory
implements MutableIdentifierGeneratorFactory,
Serializable,
ServiceRegistryAwareService {
    private final QuarkusSimplifiedIdentifierGeneratorFactory original = new QuarkusSimplifiedIdentifierGeneratorFactory();
    private final ConcurrentHashMap<String, Class<? extends IdentifierGenerator>> typeCache = new ConcurrentHashMap();

    public void register(String strategy, Class generatorClass) {
        this.original.register(strategy, generatorClass);
        this.storeCache(strategy, generatorClass);
    }

    public Dialect getDialect() {
        return this.original.getDialect();
    }

    public void setDialect(Dialect dialect) {
        this.original.setDialect(dialect);
    }

    public IdentifierGenerator createIdentifierGenerator(String strategy, Type type, Properties config) {
        IdentifierGenerator identifierGenerator = this.original.createIdentifierGenerator(strategy, type, config);
        this.storeCache(strategy, identifierGenerator.getClass());
        return identifierGenerator;
    }

    private void storeCache(String strategy, Class<? extends IdentifierGenerator> generatorClass) {
        if (strategy == null || generatorClass == null) {
            return;
        }
        String className = generatorClass.getName();
        this.typeCache.put(strategy, generatorClass);
        if (!className.equals(strategy)) {
            this.typeCache.put(className, generatorClass);
        }
    }

    public Class getIdentifierGeneratorClass(String strategy) {
        Class aClass = this.typeCache.get(strategy);
        if (aClass != null) {
            return aClass;
        }
        aClass = this.original.getIdentifierGeneratorClass(strategy);
        this.storeCache(strategy, aClass);
        return aClass;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.original.injectServices(serviceRegistry);
    }
}

