/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common;

import java.util.ArrayList;
import java.util.List;

public class Sort {
    private List<Column> columns = new ArrayList<Column>();

    private Sort() {
    }

    public static Sort by(String column) {
        return new Sort().and(column);
    }

    public static Sort by(String column, Direction direction) {
        return new Sort().and(column, direction);
    }

    public static Sort by(String ... columns) {
        Sort sort = new Sort();
        for (String column : columns) {
            sort.and(column);
        }
        return sort;
    }

    public static Sort ascending(String ... columns) {
        return Sort.by(columns);
    }

    public static Sort descending(String ... columns) {
        Sort sort = new Sort();
        for (String column : columns) {
            sort.and(column, Direction.Descending);
        }
        return sort;
    }

    public Sort descending() {
        return this.direction(Direction.Descending);
    }

    public Sort ascending() {
        return this.direction(Direction.Ascending);
    }

    public Sort direction(Direction direction) {
        for (Column column : this.columns) {
            column.direction = direction;
        }
        return this;
    }

    public Sort and(String name) {
        this.columns.add(new Column(name));
        return this;
    }

    public Sort and(String name, Direction direction) {
        this.columns.add(new Column(name, direction));
        return this;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public static Sort empty() {
        return Sort.by(new String[0]);
    }

    public static class Column {
        private String name;
        private Direction direction;

        public Column(String name) {
            this(name, Direction.Ascending);
        }

        public Column(String name, Direction direction) {
            this.name = name;
            this.direction = direction;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }
    }

    public static enum Direction {
        Ascending,
        Descending;

    }
}

