/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.employee;

import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.panache.common.Sort;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.optaweb.employeerostering.domain.employee.Employee;

@ApplicationScoped
public class EmployeeRepository
implements PanacheRepository<Employee> {
    public List<Employee> findAllByTenantId(Integer tenantId) {
        return this.find("tenantId", Sort.ascending((String[])new String[]{"name"}), new Object[]{tenantId}).list();
    }

    public Optional<Employee> findEmployeeByName(Integer tenantId, String name) {
        return this.find("tenantId = ?1 and name = ?2", Sort.ascending((String[])new String[]{"name"}), new Object[]{tenantId, name}).singleResultOptional();
    }

    public void deleteForTenant(Integer tenantId) {
        this.delete("tenantId", new Object[]{tenantId});
    }
}

