/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.shift;

import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.panache.common.Sort;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.spot.Spot;

@ApplicationScoped
public class ShiftRepository
implements PanacheRepository<Shift> {
    public List<Shift> findAllByTenantId(Integer tenantId) {
        return this.find("tenantId", Sort.ascending((String[])new String[]{"startDateTime", "spot.name"}), new Object[]{tenantId}).list();
    }

    public List<Shift> findAllByTenantIdBetweenDates(Integer tenantId, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        return this.find("tenantId = ?1 and endDateTime >= ?2 and startDateTime < ?3", Sort.ascending((String[])new String[]{"startDateTime", "spot.name"}), new Object[]{tenantId, startDateTime, endDateTime}).list();
    }

    public void deleteForTenant(Integer tenantId) {
        this.delete("tenantId", new Object[]{tenantId});
    }

    public List<Shift> filterWithSpots(Integer tenantId, Set<Spot> spotSet, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        if (spotSet.isEmpty()) {
            return Collections.emptyList();
        }
        return this.find("tenantId = ?1 and spot in ?2 and endDateTime >= ?3 and startDateTime < ?4", Sort.ascending((String[])new String[]{"startDateTime", "spot.name"}), new Object[]{tenantId, spotSet, startDateTime, endDateTime}).list();
    }

    public List<Shift> filterWithEmployees(Integer tenantId, Set<Employee> employeeSet, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        if (employeeSet.isEmpty()) {
            return Collections.emptyList();
        }
        return this.find("tenantId = ?1 and employee in ?2 and endDateTime >= ?3 and startDateTime < ?4", Sort.ascending((String[])new String[]{"startDateTime", "spot.name"}), new Object[]{tenantId, employeeSet, startDateTime, endDateTime}).list();
    }
}

