/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.solver;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.optaweb.employeerostering.domain.shift.Shift;

public final class LoadBalancingHourCounter {
    private final Map<Instant, Integer> hourlyCountsMap = new HashMap<Instant, Integer>(0);
    private volatile long sumOfSquares = 0L;

    private synchronized void adjustHourlyCount(Shift shift, boolean increase) {
        long hourCount = (long)Math.ceil((double)shift.getLengthInMinutes() / 60.0);
        Instant baseHour = shift.getStartDateTime().truncatedTo(ChronoUnit.HOURS).toInstant();
        int hour = 0;
        while ((long)hour < hourCount) {
            int newHourlyCount;
            Instant actualHour = baseHour.plus(1L, ChronoUnit.HOURS);
            int currentHourlyCount = this.hourlyCountsMap.getOrDefault(actualHour, 0);
            if (currentHourlyCount > 0) {
                this.sumOfSquares -= (long)(currentHourlyCount * currentHourlyCount);
            }
            int n = newHourlyCount = increase ? currentHourlyCount + 1 : currentHourlyCount - 1;
            if (newHourlyCount == 0) {
                this.hourlyCountsMap.remove(actualHour);
            } else {
                this.hourlyCountsMap.put(actualHour, newHourlyCount);
                this.sumOfSquares += (long)(newHourlyCount * newHourlyCount);
            }
            ++hour;
        }
    }

    public void increaseHourlyCount(Shift shift) {
        this.adjustHourlyCount(shift, true);
    }

    public void decreaseHourlyCount(Shift shift) {
        this.adjustHourlyCount(shift, false);
    }

    public synchronized long getLoadBalance() {
        return Math.round(Math.sqrt(this.sumOfSquares) * 1000.0);
    }
}

