/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.validator;

import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.ConfigValidator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validator;

public interface BeanValidationConfigValidator
extends ConfigValidator {
    public Validator getValidator();

    default public void validateMapping(Class<?> mappingClass, String prefix, Object mappingObject) throws ConfigValidationException {
        ArrayList<ConfigValidationException.Problem> problems = new ArrayList<ConfigValidationException.Problem>();
        ConfigMappingInterface mappingInterface = ConfigMappingInterface.getConfigurationInterface(mappingClass);
        if (mappingInterface != null) {
            this.validateMappingInterface(mappingInterface, prefix, mappingInterface.getNamingStrategy(), mappingObject, problems);
        } else {
            this.validateMappingClass(mappingObject, problems);
        }
        if (!problems.isEmpty()) {
            throw new ConfigValidationException(problems.toArray(ConfigValidationException.Problem.NO_PROBLEMS));
        }
    }

    default public void validateMappingInterface(ConfigMappingInterface mappingInterface, String currentPath, ConfigMappingInterface.NamingStrategy namingStrategy, Object mappingObject, List<ConfigValidationException.Problem> problems) {
        for (ConfigMappingInterface.Property property : mappingInterface.getProperties()) {
            this.validateProperty(property, currentPath, namingStrategy, mappingObject, false, problems);
        }
    }

    default public void validateProperty(ConfigMappingInterface.Property property, String currentPath, ConfigMappingInterface.NamingStrategy namingStrategy, Object mappingObject, boolean optional, List<ConfigValidationException.Problem> problems) {
        if (property.isOptional()) {
            this.validateProperty((ConfigMappingInterface.Property)property.asOptional().getNestedProperty(), currentPath, namingStrategy, mappingObject, true, problems);
        }
        if ((property.isLeaf() || property.isPrimitive()) && !property.isOptional()) {
            this.validatePropertyValue(property, currentPath, namingStrategy, mappingObject, problems);
        }
        if (property.isGroup()) {
            try {
                Object group = property.getMethod().invoke(mappingObject, new Object[0]);
                if (optional) {
                    Optional optionalGroup = (Optional)group;
                    if (!optionalGroup.isPresent()) {
                        return;
                    }
                    group = optionalGroup.get();
                }
                this.validateMappingInterface(property.asGroup().getGroupType(), this.appendPropertyName(currentPath, property), namingStrategy, group, problems);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                try {
                    throw e.getCause();
                }
                catch (Error | RuntimeException e2) {
                    throw e2;
                }
                catch (Throwable t2) {
                    throw new UndeclaredThrowableException(t2);
                }
            }
        }
        if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            if (collectionProperty.getElement().isGroup()) {
                try {
                    Collection collection = (Collection)property.getMethod().invoke(mappingObject, new Object[0]);
                    int i = 0;
                    for (Object element : collection) {
                        this.validateMappingInterface(collectionProperty.getElement().asGroup().getGroupType(), this.appendPropertyName(currentPath, property) + "[" + i + "]", namingStrategy, element, problems);
                        ++i;
                    }
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
                catch (InvocationTargetException e) {
                    try {
                        throw e.getCause();
                    }
                    catch (Error | RuntimeException e2) {
                        throw e2;
                    }
                    catch (Throwable t2) {
                        throw new UndeclaredThrowableException(t2);
                    }
                }
            } else if (collectionProperty.getElement().isLeaf()) {
                this.validateProperty(collectionProperty.getElement(), currentPath, namingStrategy, mappingObject, optional, problems);
            }
        }
        if (property.isMap()) {
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            if (mapProperty.getValueProperty().isGroup()) {
                try {
                    Map map = (Map)property.getMethod().invoke(mappingObject, new Object[0]);
                    for (Map.Entry entry : map.entrySet()) {
                        this.validateMappingInterface(mapProperty.getValueProperty().asGroup().getGroupType(), this.appendPropertyName(currentPath, property) + "." + entry.getKey(), namingStrategy, entry.getValue(), problems);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
                catch (InvocationTargetException e) {
                    try {
                        throw e.getCause();
                    }
                    catch (Error | RuntimeException e2) {
                        throw e2;
                    }
                    catch (Throwable t2) {
                        throw new UndeclaredThrowableException(t2);
                    }
                }
            } else if (mapProperty.getValueProperty().isLeaf()) {
                this.validatePropertyValue(property, currentPath, namingStrategy, mappingObject, problems);
            }
        }
    }

    default public void validatePropertyValue(ConfigMappingInterface.Property property, String currentPath, ConfigMappingInterface.NamingStrategy namingStrategy, Object mappingObject, List<ConfigValidationException.Problem> problems) {
        try {
            Set violations = this.getValidator().forExecutables().validateReturnValue(mappingObject, property.getMethod(), property.getMethod().invoke(mappingObject, new Object[0]), new Class[0]);
            for (ConstraintViolation violation : violations) {
                problems.add(new ConfigValidationException.Problem(this.interpolateMessage(currentPath, namingStrategy, property, violation)));
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t2) {
                throw new UndeclaredThrowableException(t2);
            }
        }
    }

    default public void validateMappingClass(Object mappingObject, List<ConfigValidationException.Problem> problems) {
        Set violations = this.getValidator().validate(mappingObject, new Class[0]);
        for (ConstraintViolation violation : violations) {
            problems.add(new ConfigValidationException.Problem(violation.getPropertyPath() + " " + violation.getMessage()));
        }
    }

    default public String appendPropertyName(String currentPath, ConfigMappingInterface.Property property) {
        if (currentPath.isEmpty()) {
            return property.getPropertyName();
        }
        if (property.getPropertyName().isEmpty()) {
            return currentPath;
        }
        return currentPath + "." + property.getPropertyName();
    }

    default public String interpolateMessage(String currentPath, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface.Property property, ConstraintViolation<?> violation) {
        StringBuilder propertyName = new StringBuilder(currentPath);
        String name = (String)namingStrategy.apply((Object)property.getPropertyName());
        if (!name.isEmpty()) {
            propertyName.append(".").append(name);
        }
        Path propertyPath = violation.getPropertyPath();
        for (Path.Node node : propertyPath) {
            if (!node.isInIterable()) continue;
            if (node.getIndex() != null) {
                propertyName.append("[").append(node.getIndex()).append("]");
                continue;
            }
            if (node.getKey() == null) continue;
            propertyName.append(".").append(node.getKey());
        }
        return propertyName.toString() + " " + violation.getMessage();
    }
}

